/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.logging;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.util.text.StringUtil;
import io.flutter.inspector.DiagnosticLevel;
import io.flutter.inspector.DiagnosticsNode;
import java.util.regex.Pattern;

public class FlutterErrorHelper {
    private static final Pattern numberPattern = Pattern.compile("[0-9]+(\\.[0-9]+)?");

    public static String getAnalyticsId(DiagnosticsNode node) {
        for (DiagnosticsNode property : node.getInlineProperties()) {
            if (property.getLevel() != DiagnosticLevel.summary) continue;
            String description = property.getDescription();
            return FlutterErrorHelper.getAnalyticsId(description);
        }
        return null;
    }

    @VisibleForTesting
    public static String getAnalyticsId(String errorSummary) {
        String normalized = errorSummary.toLowerCase().trim();
        String[] lines = (normalized = normalized.replaceAll(": failed assertion:", ":\nfailed assertion:")).split("\n");
        if (lines.length >= 2 && lines[0].endsWith(".dart':") && lines[1].startsWith("failed assertion:")) {
            normalized = StringUtil.join((String[])lines, (int)1, (int)lines.length, (String)"\n");
            normalized = normalized.trim();
        }
        if (normalized.contains(". ")) {
            normalized = normalized.substring(0, normalized.indexOf(". "));
            normalized = normalized.trim();
        }
        if (normalized.contains("\n")) {
            normalized = normalized.substring(0, normalized.indexOf("\n"));
        }
        if (normalized.contains(":")) {
            normalized = normalized.substring(0, normalized.indexOf(":"));
        }
        if (normalized.endsWith(".")) {
            normalized = normalized.substring(0, normalized.length() - ".".length());
        }
        normalized = normalized.replaceAll("\\([^)]*\\)", "");
        normalized = numberPattern.matcher(normalized).replaceAll("xxx");
        normalized = normalized.replaceAll("\\s+", " ");
        normalized = normalized.trim();
        normalized = normalized.trim().replaceAll(" ", "-");
        return normalized;
    }
}

