/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.module;

import com.intellij.icons.AllIcons;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.xml.util.XmlStringUtil;
import io.flutter.FlutterBundle;
import io.flutter.module.settings.SettingsHelpForm;
import io.flutter.sdk.FlutterSdk;
import io.flutter.sdk.FlutterSdkUtil;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxEditor;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlutterGeneratorPeer {
    private final WizardContext myContext;
    private JPanel myMainPanel;
    private ComboboxWithBrowseButton mySdkPathComboWithBrowse;
    private JBLabel myVersionContent;
    private JLabel errorIcon;
    private JTextPane errorText;
    private JScrollPane errorPane;
    private SettingsHelpForm myHelpForm;

    public FlutterGeneratorPeer(WizardContext context) {
        this.myContext = context;
        this.$$$setupUI$$$();
        this.errorIcon.setText("");
        this.errorIcon.setIcon(AllIcons.Actions.Lightning);
        Messages.installHyperlinkSupport((JTextPane)this.errorText);
        this.myVersionContent.setVisible(false);
        this.myHelpForm.getComponent().setVisible(false);
        this.init();
    }

    private void init() {
        this.mySdkPathComboWithBrowse.getComboBox().setEditable(true);
        FlutterSdkUtil.addKnownSDKPathsToCombo(this.mySdkPathComboWithBrowse.getComboBox());
        this.mySdkPathComboWithBrowse.addBrowseFolderListener(FlutterBundle.message("flutter.sdk.browse.path.label", new Object[0]), null, null, FileChooserDescriptorFactory.createSingleFolderDescriptor(), TextComponentAccessor.STRING_COMBOBOX_WHOLE_TEXT);
        this.mySdkPathComboWithBrowse.getComboBox().addActionListener(e -> this.fillSdkCache());
        this.fillSdkCache();
        JTextComponent editorComponent = (JTextComponent)this.getSdkEditor().getEditorComponent();
        editorComponent.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                FlutterGeneratorPeer.this.validate();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "io/flutter/module/FlutterGeneratorPeer$1", "textChanged"));
            }
        });
        this.errorIcon.setVisible(false);
        this.errorPane.setVisible(false);
    }

    private void fillSdkCache() {
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            FlutterSdk sdk;
            String path = (String)this.mySdkPathComboWithBrowse.getComboBox().getSelectedItem();
            if (path != null && (sdk = FlutterSdk.forPath(path)) != null) {
                sdk.queryConfiguredPlatforms(false);
                sdk.queryFlutterChannel(false);
            }
        });
    }

    void apply() {
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            FlutterGeneratorPeer.$$$reportNull$$$0(0);
        }
        return jPanel;
    }

    private void createUIComponents() {
        this.mySdkPathComboWithBrowse = new ComboboxWithBrowseButton((JComboBox)new ComboBox());
    }

    public boolean validate() {
        ValidationInfo info = this.validateSdk();
        if (info != null) {
            this.errorText.setText(XmlStringUtil.wrapInHtml((CharSequence)info.message));
        }
        this.errorIcon.setVisible(info != null);
        this.errorPane.setVisible(info != null);
        return info == null;
    }

    @Nullable
    private ValidationInfo validateSdk() {
        String sdkPath = this.getSdkComboPath();
        if (StringUtils.isEmpty((CharSequence)sdkPath)) {
            return new ValidationInfo("A Flutter SDK must be specified for project creation.", (JComponent)this.mySdkPathComboWithBrowse);
        }
        String message = FlutterSdkUtil.getErrorMessageIfWrongSdkRootPath(sdkPath);
        if (message != null) {
            return new ValidationInfo(message, (JComponent)this.mySdkPathComboWithBrowse);
        }
        return null;
    }

    @NotNull
    public String getSdkComboPath() {
        String string = FileUtilRt.toSystemIndependentName((String)this.getSdkEditor().getItem().toString().trim());
        if (string == null) {
            FlutterGeneratorPeer.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public ComboBoxEditor getSdkEditor() {
        ComboBoxEditor comboBoxEditor = this.mySdkPathComboWithBrowse.getComboBox().getEditor();
        if (comboBoxEditor == null) {
            FlutterGeneratorPeer.$$$reportNull$$$0(2);
        }
        return comboBoxEditor;
    }

    public SettingsHelpForm getHelpForm() {
        return this.myHelpForm;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        SettingsHelpForm settingsHelpForm;
        JTextPane jTextPane;
        JScrollPane jScrollPane;
        JLabel jLabel;
        JBLabel jBLabel;
        JPanel jPanel;
        this.createUIComponents();
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(6, 12, new Insets(0, 5, 0, 8), -1, -1, false, false));
        JBLabel jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, ResourceBundle.getBundle("io/flutter/FlutterBundle").getString("flutter.sdk.path.label"));
        jPanel.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        ComboboxWithBrowseButton comboboxWithBrowseButton = this.mySdkPathComboWithBrowse;
        jPanel.add((Component)comboboxWithBrowseButton, new GridConstraints(0, 2, 1, 10, 0, 1, 7, 0, null, null, null));
        this.myVersionContent = jBLabel = new JBLabel();
        jBLabel.setText("");
        jPanel.add((Component)jBLabel, new GridConstraints(2, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(4, 0, 1, 2, 0, 2, 1, 6, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), 0, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(5, 0, 1, 12, 0, 3, 3, 3, null, null, null));
        this.errorIcon = jLabel = new JLabel();
        jLabel.setText("icon_placeholder");
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.errorPane = jScrollPane = new JScrollPane();
        jPanel2.add((Component)jScrollPane, new GridConstraints(0, 1, 1, 1, 0, 3, 7, 7, null, null, null));
        jScrollPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), null, 0, 0, null, null));
        this.errorText = jTextPane = new JTextPane();
        jTextPane.setText("Error text placeholder");
        jScrollPane.setViewportView(jTextPane);
        this.myHelpForm = settingsHelpForm = new SettingsHelpForm();
        JComponent jComponent = settingsHelpForm.$$$getRootComponent$$$();
        jPanel.add((Component)jComponent, new GridConstraints(1, 0, 1, 12, 0, 1, 6, 0, null, null, null));
        jBLabel2.setLabelFor((Component)comboboxWithBrowseButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "io/flutter/module/FlutterGeneratorPeer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdkComboPath";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdkEditor";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

