/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.module;

import com.intellij.execution.OutputListener;
import com.intellij.execution.process.ProcessListener;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.SettingsStep;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleWithNameAlreadyExists;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import icons.FlutterIcons;
import io.flutter.FlutterBundle;
import io.flutter.FlutterConstants;
import io.flutter.FlutterMessages;
import io.flutter.FlutterUtils;
import io.flutter.actions.FlutterDoctorAction;
import io.flutter.module.FlutterGeneratorPeer;
import io.flutter.module.settings.FlutterCreateAdditionalSettingsFields;
import io.flutter.module.settings.SettingsHelpForm;
import io.flutter.pub.PubRoot;
import io.flutter.sdk.FlutterCreateAdditionalSettings;
import io.flutter.sdk.FlutterSdk;
import io.flutter.sdk.FlutterSdkUtil;
import io.flutter.utils.AndroidUtils;
import io.flutter.utils.FlutterModuleUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.ComboBoxEditor;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlutterModuleBuilder
extends ModuleBuilder {
    private static final Logger LOG = Logger.getInstance(FlutterModuleBuilder.class);
    protected FlutterModuleWizardStep myStep;
    private FlutterCreateAdditionalSettingsFields mySettingsFields;
    protected Project myProject;

    public String getName() {
        return this.getPresentableName();
    }

    @Nullable
    public Project getProject() {
        return this.myProject;
    }

    public String getPresentableName() {
        return FlutterBundle.message("flutter.module.name", new Object[0]);
    }

    public String getDescription() {
        return FlutterBundle.message("flutter.project.description", new Object[0]);
    }

    public Icon getNodeIcon() {
        return FlutterIcons.Flutter;
    }

    public void setupRootModel(@NotNull ModifiableRootModel model) {
        if (model == null) {
            FlutterModuleBuilder.$$$reportNull$$$0(0);
        }
        this.doAddContentEntry(model);
        model.addInvalidLibrary("Dart SDK", "project");
    }

    protected FlutterSdk getFlutterSdk() {
        return this.myStep.getFlutterSdk();
    }

    @Nullable
    public Module commitModule(@NotNull Project project, @Nullable ModifiableModuleModel model) {
        String basePath;
        if (project == null) {
            FlutterModuleBuilder.$$$reportNull$$$0(1);
        }
        if ((basePath = this.getModuleFileDirectory()) == null) {
            Messages.showErrorDialog((String)"Module path not set", (String)"Internal Error");
            return null;
        }
        VirtualFile baseDir = LocalFileSystem.getInstance().refreshAndFindFileByPath(basePath);
        if (baseDir == null) {
            Messages.showErrorDialog((String)"Unable to determine Flutter project directory", (String)"Internal Error");
            return null;
        }
        FlutterSdk sdk = this.getFlutterSdk();
        if (sdk == null) {
            Messages.showErrorDialog((String)"Flutter SDK not found", (String)"Error");
            return null;
        }
        OutputListener listener = new OutputListener();
        @NotNull FlutterCreateAdditionalSettings settings = this.getAdditionalSettings();
        settings.setProjectName(super.getName());
        PubRoot root = FlutterModuleBuilder.runFlutterCreateWithProgress(baseDir, sdk, project, (ProcessListener)listener, settings);
        if (root == null) {
            String stderr = listener.getOutput().getStderr();
            String msg = stderr.isEmpty() ? "Flutter create command was unsuccessful" : stderr;
            int code = FlutterMessages.showDialog(project, msg, "Project Creation Error", new String[]{"Run Flutter Doctor", "Cancel"}, 0);
            if (code == 0) {
                new FlutterDoctorAction().startCommand(project, sdk, null);
            }
            return null;
        }
        FlutterSdkUtil.updateKnownSdkPaths(sdk.getHomePath());
        Module flutter = super.commitModule(project, model);
        if (flutter == null) {
            return null;
        }
        FlutterModuleUtils.autoShowMain(project, root);
        this.showProjectInProjectWindow(project);
        return flutter;
    }

    private void showProjectInProjectWindow(@NotNull Project project) {
        if (project == null) {
            FlutterModuleBuilder.$$$reportNull$$$0(2);
        }
        ApplicationManager.getApplication().invokeLater(() -> DumbService.getInstance((Project)project).runWhenSmart(() -> ApplicationManager.getApplication().invokeLater(() -> {
            ProjectView view = ProjectView.getInstance((Project)project);
            if (view == null) {
                return;
            }
            view.changeView("ProjectPane");
        })));
    }

    private String validateSettings(FlutterCreateAdditionalSettings settings) {
        String description = settings.getDescription();
        if (description != null && description.contains(": ")) {
            return FlutterBundle.message("npw_invalid_desc_error", new Object[0]);
        }
        String org = settings.getOrg();
        if (org == null) {
            return null;
        }
        if (StringUtils.endsWith((CharSequence)org, (CharSequence)".")) {
            return FlutterBundle.message("npw_invalid_org_error", new Object[0]);
        }
        if (this.mySettingsFields.shouldIncludePlatforms() && !settings.isSomePlatformSelected()) {
            return FlutterBundle.message("npw_none_selected_error", new Object[0]);
        }
        return AndroidUtils.validateAndroidPackageName(org);
    }

    public static void addAndroidModule(@NotNull Project project, @Nullable ModifiableModuleModel model, @NotNull String baseDirPath, @NotNull String flutterModuleName, boolean isTopLevel) {
        VirtualFile androidFile;
        VirtualFile baseDir;
        if (project == null) {
            FlutterModuleBuilder.$$$reportNull$$$0(3);
        }
        if (baseDirPath == null) {
            FlutterModuleBuilder.$$$reportNull$$$0(4);
        }
        if (flutterModuleName == null) {
            FlutterModuleBuilder.$$$reportNull$$$0(5);
        }
        if ((baseDir = LocalFileSystem.getInstance().refreshAndFindFileByPath(baseDirPath)) == null) {
            return;
        }
        VirtualFile virtualFile = androidFile = isTopLevel ? FlutterModuleBuilder.findAndroidModuleFile(baseDir, flutterModuleName) : FlutterModuleBuilder.findEmbeddedModuleFile(baseDir, flutterModuleName);
        if (androidFile == null) {
            return;
        }
        FlutterModuleBuilder.addAndroidModuleFromFile(project, model, androidFile);
    }

    public static void addAndroidModuleFromFile(@NotNull Project project, @Nullable ModifiableModuleModel model, @NotNull VirtualFile androidFile) {
        if (project == null) {
            FlutterModuleBuilder.$$$reportNull$$$0(6);
        }
        if (androidFile == null) {
            FlutterModuleBuilder.$$$reportNull$$$0(7);
        }
        try {
            ModifiableModuleModel toCommit;
            if (model == null) {
                model = toCommit = ModuleManager.getInstance((Project)project).getModifiableModel();
            } else {
                toCommit = null;
            }
            Module newModule = model.loadModule(androidFile.getPath());
            if (toCommit != null) {
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (ModuleManager.getInstance((Project)project).findModuleByName(newModule.getName()) == null) {
                        WriteAction.run(() -> ((ModifiableModuleModel)toCommit).commit());
                    }
                });
            }
        }
        catch (ModuleWithNameAlreadyExists | IOException e) {
            FlutterUtils.warn(LOG, e);
        }
    }

    @Nullable
    private static VirtualFile findAndroidModuleFile(@NotNull VirtualFile baseDir, String flutterModuleName) {
        if (baseDir == null) {
            FlutterModuleBuilder.$$$reportNull$$$0(8);
        }
        baseDir.refresh(false, false);
        for (String name : Arrays.asList(flutterModuleName + "_android.iml", "android.iml")) {
            VirtualFile candidate = baseDir.findChild(name);
            if (candidate == null || !candidate.exists()) continue;
            return candidate;
        }
        return null;
    }

    @Nullable
    private static VirtualFile findEmbeddedModuleFile(@NotNull VirtualFile baseDir, String flutterModuleName) {
        if (baseDir == null) {
            FlutterModuleBuilder.$$$reportNull$$$0(9);
        }
        baseDir.refresh(false, false);
        for (String name : Arrays.asList("android", ".android")) {
            VirtualFile candidate;
            VirtualFile dir = baseDir.findChild(name);
            if (dir == null || !dir.exists() || (candidate = dir.findChild(flutterModuleName + "_android.iml")) == null || !candidate.exists()) continue;
            return candidate;
        }
        return null;
    }

    public boolean validate(@Nullable Project current, @NotNull Project dest) {
        String settingsValidation;
        if (dest == null) {
            FlutterModuleBuilder.$$$reportNull$$$0(10);
        }
        if ((settingsValidation = this.validateSettings(this.getAdditionalSettings())) != null) {
            Messages.showErrorDialog((String)settingsValidation, (String)"Error");
            try {
                Files.deleteIfExists(Path.of(dest.getBasePath(), new String[0]));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return false;
        }
        return this.myStep.getFlutterSdk() != null;
    }

    public boolean validateModuleName(@NotNull String moduleName) throws ConfigurationException {
        if (moduleName == null) {
            FlutterModuleBuilder.$$$reportNull$$$0(11);
        }
        if (!FlutterUtils.isValidPackageName(moduleName)) {
            throw new ConfigurationException("Invalid module name: '" + moduleName + "' - must be a valid Dart package name (lower_case_with_underscores).");
        }
        if (FlutterUtils.isDartKeyword(moduleName)) {
            throw new ConfigurationException("Invalid module name: '" + moduleName + "' - must not be a Dart keyword.");
        }
        if (!FlutterUtils.isValidDartIdentifier(moduleName)) {
            throw new ConfigurationException("Invalid module name: '" + moduleName + "' - must be a valid Dart identifier.");
        }
        if (FlutterConstants.FLUTTER_PACKAGE_DEPENDENCIES.contains(moduleName)) {
            throw new ConfigurationException("Invalid module name: '" + moduleName + "' - this will conflict with Flutter package dependencies.");
        }
        return super.validateModuleName(moduleName);
    }

    @NotNull
    public FlutterCreateAdditionalSettings getAdditionalSettings() {
        FlutterCreateAdditionalSettings flutterCreateAdditionalSettings = this.mySettingsFields.getAdditionalSettings();
        if (flutterCreateAdditionalSettings == null) {
            FlutterModuleBuilder.$$$reportNull$$$0(12);
        }
        return flutterCreateAdditionalSettings;
    }

    @Nullable
    public ModuleWizardStep modifySettingsStep(@NotNull SettingsStep settingsStep) {
        if (settingsStep == null) {
            FlutterModuleBuilder.$$$reportNull$$$0(13);
        }
        ModuleWizardStep wizard = super.modifySettingsStep(settingsStep);
        this.mySettingsFields.addSettingsFields(settingsStep);
        return wizard;
    }

    public ModuleWizardStep modifyProjectTypeStep(@NotNull SettingsStep settingsStep) {
        if (settingsStep == null) {
            FlutterModuleBuilder.$$$reportNull$$$0(14);
        }
        return null;
    }

    public ModuleWizardStep getCustomOptionsStep(WizardContext context, Disposable parentDisposable) {
        if (!context.isCreatingNewProject()) {
            this.myProject = context.getProject();
        }
        this.myStep = new FlutterModuleWizardStep(context);
        this.mySettingsFields = new FlutterCreateAdditionalSettingsFields(new FlutterCreateAdditionalSettings(), this::getFlutterSdk);
        Disposer.register((Disposable)parentDisposable, (Disposable)this.myStep);
        return this.myStep;
    }

    public String getBuilderId() {
        return StringUtil.notNullize((String)super.getBuilderId()) + "_" + FlutterModuleBuilder.class.getCanonicalName();
    }

    @NotNull
    public ModuleType<?> getModuleType() {
        ModuleType<?> moduleType = FlutterModuleUtils.getFlutterModuleType();
        if (moduleType == null) {
            FlutterModuleBuilder.$$$reportNull$$$0(15);
        }
        return moduleType;
    }

    @Nullable
    public static PubRoot runFlutterCreateWithProgress(@NotNull VirtualFile baseDir, @NotNull FlutterSdk sdk, @NotNull Project project, @Nullable ProcessListener processListener, @Nullable FlutterCreateAdditionalSettings additionalSettings) {
        if (baseDir == null) {
            FlutterModuleBuilder.$$$reportNull$$$0(16);
        }
        if (sdk == null) {
            FlutterModuleBuilder.$$$reportNull$$$0(17);
        }
        if (project == null) {
            FlutterModuleBuilder.$$$reportNull$$$0(18);
        }
        ProgressManager progress = ProgressManager.getInstance();
        AtomicReference<Object> result = new AtomicReference<Object>(null);
        FlutterUtils.disableGradleProjectMigrationNotification(project);
        progress.runProcessWithProgressSynchronously(() -> {
            progress.getProgressIndicator().setIndeterminate(true);
            result.set(sdk.createFiles(baseDir, null, processListener, additionalSettings));
        }, "Creating Flutter project", false, project);
        return result.get();
    }

    public void setFlutterSdkPath(String s) {
        ComboBoxEditor combo = this.myStep.myPeer.getSdkEditor();
        combo.setItem(s);
    }

    public FlutterCreateAdditionalSettingsFields getSettingsField() {
        return this.mySettingsFields;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 12, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDirPath";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flutterModuleName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidFile";
                break;
            }
            case 8: 
            case 9: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dest";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/module/FlutterModuleBuilder";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsStep";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/module/FlutterModuleBuilder";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalSettings";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setupRootModel";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "commitModule";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "showProjectInProjectWindow";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addAndroidModule";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addAndroidModuleFromFile";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findAndroidModuleFile";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findEmbeddedModuleFile";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "validate";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "validateModuleName";
                break;
            }
            case 12: 
            case 15: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "modifySettingsStep";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "modifyProjectTypeStep";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "runFlutterCreateWithProgress";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 12, 15 -> new IllegalStateException(string);
        };
    }

    public class FlutterModuleWizardStep
    extends ModuleWizardStep
    implements Disposable {
        private final FlutterGeneratorPeer myPeer;

        public FlutterModuleWizardStep(WizardContext context) {
            if (context == null) {
                FlutterModuleWizardStep.$$$reportNull$$$0(0);
            }
            this.myPeer = new FlutterGeneratorPeer(context);
            if (!FlutterUtils.isAndroidStudio()) {
                this.myPeer.getHelpForm().showGettingStarted();
            }
        }

        public SettingsHelpForm getHelpForm() {
            return this.myPeer.getHelpForm();
        }

        public JComponent getComponent() {
            return this.myPeer.getComponent();
        }

        public void updateDataModel() {
            FlutterModuleBuilder.this.mySettingsFields.updateProjectTypes();
        }

        public boolean validate() {
            boolean valid = this.myPeer.validate();
            if (valid) {
                this.myPeer.apply();
            }
            return valid;
        }

        public void dispose() {
        }

        @Nullable
        FlutterSdk getFlutterSdk() {
            String sdkPath = this.myPeer.getSdkComboPath();
            if (!sdkPath.isEmpty()) {
                try {
                    LocalFileSystem.getInstance().refreshAndFindFileByPath(sdkPath);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return FlutterSdk.forPath(sdkPath);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "io/flutter/module/FlutterModuleBuilder$FlutterModuleWizardStep", "<init>"));
        }
    }
}

