/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.module.settings;

import com.intellij.ide.util.projectWizard.SettingsStep;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.ui.DocumentAdapter;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import io.flutter.FlutterBundle;
import io.flutter.FlutterUtils;
import io.flutter.module.FlutterProjectType;
import io.flutter.module.settings.FlutterCreateParams;
import io.flutter.module.settings.PlatformsForm;
import io.flutter.module.settings.ProjectType;
import io.flutter.module.settings.RadiosForm;
import io.flutter.module.settings.SettingsHelpForm;
import io.flutter.sdk.FlutterCreateAdditionalSettings;
import io.flutter.sdk.FlutterSdk;
import java.awt.Component;
import java.awt.Insets;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.border.AbstractBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;

public class FlutterCreateAdditionalSettingsFields {
    private final FlutterCreateAdditionalSettings settings;
    private final JTextField orgField;
    private final JTextField descriptionField;
    private final RadiosForm androidLanguageRadios;
    private final RadiosForm iosLanguageRadios;
    private final ProjectType projectTypeForm;
    private final PlatformsForm platformsForm;
    private final FlutterCreateParams createParams;
    private SettingsHelpForm helpForm;
    private DialogPanel panel;

    public FlutterCreateAdditionalSettingsFields(FlutterCreateAdditionalSettings additionalSettings, Supplier<? extends FlutterSdk> getSdk) {
        this.settings = additionalSettings;
        this.projectTypeForm = new ProjectType(getSdk);
        this.projectTypeForm.addListener(e -> {
            if (e.getStateChange() == 1) {
                FlutterProjectType type = this.projectTypeForm.getType();
                this.settings.setType(type);
                this.changeVisibility(type);
            }
        });
        this.orgField = new JTextField();
        this.orgField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                FlutterCreateAdditionalSettingsFields.this.settings.setOrg(FlutterCreateAdditionalSettingsFields.this.orgField.getText());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "io/flutter/module/settings/FlutterCreateAdditionalSettingsFields$1", "textChanged"));
            }
        });
        this.orgField.setText(FlutterBundle.message("flutter.module.create.settings.org.default_text", new Object[0]));
        this.orgField.setToolTipText(FlutterBundle.message("flutter.module.create.settings.org.tip", new Object[0]));
        this.descriptionField = new JTextField();
        this.descriptionField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                FlutterCreateAdditionalSettingsFields.this.settings.setDescription(FlutterCreateAdditionalSettingsFields.this.descriptionField.getText());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "io/flutter/module/settings/FlutterCreateAdditionalSettingsFields$2", "textChanged"));
            }
        });
        this.descriptionField.setToolTipText(FlutterBundle.message("flutter.module.create.settings.description.tip", new Object[0]));
        this.descriptionField.setText(FlutterBundle.message("flutter.module.create.settings.description.default_text", new Object[0]));
        this.androidLanguageRadios = new RadiosForm(FlutterBundle.message("flutter.module.create.settings.radios.android.java", new Object[0]), FlutterBundle.message("flutter.module.create.settings.radios.android.kotlin", new Object[0]));
        this.androidLanguageRadios.addItemListener(e -> {
            boolean isJavaSelected = e.getStateChange() == 1;
            this.settings.setKotlin(!isJavaSelected);
        });
        this.androidLanguageRadios.setToolTipText(FlutterBundle.message("flutter.module.create.settings.radios.android.tip", new Object[0]));
        this.iosLanguageRadios = new RadiosForm(FlutterBundle.message("flutter.module.create.settings.radios.ios.object_c", new Object[0]), FlutterBundle.message("flutter.module.create.settings.radios.ios.swift", new Object[0]));
        this.androidLanguageRadios.addItemListener(e -> {
            boolean isObjcSelected = e.getStateChange() == 1;
            this.settings.setSwift(!isObjcSelected);
        });
        this.iosLanguageRadios.setToolTipText(FlutterBundle.message("flutter.module.create.settings.radios.ios.tip", new Object[0]));
        this.platformsForm = new PlatformsForm();
        this.createParams = new FlutterCreateParams();
    }

    private void changeVisibility(FlutterProjectType projectType) {
        boolean areLanguageFeaturesVisible;
        boolean bl = areLanguageFeaturesVisible = projectType != FlutterProjectType.PACKAGE && projectType != FlutterProjectType.MODULE;
        if (this.helpForm != null) {
            this.helpForm.adjustContrast(projectType);
        }
        this.orgField.setEnabled(projectType != FlutterProjectType.PACKAGE);
        UIUtil.setEnabled((Component)this.androidLanguageRadios.getComponent(), (boolean)areLanguageFeaturesVisible, (boolean)true, (boolean)true);
        UIUtil.setEnabled((Component)this.iosLanguageRadios.getComponent(), (boolean)areLanguageFeaturesVisible, (boolean)true, (boolean)true);
        UIUtil.setEnabled((Component)this.platformsForm.getComponent(), (boolean)areLanguageFeaturesVisible, (boolean)true, (boolean)true);
    }

    private void changeSettingsItemVisibility(JComponent component, boolean areLanguageFeaturesVisible) {
        int index;
        if (component.getParent() == null) {
            return;
        }
        Component[] components = component.getParent().getComponents();
        for (index = 0; index < components.length && components[index] != component; ++index) {
        }
        Component label = components[index - 1];
        component.setVisible(areLanguageFeaturesVisible);
        label.setVisible(areLanguageFeaturesVisible);
    }

    public void addSettingsFields(@NotNull SettingsStep settingsStep) {
        if (settingsStep == null) {
            FlutterCreateAdditionalSettingsFields.$$$reportNull$$$0(0);
        }
        settingsStep.addSettingsField(FlutterBundle.message("flutter.module.create.settings.description.label", new Object[0]), (JComponent)this.descriptionField);
        settingsStep.addSettingsField(FlutterBundle.message("flutter.module.create.settings.type.label", new Object[0]), this.projectTypeForm.getComponent());
        settingsStep.addSettingsField(FlutterBundle.message("flutter.module.create.settings.radios.org.label", new Object[0]), (JComponent)this.orgField);
        this.addBorder(this.androidLanguageRadios.getComponent(), false);
        settingsStep.addSettingsField(FlutterBundle.message("flutter.module.create.settings.radios.android.label", new Object[0]), this.androidLanguageRadios.getComponent());
        this.addBorder(this.iosLanguageRadios.getComponent(), false);
        settingsStep.addSettingsField(FlutterBundle.message("flutter.module.create.settings.radios.ios.label", new Object[0]), this.iosLanguageRadios.getComponent());
        this.panel = this.platformsForm.panel(this.settings);
        this.addBorder((JComponent)this.panel, true);
        settingsStep.addSettingsField(FlutterBundle.message("flutter.module.create.settings.platforms.label", new Object[0]), (JComponent)this.panel);
        if (!FlutterUtils.isAndroidStudio()) {
            settingsStep.addSettingsComponent(new SettingsHelpForm().getComponent());
        }
        settingsStep.addSettingsComponent(this.createParams.setInitialValues().getComponent());
    }

    private void addBorder(JComponent c, final boolean left) {
        c.setBorder(new AbstractBorder(){

            @Override
            public Insets getBorderInsets(Component c, Insets insets) {
                return JBUI.insets((int)5, (int)(left ? 3 : 0), (int)0, (int)0);
            }
        });
    }

    public void updateProjectType(FlutterProjectType projectType) {
    }

    public FlutterCreateAdditionalSettings getAdditionalSettings() {
        return new FlutterCreateAdditionalSettings.Builder().setDescription(!this.descriptionField.getText().trim().isEmpty() ? this.descriptionField.getText().trim() : null).setType(this.projectTypeForm.getType()).setKotlin(this.androidLanguageRadios.isRadio2Selected() ? Boolean.valueOf(true) : null).setOrg(!this.orgField.getText().trim().isEmpty() ? this.orgField.getText().trim() : null).setSwift(this.iosLanguageRadios.isRadio2Selected() ? Boolean.valueOf(true) : null).setOffline(this.createParams.isOfflineSelected()).setPlatformAndroid(this.shouldIncludePlatforms() ? this.settings.getPlatformAndroid() : null).setPlatformIos(this.shouldIncludePlatforms() ? this.settings.getPlatformIos() : null).setPlatformLinux(this.shouldIncludePlatforms() ? this.settings.getPlatformLinux() : null).setPlatformMacos(this.shouldIncludePlatforms() ? this.settings.getPlatformMacos() : null).setPlatformWeb(this.shouldIncludePlatforms() && this.projectTypeForm.getType() != FlutterProjectType.PLUGIN_FFI ? this.settings.getPlatformWeb() : null).setPlatformWindows(this.shouldIncludePlatforms() ? this.settings.getPlatformWindows() : null).build();
    }

    public boolean shouldIncludePlatforms() {
        switch (this.projectTypeForm.getType()) {
            case APP: 
            case SKELETON: 
            case PLUGIN: 
            case PLUGIN_FFI: 
            case EMPTY_PROJECT: {
                return true;
            }
        }
        return false;
    }

    public FlutterCreateAdditionalSettings getSettings() {
        return this.settings;
    }

    public void linkHelpForm(SettingsHelpForm form) {
        this.helpForm = form;
    }

    public void updateProjectTypes() {
        this.projectTypeForm.updateProjectTypes();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settingsStep", "io/flutter/module/settings/FlutterCreateAdditionalSettingsFields", "addSettingsFields"));
    }
}

