/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.module.settings;

import com.intellij.openapi.ui.ComboBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import io.flutter.FlutterBundle;
import io.flutter.FlutterUtils;
import io.flutter.module.FlutterProjectType;
import io.flutter.sdk.FlutterSdk;
import io.flutter.sdk.FlutterSdkVersion;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.function.Supplier;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectType {
    private Supplier<? extends FlutterSdk> getSdk;
    private JPanel projectTypePanel;
    private ComboBox<FlutterProjectType> projectTypeCombo;

    public ProjectType(@Nullable Supplier<? extends FlutterSdk> getSdk) {
        this.getSdk = getSdk;
        this.$$$setupUI$$$();
    }

    public ProjectType() {
        this.$$$setupUI$$$();
    }

    private void createUIComponents() {
        this.projectTypeCombo = new ComboBox();
        this.projectTypeCombo.setModel((ComboBoxModel)new ProjectTypeComboBoxModel());
        this.projectTypeCombo.setToolTipText(FlutterBundle.message("flutter.module.create.settings.type.tip", new Object[0]));
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.projectTypePanel;
        if (jPanel == null) {
            ProjectType.$$$reportNull$$$0(0);
        }
        return jPanel;
    }

    public FlutterProjectType getType() {
        return (FlutterProjectType)((Object)this.projectTypeCombo.getSelectedItem());
    }

    public ComboBox<FlutterProjectType> getProjectTypeCombo() {
        return this.projectTypeCombo;
    }

    public void setSdk(@NotNull Supplier<? extends FlutterSdk> sdk) {
        if (sdk == null) {
            ProjectType.$$$reportNull$$$0(1);
        }
        this.getSdk = sdk;
    }

    public void addListener(ItemListener listener) {
        this.projectTypeCombo.addItemListener(listener);
    }

    public void updateProjectTypes() {
        FlutterSdkVersion version = this.getSdk.get().getVersion();
        ProjectTypeComboBoxModel model = (ProjectTypeComboBoxModel)this.projectTypeCombo.getModel();
        if (version.isSkeletonTemplateAvailable()) {
            model.addSkeleton();
        } else {
            model.removeSkeleton();
        }
        if (version.isPluginFfiTemplateAvailable()) {
            model.addPluginFfi();
        } else {
            model.removePluginFfi();
        }
        if (version.isEmptyProjectAvailable()) {
            model.addEmptyProject();
        } else {
            model.removeEmptyProject();
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        this.createUIComponents();
        this.projectTypePanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ComboBox<FlutterProjectType> comboBox = this.projectTypeCombo;
        comboBox.setToolTipText(ResourceBundle.getBundle("io/flutter/FlutterBundle").getString("flutter.module.create.settings.type.tip"));
        jPanel.add((Component)comboBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.projectTypePanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/module/settings/ProjectType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/module/settings/ProjectType";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setSdk";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }

    private static final class ProjectTypeComboBoxModel
    extends AbstractListModel<FlutterProjectType>
    implements ComboBoxModel<FlutterProjectType> {
        private final List<FlutterProjectType> myList = new ArrayList<FlutterProjectType>(EnumSet.allOf(FlutterProjectType.class));
        private FlutterProjectType mySelected;

        private ProjectTypeComboBoxModel() {
            if (System.getProperty("flutter.experimental.modules", null) == null) {
                if (!FlutterUtils.isAndroidStudio()) {
                    this.myList.remove((Object)FlutterProjectType.MODULE);
                }
                this.myList.remove((Object)FlutterProjectType.IMPORT);
            }
            this.mySelected = this.myList.get(0);
        }

        @Override
        public int getSize() {
            return this.myList.size();
        }

        @Override
        public FlutterProjectType getElementAt(int index) {
            return this.myList.get(index);
        }

        @Override
        public void setSelectedItem(Object item) {
            this.setSelectedItem((FlutterProjectType)((Object)item));
        }

        public FlutterProjectType getSelectedItem() {
            return this.mySelected;
        }

        public void setSelectedItem(FlutterProjectType item) {
            this.mySelected = item;
            this.fireContentsChanged(this, 0, this.getSize());
        }

        void addSkeleton() {
            if (!this.myList.contains((Object)FlutterProjectType.SKELETON)) {
                this.myList.add(FlutterProjectType.SKELETON);
            }
        }

        void removeSkeleton() {
            this.myList.remove((Object)FlutterProjectType.SKELETON);
        }

        void addPluginFfi() {
            if (!this.myList.contains((Object)FlutterProjectType.PLUGIN_FFI)) {
                this.myList.add(FlutterProjectType.PLUGIN_FFI);
            }
        }

        void removePluginFfi() {
            this.myList.remove((Object)FlutterProjectType.PLUGIN_FFI);
        }

        void addEmptyProject() {
            if (!this.myList.contains((Object)FlutterProjectType.EMPTY_PROJECT)) {
                this.myList.add(FlutterProjectType.EMPTY_PROJECT);
            }
        }

        void removeEmptyProject() {
            this.myList.remove((Object)FlutterProjectType.EMPTY_PROJECT);
        }
    }
}

