/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.module.settings;

import com.intellij.ide.browsers.BrowserLauncher;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import io.flutter.FlutterBundle;
import io.flutter.FlutterConstants;
import io.flutter.FlutterUtils;
import io.flutter.module.FlutterProjectType;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.plaf.FontUIResource;
import javax.swing.text.StyleContext;
import org.jetbrains.annotations.NotNull;

public class SettingsHelpForm {
    private JPanel mainPanel;
    private JPanel helpPanel;
    private JLabel helpLabel;
    private JLabel projectTypeLabel;
    private JLabel projectTypeDescriptionForApp;
    private JLabel projectTypeDescriptionForModule;
    private JLabel projectTypeDescriptionForPlugin;
    private JLabel projectTypeDescriptionForPackage;
    private LinkLabel gettingStartedUrl;

    public static SettingsHelpForm getInstance() {
        return (SettingsHelpForm)ServiceManager.getService(SettingsHelpForm.class);
    }

    public SettingsHelpForm() {
        this.$$$setupUI$$$();
        this.projectTypeLabel.setText(FlutterBundle.message("flutter.module.create.settings.help.project_type.label", new Object[0]));
        this.projectTypeDescriptionForApp.setText(FlutterBundle.message("flutter.module.create.settings.help.project_type.description.app", new Object[0]));
        this.projectTypeDescriptionForModule.setText(FlutterBundle.message("flutter.module.create.settings.help.project_type.description.module", new Object[0]));
        this.projectTypeDescriptionForPlugin.setText(FlutterBundle.message("flutter.module.create.settings.help.project_type.description.plugin", new Object[0]));
        this.projectTypeDescriptionForPackage.setText(FlutterBundle.message("flutter.module.create.settings.help.project_type.description.package", new Object[0]));
        if (!FlutterUtils.isAndroidStudio()) {
            this.projectTypeDescriptionForModule.setVisible(false);
        }
        this.gettingStartedUrl.setText(FlutterBundle.message("flutter.module.create.settings.help.getting_started_link_text", new Object[0]));
        this.gettingStartedUrl.setCursor(Cursor.getPredefinedCursor(12));
        this.gettingStartedUrl.setIcon(null);
        this.gettingStartedUrl.setListener((label, linkUrl) -> BrowserLauncher.getInstance().browse(FlutterConstants.URL_GETTING_STARTED, null), null);
    }

    public void showGettingStarted() {
        this.projectTypeLabel.setVisible(false);
        this.projectTypeDescriptionForApp.setVisible(false);
        this.projectTypeDescriptionForModule.setVisible(false);
        this.projectTypeDescriptionForPlugin.setVisible(false);
        this.projectTypeDescriptionForPackage.setVisible(false);
        this.mainPanel.setVisible(true);
        this.gettingStartedUrl.setVisible(true);
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.mainPanel;
        if (jPanel == null) {
            SettingsHelpForm.$$$reportNull$$$0(0);
        }
        return jPanel;
    }

    public void adjustContrast(FlutterProjectType type) {
        this.projectTypeDescriptionForApp.setEnabled(false);
        this.projectTypeDescriptionForModule.setEnabled(false);
        this.projectTypeDescriptionForPlugin.setEnabled(false);
        this.projectTypeDescriptionForPackage.setEnabled(false);
        switch (type) {
            case APP: {
                this.projectTypeDescriptionForApp.setEnabled(true);
                break;
            }
            case MODULE: {
                this.projectTypeDescriptionForModule.setEnabled(true);
                break;
            }
            case PACKAGE: {
                this.projectTypeDescriptionForPackage.setEnabled(true);
                break;
            }
            case PLUGIN: {
                this.projectTypeDescriptionForPlugin.setEnabled(true);
                break;
            }
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JLabel jLabel2;
        LinkLabel linkLabel;
        JLabel jLabel3;
        JLabel jLabel4;
        JLabel jLabel5;
        JLabel jLabel6;
        JPanel jPanel;
        JPanel jPanel2;
        this.mainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(10, 0, 10, 0), -1, -1, false, false));
        this.helpPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(6, 2, new Insets(10, 10, 10, 10), -1, -1, false, false));
        ((Component)jPanel).setEnabled(true);
        jPanel2.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null, 0, 0, null, null));
        this.helpLabel = jLabel6 = new JLabel();
        Font font = this.$$$getFont$$$(null, 1, -1, jLabel6.getFont());
        if (font != null) {
            jLabel6.setFont(font);
        }
        jLabel6.setOpaque(false);
        jLabel6.setText("Help: ");
        jPanel.add((Component)jLabel6, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(5, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.projectTypeLabel = jLabel5 = new JLabel();
        Font font2 = this.$$$getFont$$$(null, 1, -1, jLabel5.getFont());
        if (font2 != null) {
            jLabel5.setFont(font2);
        }
        jLabel5.setText("Project type:");
        jPanel.add((Component)jLabel5, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.projectTypeDescriptionForApp = jLabel4 = new JLabel();
        jLabel4.setText("Help for app...");
        jPanel.add((Component)jLabel4, new GridConstraints(1, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.projectTypeDescriptionForPlugin = jLabel3 = new JLabel();
        jLabel3.setText("Help for plugin...");
        jPanel.add((Component)jLabel3, new GridConstraints(3, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel3, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.gettingStartedUrl = linkLabel = new LinkLabel();
        linkLabel.setOpaque(false);
        jPanel3.add((Component)linkLabel, new GridConstraints(0, 0, 1, 1, 0, 3, 6, 6, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel3.add((Component)spacer2, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel3.add((Component)spacer3, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel4, new GridConstraints(5, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.projectTypeDescriptionForPackage = jLabel2 = new JLabel();
        jLabel2.setText("Help for package...");
        jPanel.add((Component)jLabel2, new GridConstraints(4, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.projectTypeDescriptionForModule = jLabel = new JLabel();
        jLabel.setText("Help for module...");
        jPanel.add((Component)jLabel, new GridConstraints(2, 1, 1, 1, 8, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.mainPanel;
    }

    private /* synthetic */ Font $$$getFont$$$(String string, int n, int n2, Font font) {
        Font font2;
        if (font == null) {
            return null;
        }
        String string2 = string == null ? font.getName() : ((font2 = new Font(string, 0, 10)).canDisplay('a') && font2.canDisplay('1') ? string : font.getName());
        Font font3 = new Font(string2, n >= 0 ? n : font.getStyle(), n2 >= 0 ? n2 : font.getSize());
        boolean bl = System.getProperty("os.name", "").toLowerCase(Locale.ENGLISH).startsWith("mac");
        Font font4 = bl ? new Font(font3.getFamily(), font3.getStyle(), font3.getSize()) : new StyleContext().getFont(font3.getFamily(), font3.getStyle(), font3.getSize());
        return font4 instanceof FontUIResource ? font4 : new FontUIResource(font4);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "io/flutter/module/settings/SettingsHelpForm", "getComponent"));
    }
}

