/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.perf;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.http.HttpVirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.jetbrains.lang.dart.psi.DartId;
import com.jetbrains.lang.dart.psi.DartReferenceExpression;
import io.flutter.inspector.InspectorService;
import io.flutter.perf.FileLocationMapper;
import org.jetbrains.annotations.Nullable;

public class DocumentFileLocationMapper
implements FileLocationMapper {
    @Nullable
    private final Document document;
    private final PsiFile psiFile;
    private final VirtualFile virtualFile;
    private final XDebuggerUtil debuggerUtil;

    public DocumentFileLocationMapper(String path, Project project) {
        this(DocumentFileLocationMapper.lookupDocument(path, project), project);
    }

    @Nullable
    public static Document lookupDocument(String path, Project project) {
        String fileName = InspectorService.fromSourceLocationUri(path, project);
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(fileName);
        if (virtualFile != null && virtualFile.exists() && !(virtualFile instanceof LightVirtualFile) && !(virtualFile instanceof HttpVirtualFile)) {
            return FileDocumentManager.getInstance().getDocument(virtualFile);
        }
        return null;
    }

    DocumentFileLocationMapper(@Nullable Document document, Project project) {
        this.document = document;
        if (document != null) {
            this.psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
            this.virtualFile = this.psiFile != null ? this.psiFile.getVirtualFile() : null;
            this.debuggerUtil = XDebuggerUtil.getInstance();
        } else {
            this.psiFile = null;
            this.virtualFile = null;
            this.debuggerUtil = null;
        }
    }

    @Override
    @Nullable
    public TextRange getIdentifierRange(int line, int column) {
        if (this.psiFile == null) {
            return null;
        }
        --column;
        if (this.document == null || --line >= this.document.getLineCount() || this.document.isLineModified(line)) {
            return null;
        }
        XSourcePosition pos = this.debuggerUtil.createPosition(this.virtualFile, line, column);
        if (pos == null) {
            return null;
        }
        int offset = pos.getOffset();
        PsiElement element = this.psiFile.getOriginalFile().findElementAt(offset);
        if (element == null) {
            return null;
        }
        if (element.getParent() instanceof DartId) {
            element = element.getParent();
        }
        while (element.getParent() instanceof DartReferenceExpression) {
            element = element.getParent();
        }
        return element.getTextRange();
    }

    @Override
    @Nullable
    public String getText(@Nullable TextRange textRange) {
        if (this.document == null || textRange == null) {
            return null;
        }
        return this.document.getText(textRange);
    }

    @Override
    public String getPath() {
        return this.psiFile == null ? null : this.psiFile.getVirtualFile().getPath();
    }
}

