/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.perf;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseEventArea;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.util.TextRange;
import io.flutter.perf.EditorPerfModel;
import io.flutter.perf.FilePerfInfo;
import io.flutter.perf.PerfGutterIconRenderer;
import io.flutter.perf.PerfMetric;
import io.flutter.run.daemon.FlutterApp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

class EditorPerfDecorations
implements EditorMouseListener,
EditorPerfModel {
    private static final int HIGHLIGHTER_LAYER = 5999;
    public static boolean ANIMATE_WIDGET_NAME_HIGLIGHTS = false;
    @NotNull
    private final TextEditor textEditor;
    @NotNull
    private final FlutterApp app;
    @NotNull
    private FilePerfInfo stats;
    private boolean hasDecorations;
    private boolean hoveredOverLineMarkerArea;
    private final Map<TextRange, PerfGutterIconRenderer> perfMarkers;
    private boolean alwaysShowLineMarkersOverride;

    EditorPerfDecorations(@NotNull TextEditor textEditor, @NotNull FlutterApp app) {
        if (textEditor == null) {
            EditorPerfDecorations.$$$reportNull$$$0(0);
        }
        if (app == null) {
            EditorPerfDecorations.$$$reportNull$$$0(1);
        }
        this.hasDecorations = false;
        this.hoveredOverLineMarkerArea = false;
        this.perfMarkers = new HashMap<TextRange, PerfGutterIconRenderer>();
        this.alwaysShowLineMarkersOverride = false;
        this.textEditor = textEditor;
        this.app = app;
        this.stats = new FilePerfInfo();
        textEditor.getEditor().addEditorMouseListener((EditorMouseListener)this);
    }

    @Override
    public boolean getAlwaysShowLineMarkers() {
        return this.hoveredOverLineMarkerArea || this.alwaysShowLineMarkersOverride;
    }

    @Override
    public void setAlwaysShowLineMarkersOverride(boolean show) {
        boolean lastValue = this.getAlwaysShowLineMarkers();
        this.alwaysShowLineMarkersOverride = show;
        if (lastValue != this.getAlwaysShowLineMarkers()) {
            this.updateIconUIAnimations();
        }
    }

    @Override
    @NotNull
    public FilePerfInfo getStats() {
        FilePerfInfo filePerfInfo = this.stats;
        if (filePerfInfo == null) {
            EditorPerfDecorations.$$$reportNull$$$0(2);
        }
        return filePerfInfo;
    }

    @Override
    @NotNull
    public TextEditor getTextEditor() {
        TextEditor textEditor = this.textEditor;
        if (textEditor == null) {
            EditorPerfDecorations.$$$reportNull$$$0(3);
        }
        return textEditor;
    }

    @Override
    @NotNull
    public FlutterApp getApp() {
        FlutterApp flutterApp = this.app;
        if (flutterApp == null) {
            EditorPerfDecorations.$$$reportNull$$$0(4);
        }
        return flutterApp;
    }

    void setHasDecorations(boolean value) {
        if (value != this.hasDecorations) {
            this.hasDecorations = value;
        }
    }

    @Override
    public void setPerfInfo(@NotNull FilePerfInfo stats) {
        if (stats == null) {
            EditorPerfDecorations.$$$reportNull$$$0(5);
        }
        this.stats = stats;
        Editor editor = this.textEditor.getEditor();
        MarkupModel markupModel = editor.getMarkupModel();
        ArrayList<TextRange> rangesToRemove = new ArrayList<TextRange>();
        for (TextRange range : this.perfMarkers.keySet()) {
            if (stats.hasLocation(range)) continue;
            rangesToRemove.add(range);
        }
        for (TextRange range : rangesToRemove) {
            this.removeMarker(range);
        }
        for (TextRange range : stats.getLocations()) {
            PerfGutterIconRenderer existing = this.perfMarkers.get(range);
            if (existing == null) {
                this.addRangeHighlighter(range, markupModel);
                continue;
            }
            existing.updateUI(true);
        }
        this.setHasDecorations(true);
    }

    private void removeMarker(TextRange range) {
        PerfGutterIconRenderer marker = this.perfMarkers.remove(range);
        if (marker != null) {
            Editor editor = this.textEditor.getEditor();
            MarkupModel markupModel = editor.getMarkupModel();
            markupModel.removeHighlighter(marker.getHighlighter());
        }
    }

    @Override
    public void markAppIdle() {
        this.stats.markAppIdle();
        this.updateIconUIAnimations();
    }

    private void addRangeHighlighter(TextRange textRange, MarkupModel markupModel) {
        RangeHighlighter rangeHighlighter = markupModel.addRangeHighlighter(textRange.getStartOffset(), textRange.getEndOffset(), 5999, new TextAttributes(), HighlighterTargetArea.EXACT_RANGE);
        PerfGutterIconRenderer renderer = new PerfGutterIconRenderer(textRange, this, rangeHighlighter);
        rangeHighlighter.setGutterIconRenderer((GutterIconRenderer)renderer);
        assert (!this.perfMarkers.containsKey(textRange));
        this.perfMarkers.put(textRange, renderer);
    }

    @Override
    public boolean isAnimationActive() {
        return this.getStats().getTotalValue(PerfMetric.peakRecent) > 0;
    }

    @Override
    public void onFrame() {
        if (this.app.isReloading() || !this.hasDecorations || !this.isAnimationActive()) {
            return;
        }
        this.updateIconUIAnimations();
    }

    private void updateIconUIAnimations() {
        if (!this.textEditor.getComponent().isVisible()) {
            return;
        }
        for (PerfGutterIconRenderer marker : this.perfMarkers.values()) {
            marker.updateUI(true);
        }
    }

    private void removeHighlightersFromEditor() {
        ArrayList highlighters = new ArrayList();
        MarkupModel markupModel = this.textEditor.getEditor().getMarkupModel();
        for (PerfGutterIconRenderer marker : this.perfMarkers.values()) {
            markupModel.removeHighlighter(marker.getHighlighter());
        }
        this.perfMarkers.clear();
        this.setHasDecorations(false);
    }

    public void flushDecorations() {
        if (this.hasDecorations && this.textEditor.isValid()) {
            this.setHasDecorations(false);
            ApplicationManager.getApplication().invokeLater(this::removeHighlightersFromEditor);
        }
    }

    public void dispose() {
        this.textEditor.getEditor().removeEditorMouseListener((EditorMouseListener)this);
        this.flushDecorations();
    }

    public void mousePressed(@NotNull EditorMouseEvent e) {
        if (e == null) {
            EditorPerfDecorations.$$$reportNull$$$0(6);
        }
    }

    public void mouseClicked(@NotNull EditorMouseEvent e) {
        if (e == null) {
            EditorPerfDecorations.$$$reportNull$$$0(7);
        }
    }

    public void mouseReleased(@NotNull EditorMouseEvent e) {
        if (e == null) {
            EditorPerfDecorations.$$$reportNull$$$0(8);
        }
    }

    public void mouseEntered(EditorMouseEvent e) {
        EditorMouseEventArea area = e.getArea();
        if (!this.hoveredOverLineMarkerArea && area == EditorMouseEventArea.LINE_MARKERS_AREA || area == EditorMouseEventArea.FOLDING_OUTLINE_AREA || area == EditorMouseEventArea.LINE_NUMBERS_AREA) {
            this.setHoverState(true);
        }
    }

    public void mouseExited(EditorMouseEvent e) {
        EditorMouseEventArea area = e.getArea();
        this.setHoverState(false);
    }

    private void setHoverState(boolean value) {
        if (value != this.hoveredOverLineMarkerArea) {
            this.hoveredOverLineMarkerArea = value;
            this.updateIconUIAnimations();
        }
    }

    @Override
    public void clear() {
        this.stats.clear();
        this.removeHighlightersFromEditor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textEditor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "app";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/perf/EditorPerfDecorations";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stats";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/perf/EditorPerfDecorations";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getStats";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextEditor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getApp";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setPerfInfo";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "mousePressed";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "mouseClicked";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "mouseReleased";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4 -> new IllegalStateException(string);
        };
    }
}

