/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.perf;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.SetMultimap;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.intellij.concurrency.JobScheduler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ui.EdtInvocationManager;
import gnu.trove.TIntObjectHashMap;
import io.flutter.perf.EditorPerfModel;
import io.flutter.perf.FileLocationMapperFactory;
import io.flutter.perf.FilePerfInfo;
import io.flutter.perf.FilePerfModelFactory;
import io.flutter.perf.Location;
import io.flutter.perf.PerfMetric;
import io.flutter.perf.PerfModel;
import io.flutter.perf.PerfReportKind;
import io.flutter.perf.PerfSourceReport;
import io.flutter.perf.SlidingWindowStats;
import io.flutter.perf.SlidingWindowStatsSummary;
import io.flutter.perf.SummaryStats;
import io.flutter.perf.When;
import io.flutter.perf.WidgetPerfLinter;
import io.flutter.perf.WidgetPerfListener;
import io.flutter.perf.WidgetPerfProvider;
import io.flutter.utils.AsyncUtils;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.swing.Timer;
import org.jetbrains.annotations.NotNull;

public class FlutterWidgetPerf
implements Disposable,
WidgetPerfListener {
    private static final Logger LOG = Logger.getInstance(FlutterWidgetPerf.class);
    public static final long IDLE_DELAY_MILISECONDS = 400L;
    private static final long REQUEST_TIMEOUT_INTERVAL = 2000L;
    private static final int UI_FPS = 8;
    private boolean isDirty;
    private boolean requestInProgress;
    private long lastRequestTime;
    private final Set<PerfModel> perfListeners;
    private final Map<TextEditor, EditorPerfModel> editorDecorations;
    private final TIntObjectHashMap<Location> knownLocationIds;
    private final SetMultimap<String, Location> locationsPerFile;
    private final Map<PerfReportKind, StatsForReportKind> stats;
    final Set<TextEditor> currentEditors;
    private boolean profilingEnabled;
    final Timer uiAnimationTimer;
    @NotNull
    private final WidgetPerfProvider perfProvider;
    private boolean isDisposed;
    private final FilePerfModelFactory perfModelFactory;
    private final FileLocationMapperFactory fileLocationMapperFactory;
    private volatile long lastLocalPerfEventTime;
    private final WidgetPerfLinter perfLinter;

    FlutterWidgetPerf(boolean profilingEnabled, @NotNull WidgetPerfProvider perfProvider, FilePerfModelFactory perfModelFactory, FileLocationMapperFactory fileLocationMapperFactory) {
        if (perfProvider == null) {
            FlutterWidgetPerf.$$$reportNull$$$0(0);
        }
        this.isDirty = true;
        this.requestInProgress = false;
        this.perfListeners = new HashSet<PerfModel>();
        this.editorDecorations = new HashMap<TextEditor, EditorPerfModel>();
        this.knownLocationIds = new TIntObjectHashMap();
        this.locationsPerFile = HashMultimap.create();
        this.stats = new HashMap<PerfReportKind, StatsForReportKind>();
        this.currentEditors = new HashSet<TextEditor>();
        this.isDisposed = false;
        this.profilingEnabled = profilingEnabled;
        this.perfProvider = perfProvider;
        this.perfModelFactory = perfModelFactory;
        this.fileLocationMapperFactory = fileLocationMapperFactory;
        this.perfLinter = new WidgetPerfLinter(this, perfProvider);
        perfProvider.setTarget(this);
        this.uiAnimationTimer = new Timer(125, event -> AsyncUtils.invokeLater(() -> this.onFrame(event)));
    }

    private void setRequestInProgress(boolean value) {
        this.requestInProgress = value;
    }

    private void onFrame(ActionEvent event) {
        for (EditorPerfModel decorations : this.editorDecorations.values()) {
            decorations.onFrame();
        }
        for (PerfModel model : this.perfListeners) {
            model.onFrame();
        }
    }

    private boolean isConnected() {
        return this.perfProvider.isConnected();
    }

    public long getLastLocalPerfEventTime() {
        return this.lastLocalPerfEventTime;
    }

    @Override
    public void requestRepaint(When when) {
        if (!this.profilingEnabled) {
            this.isDirty = false;
            return;
        }
        this.isDirty = true;
        if (!this.isConnected() || this.currentEditors.isEmpty() && this.perfListeners.isEmpty()) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (this.requestInProgress && currentTime - this.lastRequestTime < 2000L) {
            return;
        }
        this.setRequestInProgress(true);
        this.lastRequestTime = currentTime;
        TextEditor[] editors = this.currentEditors.toArray(new TextEditor[0]);
        AsyncUtils.invokeLater(() -> this.performRequest(editors));
    }

    @Override
    public void onWidgetPerfEvent(PerfReportKind kind, JsonObject json) {
        Runnable action = () -> {
            FlutterWidgetPerf flutterWidgetPerf = this;
            synchronized (flutterWidgetPerf) {
                long startTimeMicros = json.get("startTime").getAsLong();
                int startTimeMilis = (int)(startTimeMicros / 1000L);
                this.lastLocalPerfEventTime = System.currentTimeMillis();
                StatsForReportKind statsForReportKind = this.getStatsForKind(kind);
                if (statsForReportKind.lastStartTime > startTimeMilis) {
                    statsForReportKind.data.forEachValue(entry -> {
                        entry.clear();
                        return true;
                    });
                }
                statsForReportKind.lastStartTime = startTimeMilis;
                if (json.has("locations")) {
                    JsonObject fileLocationsMap = json.getAsJsonObject("locations");
                    for (Map.Entry entry2 : fileLocationsMap.entrySet()) {
                        path = (String)entry2.getKey();
                        locationMapper = this.fileLocationMapperFactory.create(path);
                        JsonObject locations = ((JsonElement)entry2.getValue()).getAsJsonObject();
                        JsonArray ids = locations.getAsJsonArray("ids");
                        JsonArray lines = locations.getAsJsonArray("lines");
                        JsonArray columns = locations.getAsJsonArray("columns");
                        JsonArray names = locations.getAsJsonArray("names");
                        for (int i = 0; i < ids.size(); ++i) {
                            int id = ids.get(i).getAsInt();
                            int line = lines.get(i).getAsInt();
                            int column = columns.get(i).getAsInt();
                            TextRange textRange = locationMapper.getIdentifierRange(line, column);
                            Location location = new Location(locationMapper.getPath(), line, column, id, textRange, names.get(i).getAsString());
                            Location existingLocation = (Location)this.knownLocationIds.get(id);
                            if (existingLocation == null) {
                                this.addNewLocation(id, location);
                                continue;
                            }
                            if (location.equals(existingLocation)) continue;
                            this.locationsPerFile.remove((Object)existingLocation.path, (Object)existingLocation);
                            for (StatsForReportKind statsForKind : this.stats.values()) {
                                statsForKind.data.remove(id);
                            }
                            this.addNewLocation(id, location);
                        }
                    }
                } else if (json.has("newLocations")) {
                    JsonObject newLocations = json.getAsJsonObject("newLocations");
                    for (Map.Entry entry2 : newLocations.entrySet()) {
                        path = (String)entry2.getKey();
                        locationMapper = this.fileLocationMapperFactory.create(path);
                        JsonArray entries = ((JsonElement)entry2.getValue()).getAsJsonArray();
                        assert (entries.size() % 3 == 0);
                        for (int i = 0; i < entries.size(); i += 3) {
                            int column;
                            int id = entries.get(i).getAsInt();
                            int line = entries.get(i + 1).getAsInt();
                            TextRange textRange = locationMapper.getIdentifierRange(line, column = entries.get(i + 2).getAsInt());
                            String name = locationMapper.getText(textRange);
                            if (name == null) {
                                name = "";
                            }
                            Location location = new Location(locationMapper.getPath(), line, column, id, textRange, name);
                            Location existingLocation = (Location)this.knownLocationIds.get(id);
                            if (existingLocation == null) {
                                this.addNewLocation(id, location);
                                continue;
                            }
                            if (location.equals(existingLocation)) continue;
                            this.locationsPerFile.remove((Object)existingLocation.path, (Object)existingLocation);
                            for (StatsForReportKind statsForKind : this.stats.values()) {
                                statsForKind.data.remove(id);
                            }
                            this.addNewLocation(id, location);
                        }
                    }
                }
                StatsForReportKind statsForKind = this.getStatsForKind(kind);
                PerfSourceReport report = new PerfSourceReport(json.getAsJsonArray("events"), kind, startTimeMicros);
                if (!report.getEntries().isEmpty()) {
                    statsForReportKind.lastNonEmptyReportTime = startTimeMilis;
                }
                for (PerfSourceReport.Entry entry3 : report.getEntries()) {
                    int locationId = entry3.locationId;
                    SlidingWindowStats statsForLocation = (SlidingWindowStats)statsForKind.data.get(locationId);
                    if (statsForLocation == null) {
                        statsForLocation = new SlidingWindowStats();
                        statsForKind.data.put(locationId, (Object)statsForLocation);
                    }
                    statsForLocation.add(entry3.total, startTimeMilis);
                }
            }
        };
        Application application = ApplicationManager.getApplication();
        if (application != null) {
            application.runReadAction(action);
        } else {
            action.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onNavigation() {
        FlutterWidgetPerf flutterWidgetPerf = this;
        synchronized (flutterWidgetPerf) {
            for (StatsForReportKind statsForKind : this.stats.values()) {
                statsForKind.data.forEachValue(entry -> {
                    entry.onNavigation();
                    return true;
                });
            }
        }
    }

    @Override
    public void addPerfListener(PerfModel listener) {
        this.perfListeners.add(listener);
    }

    @Override
    public void removePerfListener(PerfModel listener) {
        this.perfListeners.remove(listener);
    }

    private StatsForReportKind getStatsForKind(PerfReportKind kind) {
        StatsForReportKind report = this.stats.get((Object)kind);
        if (report == null) {
            report = new StatsForReportKind();
            this.stats.put(kind, report);
        }
        return report;
    }

    private void addNewLocation(int id, Location location) {
        this.knownLocationIds.put(id, (Object)location);
        this.locationsPerFile.put((Object)location.path, (Object)location);
    }

    void setProfilingEnabled(boolean enabled) {
        this.profilingEnabled = enabled;
    }

    private void performRequest(TextEditor[] fileEditors) {
        assert (EdtInvocationManager.getInstance().isEventDispatchThread());
        if (!this.profilingEnabled) {
            this.setRequestInProgress(false);
            return;
        }
        LinkedListMultimap editorForPath = LinkedListMultimap.create();
        ArrayList<String> uris = new ArrayList<String>();
        for (TextEditor editor : fileEditors) {
            VirtualFile file = editor.getFile();
            if (file == null) continue;
            String uri = file.getPath();
            editorForPath.put((Object)uri, (Object)editor);
            uris.add(uri);
        }
        if (uris.isEmpty() && this.perfListeners.isEmpty()) {
            this.setRequestInProgress(false);
            return;
        }
        this.isDirty = false;
        this.showReports((Multimap<String, TextEditor>)editorForPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showReports(Multimap<String, TextEditor> editorForPath) {
        boolean animate = false;
        FlutterWidgetPerf flutterWidgetPerf = this;
        synchronized (flutterWidgetPerf) {
            for (String path : editorForPath.keySet()) {
                for (TextEditor fileEditor : editorForPath.get((Object)path)) {
                    if (!fileEditor.isValid()) {
                        return;
                    }
                    EditorPerfModel editorDecoration = this.editorDecorations.get(fileEditor);
                    if (editorDecoration == null) continue;
                    if (!this.perfProvider.shouldDisplayPerfStats((FileEditor)fileEditor)) {
                        editorDecoration.clear();
                        continue;
                    }
                    FilePerfInfo fileStats = this.buildSummaryStats(fileEditor);
                    editorDecoration.setPerfInfo(fileStats);
                    if (!editorDecoration.isAnimationActive()) continue;
                    animate = true;
                }
            }
        }
        if (!animate) {
            for (PerfModel listener : this.perfListeners) {
                if (!listener.isAnimationActive()) continue;
                animate = true;
                break;
            }
        }
        if (animate != this.uiAnimationTimer.isRunning()) {
            if (animate) {
                this.uiAnimationTimer.start();
            } else {
                this.uiAnimationTimer.stop();
            }
        }
        this.performRequestFinish();
    }

    private FilePerfInfo buildSummaryStats(TextEditor fileEditor) {
        FilePerfInfo fileStats = new FilePerfInfo();
        if (fileEditor.getFile() == null) {
            return fileStats;
        }
        String path = fileEditor.getFile().getPath();
        for (PerfReportKind kind : PerfReportKind.values()) {
            StatsForReportKind forKind = this.stats.get((Object)kind);
            if (forKind == null) continue;
            TIntObjectHashMap<SlidingWindowStats> data = forKind.data;
            for (Location location : this.locationsPerFile.get((Object)path)) {
                TextRange range;
                SlidingWindowStats entry = (SlidingWindowStats)data.get(location.id);
                if (entry == null || (range = location.textRange) == null) continue;
                fileStats.add(range, new SummaryStats(kind, new SlidingWindowStatsSummary(entry, forKind.lastStartTime, location), location.name));
            }
        }
        return fileStats;
    }

    private void performRequestFinish() {
        this.setRequestInProgress(false);
        JobScheduler.getScheduler().schedule(this::maybeNotifyIdle, 400L, TimeUnit.MILLISECONDS);
        if (this.isDirty) {
            this.requestRepaint(When.soon);
        }
    }

    private void maybeNotifyIdle() {
        if (this.isDisposed) {
            return;
        }
        if (System.currentTimeMillis() >= this.lastRequestTime + 400L) {
            AsyncUtils.invokeLater(() -> {
                for (EditorPerfModel decoration : this.editorDecorations.values()) {
                    decoration.markAppIdle();
                }
                for (PerfModel listener : this.perfListeners) {
                    listener.markAppIdle();
                }
                this.uiAnimationTimer.stop();
            });
        }
    }

    public void showFor(Set<TextEditor> editors) {
        AsyncUtils.invokeAndWait(() -> {
            this.currentEditors.clear();
            this.currentEditors.addAll(editors);
            this.harvestInvalidEditors(editors);
            for (TextEditor fileEditor : this.currentEditors) {
                if (this.editorDecorations.containsKey(fileEditor)) continue;
                this.editorDecorations.put(fileEditor, this.perfModelFactory.create(fileEditor));
            }
            this.requestRepaint(When.now);
        });
    }

    private void harvestInvalidEditors(Set<TextEditor> newEditors) {
        Iterator<TextEditor> editors = this.editorDecorations.keySet().iterator();
        while (editors.hasNext()) {
            TextEditor editor = editors.next();
            if (editor.isValid() && (newEditors == null || newEditors.contains(editor))) continue;
            EditorPerfModel editorPerfDecorations = this.editorDecorations.get(editor);
            editors.remove();
            Disposer.dispose((Disposable)editorPerfDecorations);
        }
    }

    public void setAlwaysShowLineMarkersOverride(boolean show) {
        for (EditorPerfModel model : this.editorDecorations.values()) {
            model.setAlwaysShowLineMarkersOverride(show);
        }
    }

    public void dispose() {
        if (this.isDisposed) {
            return;
        }
        this.isDisposed = true;
        if (this.uiAnimationTimer.isRunning()) {
            this.uiAnimationTimer.stop();
        }
        this.perfProvider.dispose();
        AsyncUtils.invokeLater(() -> {
            this.clearModels();
            for (EditorPerfModel decorations : this.editorDecorations.values()) {
                decorations.dispose();
            }
            this.editorDecorations.clear();
            this.perfListeners.clear();
        });
    }

    @VisibleForTesting
    public void clearModels() {
        for (EditorPerfModel decorations : this.editorDecorations.values()) {
            decorations.clear();
        }
        for (PerfModel listener : this.perfListeners) {
            listener.clear();
        }
    }

    protected void clear() {
        AsyncUtils.invokeLater(this::clearModels);
    }

    protected void onRestart() {
        AsyncUtils.invokeLater(() -> {
            this.knownLocationIds.clear();
            this.stats.clear();
            this.clearModels();
        });
    }

    public WidgetPerfLinter getPerfLinter() {
        return this.perfLinter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<FilePerfInfo> buildAllSummaryStats(Set<TextEditor> textEditors) {
        ArrayList<FilePerfInfo> stats = new ArrayList<FilePerfInfo>();
        FlutterWidgetPerf flutterWidgetPerf = this;
        synchronized (flutterWidgetPerf) {
            for (TextEditor textEditor : textEditors) {
                stats.add(this.buildSummaryStats(textEditor));
            }
        }
        return stats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<SlidingWindowStatsSummary> getStatsForMetric(ArrayList<PerfMetric> metrics, PerfReportKind kind) {
        ArrayList<SlidingWindowStatsSummary> entries = new ArrayList<SlidingWindowStatsSummary>();
        FlutterWidgetPerf flutterWidgetPerf = this;
        synchronized (flutterWidgetPerf) {
            StatsForReportKind forKind = this.stats.get((Object)kind);
            if (forKind != null) {
                int time = forKind.lastNonEmptyReportTime;
                forKind.data.forEachEntry((locationId, stats) -> {
                    for (PerfMetric metric : metrics) {
                        if (stats.getValue(metric, time) <= 0) continue;
                        Location location = (Location)this.knownLocationIds.get(locationId);
                        if (location != null) {
                            entries.add(new SlidingWindowStatsSummary((SlidingWindowStats)stats, time, location));
                        }
                        return true;
                    }
                    return true;
                });
            }
        }
        return entries;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "perfProvider", "io/flutter/perf/FlutterWidgetPerf", "<init>"));
    }

    static class StatsForReportKind {
        final TIntObjectHashMap<SlidingWindowStats> data = new TIntObjectHashMap();
        private int lastStartTime = -1;
        private int lastNonEmptyReportTime = -1;

        StatsForReportKind() {
        }
    }
}

