/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.perf;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.messages.MessageBusConnection;
import io.flutter.FlutterInitializer;
import io.flutter.FlutterUtils;
import io.flutter.perf.DocumentFileLocationMapper;
import io.flutter.perf.EditorPerfDecorations;
import io.flutter.perf.FlutterWidgetPerf;
import io.flutter.perf.PerfModel;
import io.flutter.perf.VmServiceWidgetPerfProvider;
import io.flutter.run.FlutterAppManager;
import io.flutter.run.daemon.FlutterApp;
import io.flutter.utils.StreamSubscription;
import io.flutter.view.FlutterViewMessages;
import io.flutter.vmService.ServiceExtensions;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlutterWidgetPerfManager
implements Disposable,
FlutterApp.FlutterAppListener {
    public static boolean trackRebuildWidgetsDefault = false;
    public static boolean trackRepaintWidgetsDefault = false;
    private FlutterWidgetPerf currentStats;
    private FlutterApp app;
    private final Project project;
    private boolean trackRebuildWidgets;
    private boolean trackRepaintWidgets;
    private boolean debugIsActive;
    private final Set<PerfModel> listeners;
    private Set<TextEditor> lastSelectedEditors;
    private final List<StreamSubscription<Boolean>> streamSubscriptions;

    public FlutterWidgetPerf getCurrentStats() {
        return this.currentStats;
    }

    @NotNull
    public Set<TextEditor> getSelectedEditors() {
        Set<TextEditor> set = this.lastSelectedEditors;
        if (set == null) {
            FlutterWidgetPerfManager.$$$reportNull$$$0(0);
        }
        return set;
    }

    private FlutterWidgetPerfManager(@NotNull Project project) {
        if (project == null) {
            FlutterWidgetPerfManager.$$$reportNull$$$0(1);
        }
        this.trackRebuildWidgets = trackRebuildWidgetsDefault;
        this.trackRepaintWidgets = trackRepaintWidgetsDefault;
        this.listeners = new HashSet<PerfModel>();
        this.lastSelectedEditors = new HashSet<TextEditor>();
        this.streamSubscriptions = new ArrayList<StreamSubscription<Boolean>>();
        this.project = project;
        Disposer.register((Disposable)project, (Disposable)this);
        FlutterAppManager.getInstance(project).getActiveAppAsStream().listen(this::updateCurrentAppChanged, true);
        project.getMessageBus().connect().subscribe(FlutterViewMessages.FLUTTER_DEBUG_TOPIC, event -> this.debugActive(project, event));
        MessageBusConnection connection = project.getMessageBus().connect((Disposable)project);
        this.updateSelectedEditors();
        connection.subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerListener(){

            public void selectionChanged(@NotNull FileEditorManagerEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (FlutterWidgetPerfManager.this.updateSelectedEditors()) {
                    FlutterWidgetPerfManager.this.notifyPerf();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "io/flutter/perf/FlutterWidgetPerfManager$1", "selectionChanged"));
            }
        });
    }

    private boolean updateSelectedEditors() {
        FileEditor[] editors = FileEditorManager.getInstance((Project)this.project).getSelectedEditors();
        HashSet<TextEditor> newEditors = new HashSet<TextEditor>();
        for (FileEditor editor : editors) {
            VirtualFile file;
            if (!(editor instanceof TextEditor) || !FlutterUtils.couldContainWidgets(file = editor.getFile())) continue;
            newEditors.add((TextEditor)editor);
        }
        if (newEditors.equals(this.lastSelectedEditors)) {
            return false;
        }
        this.lastSelectedEditors = newEditors;
        return true;
    }

    public static void init(@NotNull Project project) {
        if (project == null) {
            FlutterWidgetPerfManager.$$$reportNull$$$0(2);
        }
        FlutterWidgetPerfManager.getInstance(project);
    }

    @Nullable
    public static FlutterWidgetPerfManager getInstance(@NotNull Project project) {
        if (project == null) {
            FlutterWidgetPerfManager.$$$reportNull$$$0(3);
        }
        return (FlutterWidgetPerfManager)project.getService(FlutterWidgetPerfManager.class);
    }

    public boolean isTrackRebuildWidgets() {
        return this.trackRebuildWidgets;
    }

    public void setTrackRebuildWidgets(boolean value) {
        if (value == this.trackRebuildWidgets) {
            return;
        }
        this.trackRebuildWidgets = value;
        this.onProfilingFlagsChanged();
        if (this.debugIsActive && this.app != null && this.app.isSessionActive()) {
            this.updateTrackWidgetRebuilds();
        }
        if (this.trackRebuildWidgets) {
            FlutterInitializer.getAnalytics().sendEvent("intellij", "TrackWidgetRebuilds");
        }
    }

    public boolean isTrackRepaintWidgets() {
        return this.trackRepaintWidgets;
    }

    public void setTrackRepaintWidgets(boolean value) {
        if (value == this.trackRepaintWidgets) {
            return;
        }
        this.trackRepaintWidgets = value;
        this.onProfilingFlagsChanged();
        if (this.debugIsActive && this.app != null && this.app.isSessionActive()) {
            this.updateTrackWidgetRepaints();
        }
        if (this.trackRepaintWidgets) {
            FlutterInitializer.getAnalytics().sendEvent("intellij", "TrackRepaintWidgets");
        }
    }

    private void onProfilingFlagsChanged() {
        if (this.currentStats != null) {
            this.currentStats.setProfilingEnabled(this.isProfilingEnabled());
        }
    }

    private boolean isProfilingEnabled() {
        return this.trackRebuildWidgets || this.trackRepaintWidgets;
    }

    private void debugActive(Project project, FlutterViewMessages.FlutterDebugEvent event) {
        this.debugIsActive = true;
        if (this.app == null) {
            return;
        }
        this.app.addStateListener(this);
        this.syncBooleanServiceExtension(ServiceExtensions.trackRebuildWidgets.getExtension(), (Computable<Boolean>)((Computable)() -> this.trackRebuildWidgets));
        this.syncBooleanServiceExtension(ServiceExtensions.trackRepaintWidgets.getExtension(), (Computable<Boolean>)((Computable)() -> this.trackRepaintWidgets));
        this.currentStats = new FlutterWidgetPerf(this.isProfilingEnabled(), new VmServiceWidgetPerfProvider(this.app), textEditor -> new EditorPerfDecorations(textEditor, this.app), path -> new DocumentFileLocationMapper(path, this.app.getProject()));
        for (PerfModel listener : this.listeners) {
            this.currentStats.addPerfListener(listener);
        }
    }

    @Override
    public void stateChanged(FlutterApp.State newState) {
        switch (newState) {
            case RELOADING: {
                if (this.currentStats == null) break;
                this.currentStats.clear();
                break;
            }
            case RESTARTING: {
                if (this.currentStats == null) break;
                this.currentStats.onRestart();
                break;
            }
            case STARTED: {
                this.notifyPerf();
            }
        }
    }

    @Override
    public void notifyAppRestarted() {
        this.currentStats.clear();
    }

    @Override
    public void notifyAppReloaded() {
        this.currentStats.clear();
    }

    private void updateTrackWidgetRebuilds() {
        this.app.maybeCallBooleanExtension(ServiceExtensions.trackRebuildWidgets.getExtension(), this.trackRebuildWidgets).whenCompleteAsync((v, e) -> this.notifyPerf());
    }

    private void updateTrackWidgetRepaints() {
        this.app.maybeCallBooleanExtension(ServiceExtensions.trackRepaintWidgets.getExtension(), this.trackRepaintWidgets).whenCompleteAsync((v, e) -> this.notifyPerf());
    }

    private void syncBooleanServiceExtension(String serviceExtension, Computable<Boolean> valueProvider) {
        StreamSubscription<Boolean> subscription = this.app.hasServiceExtension(serviceExtension, supported -> {
            if (supported.booleanValue()) {
                this.app.callBooleanExtension(serviceExtension, (Boolean)valueProvider.compute());
            }
        });
        if (subscription != null) {
            this.streamSubscriptions.add(subscription);
        }
    }

    private void updateCurrentAppChanged(@Nullable FlutterApp app) {
        if (app == this.app) {
            return;
        }
        this.debugIsActive = false;
        if (this.app != null) {
            this.app.removeStateListener(this);
        }
        this.app = app;
        for (StreamSubscription<Boolean> subscription : this.streamSubscriptions) {
            subscription.dispose();
        }
        this.streamSubscriptions.clear();
        if (this.currentStats != null) {
            this.currentStats.dispose();
            this.currentStats = null;
        }
    }

    private void notifyPerf() {
        if (!this.trackRepaintWidgets && !this.trackRebuildWidgets && this.currentStats != null) {
            this.currentStats.clear();
        }
        if (this.currentStats == null) {
            return;
        }
        if (this.lastSelectedEditors.isEmpty()) {
            this.currentStats.showFor(this.lastSelectedEditors);
            return;
        }
        HashSet<TextEditor> editors = new HashSet<TextEditor>();
        for (TextEditor editor : this.lastSelectedEditors) {
            VirtualFile file = editor.getFile();
            if ((file == null || this.app.isReloading()) && this.app.isLatestVersionRunning(file)) continue;
            editors.add(editor);
        }
        this.currentStats.showFor(editors);
    }

    public void dispose() {
        if (this.currentStats != null) {
            this.currentStats.dispose();
            this.currentStats = null;
            this.listeners.clear();
        }
    }

    public void addPerfListener(PerfModel listener) {
        this.listeners.add(listener);
        if (this.currentStats != null) {
            this.currentStats.addPerfListener(listener);
        }
    }

    public void removePerfListener(PerfModel listener) {
        this.listeners.remove(listener);
        if (this.currentStats != null) {
            this.currentStats.removePerfListener(listener);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/perf/FlutterWidgetPerfManager";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedEditors";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/perf/FlutterWidgetPerfManager";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3 -> new IllegalArgumentException(string);
        };
    }
}

