/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.perf;

import com.google.common.base.Objects;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.impl.XSourcePositionImpl;

public class Location {
    public final int line;
    public final int column;
    public final int id;
    public final String path;
    public final TextRange textRange;
    public final String name;

    public Location(String path, int line, int column, int id, TextRange textRange, String name) {
        this.path = path;
        this.line = line;
        this.column = column;
        this.id = id;
        this.textRange = textRange;
        this.name = name;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Location)) {
            return false;
        }
        Location other = (Location)obj;
        return Objects.equal((Object)this.line, (Object)other.line) && Objects.equal((Object)this.column, (Object)other.column) && Objects.equal((Object)this.path, (Object)other.path) && Objects.equal((Object)this.id, (Object)other.id);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.line, this.column, this.path, this.id});
    }

    public XSourcePosition getXSourcePosition() {
        VirtualFile file = LocalFileSystem.getInstance().findFileByPath(this.path);
        if (file == null) {
            return null;
        }
        return XSourcePositionImpl.create((VirtualFile)file, (int)(this.line - 1), (int)(this.column - 1));
    }
}

