/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.perf;

import com.google.gson.JsonArray;
import io.flutter.perf.PerfReportKind;
import java.util.ArrayList;
import java.util.List;

public class PerfSourceReport {
    private final PerfReportKind kind;
    private static final int ENTRY_LENGTH = 2;
    private final List<Entry> entries;
    private final long startTime;

    public PerfSourceReport(JsonArray json, PerfReportKind kind, long startTime) {
        this.kind = kind;
        this.startTime = startTime;
        assert (json.size() % 2 == 0);
        this.entries = new ArrayList<Entry>(json.size() / 2);
        for (int i = 0; i < json.size(); i += 2) {
            this.entries.add(new Entry(json.get(i).getAsInt(), json.get(i + 1).getAsInt()));
        }
    }

    PerfReportKind getKind() {
        return this.kind;
    }

    List<Entry> getEntries() {
        return this.entries;
    }

    static class Entry {
        public final int locationId;
        public final int total;

        Entry(int locationId, int total) {
            this.locationId = locationId;
            this.total = total;
        }
    }
}

