/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.perf;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.concurrency.Semaphore;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dartlang.vm.service.VmService;
import org.dartlang.vm.service.consumer.GetIsolateConsumer;
import org.dartlang.vm.service.consumer.GetLibraryConsumer;
import org.dartlang.vm.service.consumer.GetObjectConsumer;
import org.dartlang.vm.service.element.Isolate;
import org.dartlang.vm.service.element.IsolateRef;
import org.dartlang.vm.service.element.Library;
import org.dartlang.vm.service.element.LibraryRef;
import org.dartlang.vm.service.element.Obj;
import org.dartlang.vm.service.element.RPCError;
import org.dartlang.vm.service.element.Script;
import org.dartlang.vm.service.element.ScriptRef;
import org.dartlang.vm.service.element.Sentinel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ScriptManager {
    private static final long RESPONSE_WAIT_TIMEOUT = 3000L;
    @NotNull
    private final VmService vmService;
    private final VirtualFileManager virtualFileManager;
    private IsolateRef isolateRef;
    private final Map<String, Script> scriptMap;
    private final Map<String, Map<Integer, Pair<Integer, Integer>>> linesAndColumnsMap;

    public ScriptManager(@NotNull VmService vmService) {
        if (vmService == null) {
            ScriptManager.$$$reportNull$$$0(0);
        }
        this.virtualFileManager = VirtualFileManager.getInstance();
        this.scriptMap = new HashMap<String, Script>();
        this.linesAndColumnsMap = new HashMap<String, Map<Integer, Pair<Integer, Integer>>>();
        this.vmService = vmService;
    }

    public void reset() {
        this.scriptMap.clear();
    }

    public void setCurrentIsolate(IsolateRef isolateRef) {
        this.isolateRef = isolateRef;
    }

    @Nullable
    private Isolate getCurrentIsolate() {
        final Ref resultRef = Ref.create();
        final Semaphore semaphore = new Semaphore();
        semaphore.down();
        this.vmService.getIsolate(this.isolateRef.getId(), new GetIsolateConsumer(){

            @Override
            public void received(Isolate isolate) {
                resultRef.set((Object)isolate);
                semaphore.up();
            }

            @Override
            public void received(Sentinel sentinel) {
                semaphore.up();
            }

            @Override
            public void onError(RPCError error) {
                semaphore.up();
            }
        });
        semaphore.waitFor(3000L);
        return (Isolate)resultRef.get();
    }

    @Nullable
    public ScriptRef getScriptRefFor(@NotNull VirtualFile file) {
        Isolate isolate;
        if (file == null) {
            ScriptManager.$$$reportNull$$$0(1);
        }
        if ((isolate = this.getCurrentIsolate()) == null) {
            return null;
        }
        for (LibraryRef libraryRef : isolate.getLibraries()) {
            Library library;
            VirtualFile libraryFile;
            String uri = libraryRef.getUri();
            if (!uri.startsWith("file:") || !file.equals(libraryFile = this.virtualFileManager.findFileByUrl(uri)) || (library = this.getLibrary(libraryRef)) == null || library.getScripts().isEmpty()) continue;
            return library.getScripts().get(0);
        }
        return null;
    }

    @Nullable
    private Library getLibrary(LibraryRef libraryRef) {
        final Ref resultRef = Ref.create();
        final Semaphore semaphore = new Semaphore();
        semaphore.down();
        this.vmService.getLibrary(this.isolateRef.getId(), libraryRef.getId(), new GetLibraryConsumer(){

            @Override
            public void received(Library library) {
                resultRef.set((Object)library);
                semaphore.up();
            }

            @Override
            public void onError(RPCError error) {
                semaphore.up();
            }
        });
        semaphore.waitFor(3000L);
        return (Library)resultRef.get();
    }

    public void populateFor(ScriptRef scriptRef) {
        if (!this.scriptMap.containsKey(scriptRef.getId())) {
            this.scriptMap.put(scriptRef.getId(), this.getScriptSync(scriptRef));
            this.linesAndColumnsMap.put(scriptRef.getId(), ScriptManager.createTokenPosToLineAndColumnMap(this.scriptMap.get(scriptRef.getId())));
        }
    }

    public Pair<Integer, Integer> getLineColumnPosForTokenPos(@NotNull ScriptRef scriptRef, int tokenPos) {
        Map<Integer, Pair<Integer, Integer>> map;
        if (scriptRef == null) {
            ScriptManager.$$$reportNull$$$0(2);
        }
        return (map = this.linesAndColumnsMap.get(scriptRef.getId())) == null ? null : map.get(tokenPos);
    }

    private Script getScriptSync(@NotNull ScriptRef scriptRef) {
        if (scriptRef == null) {
            ScriptManager.$$$reportNull$$$0(3);
        }
        final Ref resultRef = Ref.create();
        final Semaphore semaphore = new Semaphore();
        semaphore.down();
        this.vmService.getObject(this.isolateRef.getId(), scriptRef.getId(), new GetObjectConsumer(){

            @Override
            public void received(Obj script) {
                resultRef.set((Object)((Script)script));
                semaphore.up();
            }

            @Override
            public void received(Sentinel response) {
                semaphore.up();
            }

            @Override
            public void onError(RPCError error) {
                semaphore.up();
            }
        });
        semaphore.waitFor(3000L);
        return (Script)resultRef.get();
    }

    private static Map<Integer, Pair<Integer, Integer>> createTokenPosToLineAndColumnMap(@Nullable Script script) {
        if (script == null) {
            return null;
        }
        HashMap<Integer, Pair<Integer, Integer>> result = new HashMap<Integer, Pair<Integer, Integer>>();
        for (List<Integer> lineAndPairs : script.getTokenPosTable()) {
            Iterator<Integer> iterator = lineAndPairs.iterator();
            int line = Math.max(0, iterator.next() - 1);
            while (iterator.hasNext()) {
                int tokenPos = iterator.next();
                int column = Math.max(0, iterator.next() - 1);
                result.put(tokenPos, (Pair<Integer, Integer>)Pair.create((Object)line, (Object)column));
            }
        }
        return result;
    }

    @Nullable
    public Script getScriptFor(@NotNull ScriptRef ref) {
        if (ref == null) {
            ScriptManager.$$$reportNull$$$0(4);
        }
        return this.scriptMap.get(ref.getId());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vmService";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptRef";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
        }
        objectArray2[1] = "io/flutter/perf/ScriptManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getScriptRefFor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getLineColumnPosForTokenPos";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getScriptSync";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getScriptFor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

