/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.perf;

import io.flutter.perf.PerfMetric;

class SlidingWindowStats {
    static final int _windowLength = 400;
    final int[] _window = new int[400];
    int _next = 0;
    int _start = 0;
    int _total = 0;
    int _totalSinceNavigation = 0;

    SlidingWindowStats() {
    }

    int getTotal() {
        return this._total;
    }

    int getTotalSinceNavigation() {
        return this._totalSinceNavigation;
    }

    void clear() {
        this._next = 0;
        this._start = 0;
        this._total = 0;
        this._totalSinceNavigation = 0;
    }

    void onNavigation() {
        this._totalSinceNavigation = 0;
    }

    int getTotalWithinWindow(int windowStart) {
        if (this._next == this._start) {
            return 0;
        }
        int end = this._start >= 0 ? this._start : this._next;
        int i = this._next;
        int count = 0;
        do {
            if ((i -= 2) < 0) {
                i += 400;
            }
            if (this._window[i] < windowStart) break;
            count += this._window[i + 1];
        } while (i != end);
        return count;
    }

    void add(int count, int timeStamp) {
        this._total += count;
        this._totalSinceNavigation += count;
        if (this._start != this._next) {
            int lastTimeStamp;
            int last = this._next - 2;
            if (last < 0) {
                last += 400;
            }
            if ((lastTimeStamp = this._window[last]) == timeStamp) {
                int n = last + 1;
                this._window[n] = this._window[n] + count;
                return;
            }
            assert (lastTimeStamp < timeStamp);
        }
        this._window[this._next] = timeStamp;
        this._window[this._next + 1] = count;
        this._next += 2;
        if (this._next == 400) {
            this._next = 0;
        }
        if (this._start == this._next) {
            this._start = -1;
        }
    }

    public int getPeakWithinWindow(int windowStart) {
        if (this._next == this._start) {
            return 0;
        }
        int end = this._start >= 0 ? this._start : this._next;
        int i = this._next;
        int peakValue = 0;
        do {
            if ((i -= 2) < 0) {
                i += 400;
            }
            if (this._window[i] < windowStart) break;
            peakValue = Math.max(peakValue, this._window[i + 1]);
        } while (i != end);
        return peakValue;
    }

    public int getValue(PerfMetric metric, int currentTime) {
        switch (metric) {
            case total: {
                return this.getTotal();
            }
            case pastSecond: {
                return this.getTotalWithinWindow(currentTime - 999);
            }
            case lastFrame: {
                return this.getPeakWithinWindow(currentTime);
            }
            case peakRecent: {
                return this.getPeakWithinWindow(currentTime - 499);
            }
            case totalSinceEnteringCurrentScreen: {
                return this.getTotalSinceNavigation();
            }
        }
        return 0;
    }
}

