/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.perf;

import io.flutter.perf.Location;
import io.flutter.perf.PerfMetric;
import io.flutter.perf.PerfReportKind;
import io.flutter.perf.SlidingWindowStatsSummary;

public class SummaryStats {
    private final PerfReportKind kind;
    private final SlidingWindowStatsSummary entry;
    private final String description;
    boolean active = true;

    SummaryStats(PerfReportKind kind, SlidingWindowStatsSummary entry, String description) {
        this.kind = kind;
        this.entry = entry;
        this.description = description;
    }

    public PerfReportKind getKind() {
        return this.kind;
    }

    public int getValue(PerfMetric metric) {
        if (metric.timeIntervalMetric && !this.active) {
            return 0;
        }
        return this.entry.getValue(metric);
    }

    public void markAppIdle() {
        this.active = false;
    }

    public String getDescription() {
        return this.description;
    }

    public Location getLocation() {
        return this.entry.getLocation();
    }
}

