/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.perf;

import com.google.gson.JsonObject;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import io.flutter.inspector.DiagnosticsNode;
import io.flutter.inspector.InspectorService;
import io.flutter.perf.PerfReportKind;
import io.flutter.perf.When;
import io.flutter.perf.WidgetPerfListener;
import io.flutter.perf.WidgetPerfProvider;
import io.flutter.run.daemon.FlutterApp;
import io.flutter.utils.StreamSubscription;
import io.flutter.utils.VmServiceListenerAdapter;
import io.flutter.vmService.VMServiceManager;
import java.util.concurrent.CompletableFuture;
import org.dartlang.vm.service.VmService;
import org.dartlang.vm.service.VmServiceListener;
import org.dartlang.vm.service.element.Event;
import org.dartlang.vm.service.element.IsolateRef;
import org.jetbrains.annotations.NotNull;

public class VmServiceWidgetPerfProvider
implements WidgetPerfProvider {
    @NotNull
    final FlutterApp.FlutterAppListener appListener;
    @NotNull
    final FlutterApp app;
    private VmServiceListener vmServiceListener;
    private WidgetPerfListener target;
    private boolean started;
    private boolean isStarted;
    private boolean isDisposed;
    private boolean connected;
    private StreamSubscription<IsolateRef> isolateRefStreamSubscription;
    private CompletableFuture<InspectorService> inspectorService;

    VmServiceWidgetPerfProvider(final @NotNull FlutterApp app) {
        if (app == null) {
            VmServiceWidgetPerfProvider.$$$reportNull$$$0(0);
        }
        this.isDisposed = false;
        this.app = app;
        this.appListener = new FlutterApp.FlutterAppListener(){

            @Override
            public void stateChanged(FlutterApp.State newState) {
                if (!VmServiceWidgetPerfProvider.this.started && app.isStarted()) {
                    VmServiceWidgetPerfProvider.this.started = true;
                    VmServiceWidgetPerfProvider.this.requestRepaint(When.now);
                }
            }

            @Override
            public void notifyAppReloaded() {
                VmServiceWidgetPerfProvider.this.requestRepaint(When.now);
            }

            @Override
            public void notifyAppRestarted() {
                VmServiceWidgetPerfProvider.this.requestRepaint(When.now);
            }

            @Override
            public void notifyFrameRendered() {
                VmServiceWidgetPerfProvider.this.requestRepaint(When.soon);
            }

            @Override
            public void notifyVmServiceAvailable(VmService vmService) {
                VmServiceWidgetPerfProvider.this.setupConnection(vmService);
            }
        };
        app.addStateListener(this.appListener);
        if (app.getVmService() != null) {
            this.setupConnection(app.getVmService());
        }
        this.started = app.isStarted();
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    @Override
    public void setTarget(WidgetPerfListener widgetPerfListener) {
        this.target = widgetPerfListener;
    }

    private void requestRepaint(When now) {
        if (this.target != null) {
            this.target.requestRepaint(now);
        }
    }

    private void onWidgetPerfEvent(PerfReportKind kind, JsonObject json) {
        if (this.target != null) {
            this.target.onWidgetPerfEvent(kind, json);
        }
    }

    private void onNavigation() {
        if (this.target != null) {
            this.target.onNavigation();
        }
    }

    public void dispose() {
        this.app.removeStateListener(this.appListener);
        if (this.isolateRefStreamSubscription != null) {
            this.isolateRefStreamSubscription.dispose();
        }
        this.isDisposed = true;
        this.connected = false;
        if (this.vmServiceListener != null && this.app.getVmService() != null) {
            this.app.getVmService().removeVmServiceListener(this.vmServiceListener);
        }
    }

    private void setupConnection(@NotNull VmService vmService) {
        if (vmService == null) {
            VmServiceWidgetPerfProvider.$$$reportNull$$$0(1);
        }
        if (this.isDisposed || this.connected) {
            return;
        }
        VMServiceManager vmServiceManager = this.app.getVMServiceManager();
        assert (vmServiceManager != null);
        this.connected = true;
        this.isolateRefStreamSubscription = vmServiceManager.getCurrentFlutterIsolate(isolateRef -> this.requestRepaint(When.soon), false);
        vmService.addVmServiceListener(new VmServiceListenerAdapter(){

            @Override
            public void received(String streamId, Event event) {
                VmServiceWidgetPerfProvider.this.onVmServiceReceived(streamId, event);
            }

            @Override
            public void connectionClosed() {
            }
        });
        this.inspectorService = InspectorService.create(this.app, this.app.getFlutterDebugProcess(), this.app.getVmService());
        this.inspectorService.whenCompleteAsync((service, throwable) -> Disposer.register((Disposable)this, (Disposable)service));
        this.requestRepaint(When.soon);
    }

    private IsolateRef getCurrentIsolateRef() {
        assert (this.app.getVMServiceManager() != null);
        return this.app.getVMServiceManager().getCurrentFlutterIsolateRaw();
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    @Override
    public boolean shouldDisplayPerfStats(FileEditor editor) {
        return !this.app.isReloading() && this.app.isLatestVersionRunning(editor.getFile()) && !editor.isModified();
    }

    @Override
    public CompletableFuture<DiagnosticsNode> getWidgetTree() {
        return this.inspectorService.thenComposeAsync(inspectorService -> inspectorService.createObjectGroup("widget_perf").getSummaryTreeWithoutIds());
    }

    private void onVmServiceReceived(String streamId, Event event) {
        if (StringUtil.equals((CharSequence)streamId, (CharSequence)"Extension")) {
            String kind = event.getExtensionKind();
            if (kind == null) {
                return;
            }
            switch (kind) {
                case "Flutter.Frame": {
                    JsonObject extensionData = event.getExtensionData().getJson();
                    this.requestRepaint(When.soon);
                    break;
                }
                case "Flutter.RebuiltWidgets": {
                    this.onWidgetPerfEvent(PerfReportKind.rebuild, event.getExtensionData().getJson());
                    break;
                }
                case "Flutter.RepaintedWidgets": {
                    this.onWidgetPerfEvent(PerfReportKind.repaint, event.getExtensionData().getJson());
                    break;
                }
                case "Flutter.Navigation": {
                    this.onNavigation();
                }
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "app";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vmService";
                break;
            }
        }
        objectArray2[1] = "io/flutter/perf/VmServiceWidgetPerfProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "setupConnection";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

