/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.perf;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.fileEditor.TextEditor;
import io.flutter.FlutterBundle;
import io.flutter.inspector.DiagnosticsNode;
import io.flutter.perf.FilePerfInfo;
import io.flutter.perf.FlutterWidgetPerf;
import io.flutter.perf.Location;
import io.flutter.perf.PerfReportKind;
import io.flutter.perf.PerfTip;
import io.flutter.perf.PerfTipRule;
import io.flutter.perf.SummaryStats;
import io.flutter.perf.WidgetPerfProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;

public class WidgetPerfLinter {
    private static List<PerfTipRule> tips;
    final FlutterWidgetPerf widgetPerf;
    private final WidgetPerfProvider perfProvider;
    private ArrayList<PerfTip> lastTips;
    private Set<Location> lastCandidateLocations;
    private Multimap<Integer, DiagnosticsNode> nodesForLocation;

    WidgetPerfLinter(FlutterWidgetPerf widgetPerf, WidgetPerfProvider perfProvider) {
        this.widgetPerf = widgetPerf;
        this.perfProvider = perfProvider;
    }

    static List<PerfTipRule> getAllTips() {
        if (tips != null) {
            return tips;
        }
        tips = new ArrayList<PerfTipRule>();
        tips.add(new PerfTipRule(PerfReportKind.rebuild, 3, "perf_diagnosis_demo/lib/clock_demo.dart", "Performance considerations of StatefulWidget", "statefulWidget", FlutterBundle.message("flutter.perf.linter.statefulWidget.url", new Object[0]), PerfTipRule.matchParent("StatefulWidget"), 4, 50, 20, AllIcons.Actions.IntentionBulb));
        tips.add(new PerfTipRule(PerfReportKind.rebuild, 1, "perf_diagnosis_demo/lib/list_demo.dart", "Using ListView to load items efficiently", "listViewLoad", FlutterBundle.message("flutter.perf.linter.listViewLoad.url", new Object[0]), PerfTipRule.matchParent("ListView"), 1, 40, -1, AllIcons.Actions.IntentionBulb));
        tips.add(new PerfTipRule(PerfReportKind.rebuild, 1, "perf_diagnosis_demo/lib/spinning_box_demo.dart", "Performance optimizations when using AnimatedBuilder", "animatedBuilder", FlutterBundle.message("flutter.perf.linter.animatedBuilder.url", new Object[0]), PerfTipRule.matchParent("AnimatedBuilder"), 1, 50, 20, AllIcons.Actions.IntentionBulb));
        tips.add(new PerfTipRule(PerfReportKind.rebuild, 2, "perf_diagnosis_demo/lib/scorecard_demo.dart", "Performance considerations of Opacity animations", "opacityAnimations", FlutterBundle.message("flutter.perf.linter.opacityAnimations.url", new Object[0]), PerfTipRule.matchParent("Opacity"), 1, 20, 8, AllIcons.Actions.IntentionBulb));
        return tips;
    }

    public CompletableFuture<ArrayList<PerfTip>> getTipsFor(Set<TextEditor> textEditors) {
        ArrayList<PerfTipRule> candidateRules = new ArrayList<PerfTipRule>();
        HashSet<Location> candidateLocations = new HashSet<Location>();
        ArrayList<FilePerfInfo> allFileStats = this.widgetPerf.buildAllSummaryStats(textEditors);
        for (PerfTipRule rule : WidgetPerfLinter.getAllTips()) {
            block1: for (FilePerfInfo fileStats : allFileStats) {
                for (SummaryStats stats : fileStats.getStats()) {
                    if (!rule.maybeMatches(stats)) continue;
                    candidateRules.add(rule);
                    candidateLocations.add(stats.getLocation());
                    continue block1;
                }
            }
        }
        if (candidateRules.isEmpty()) {
            return CompletableFuture.completedFuture(new ArrayList());
        }
        if (candidateLocations.equals(this.lastCandidateLocations)) {
            return CompletableFuture.completedFuture(this.computeMatches(candidateRules, allFileStats));
        }
        this.lastCandidateLocations = candidateLocations;
        return this.perfProvider.getWidgetTree().thenApplyAsync(treeRoot -> {
            if (treeRoot != null) {
                this.nodesForLocation = LinkedListMultimap.create();
                this.addNodesToMap((DiagnosticsNode)treeRoot);
                return this.computeMatches(candidateRules, allFileStats);
            }
            return new ArrayList();
        });
    }

    private ArrayList<PerfTip> computeMatches(ArrayList<PerfTipRule> candidateRules, ArrayList<FilePerfInfo> allFileStats) {
        ArrayList<PerfTip> matches = new ArrayList<PerfTip>();
        HashMap<PerfReportKind, HashMap<Integer, SummaryStats>> maps = new HashMap<PerfReportKind, HashMap<Integer, SummaryStats>>();
        for (FilePerfInfo fileStats : allFileStats) {
            for (SummaryStats stats : fileStats.getStats()) {
                HashMap<Integer, SummaryStats> map = (HashMap<Integer, SummaryStats>)maps.get((Object)stats.getKind());
                if (map == null) {
                    map = new HashMap<Integer, SummaryStats>();
                    maps.put(stats.getKind(), map);
                }
                map.put(stats.getLocation().id, stats);
            }
        }
        for (PerfTipRule rule : candidateRules) {
            Map map = (Map)maps.get((Object)rule.kind);
            if (map == null) continue;
            ArrayList<Location> matchingLocations = new ArrayList<Location>();
            for (FilePerfInfo fileStats : allFileStats) {
                for (SummaryStats stats : fileStats.getStats()) {
                    if (this.nodesForLocation == null) continue;
                    assert (stats.getLocation() != null);
                    Collection nodes = this.nodesForLocation.get((Object)stats.getLocation().id);
                    if (nodes == null || nodes.isEmpty() || !rule.matches(stats, nodes, map)) continue;
                    matchingLocations.add(stats.getLocation());
                }
                if (matchingLocations.isEmpty()) continue;
                matches.add(new PerfTip(rule, matchingLocations, 1.0 / (double)rule.priority));
            }
        }
        matches.sort(Comparator.comparingDouble(a -> -a.getConfidence()));
        HashSet<PerfTipRule> matchingRules = new HashSet<PerfTipRule>();
        ArrayList<PerfTip> uniqueMatches = new ArrayList<PerfTip>();
        for (PerfTip match : matches) {
            if (!matchingRules.add(match.rule)) continue;
            uniqueMatches.add(match);
        }
        return uniqueMatches;
    }

    private void addNodesToMap(DiagnosticsNode node) {
        ArrayList children;
        int id = node.getLocationId();
        if (id >= 0) {
            this.nodesForLocation.put((Object)id, (Object)node);
        }
        if ((children = (ArrayList)node.getChildren().getNow(null)) != null) {
            for (DiagnosticsNode child : children) {
                this.addNodesToMap(child);
            }
        }
    }
}

