/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.performance;

import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.icons.AllIcons;
import com.intellij.ide.browsers.BrowserLauncher;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import icons.FlutterIcons;
import io.flutter.bazel.WorkspaceCache;
import io.flutter.devtools.DevToolsUrl;
import io.flutter.performance.PerfFPSPanel;
import io.flutter.performance.PerfMemoryPanel;
import io.flutter.performance.PerfViewAppState;
import io.flutter.performance.PerfWidgetRebuildsPanel;
import io.flutter.run.FlutterDevice;
import io.flutter.run.FlutterLaunchMode;
import io.flutter.run.daemon.DevToolsService;
import io.flutter.run.daemon.FlutterApp;
import io.flutter.sdk.FlutterSdk;
import io.flutter.utils.AsyncUtils;
import io.flutter.utils.VmServiceListenerAdapter;
import io.flutter.view.DebugPaintAction;
import io.flutter.view.FlutterViewAction;
import io.flutter.view.FlutterViewMessages;
import io.flutter.view.PerformanceOverlayAction;
import io.flutter.view.ShowPaintBaselinesAction;
import io.flutter.view.TimeDilationAction;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import org.jetbrains.annotations.NotNull;

public class FlutterPerformanceView
implements Disposable {
    public static final String TOOL_WINDOW_ID = "Flutter Performance";
    private static final Logger LOG = Logger.getInstance(FlutterPerformanceView.class);
    @NotNull
    private final Project myProject;
    private final Map<FlutterApp, PerfViewAppState> perAppViewState;
    private Content emptyContent;

    public FlutterPerformanceView(@NotNull Project project) {
        if (project == null) {
            FlutterPerformanceView.$$$reportNull$$$0(0);
        }
        this.perAppViewState = new HashMap<FlutterApp, PerfViewAppState>();
        this.myProject = project;
    }

    void initToolWindow(ToolWindow window) {
        if (window.isDisposed()) {
            return;
        }
        this.updateForEmptyContent(window);
    }

    public void dispose() {
        Disposer.dispose((Disposable)this);
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            FlutterPerformanceView.$$$reportNull$$$0(1);
        }
        return project;
    }

    private void updateForEmptyContent(ToolWindow toolWindow) {
        if (toolWindow.isDisposed()) {
            return;
        }
        toolWindow.setIcon(FlutterIcons.Flutter_13);
        ContentManager contentManager = toolWindow.getContentManager();
        JPanel panel2 = new JPanel(new BorderLayout());
        JBLabel label = new JBLabel("No running applications", 0);
        label.setForeground(UIUtil.getLabelDisabledForeground());
        panel2.add((Component)label, "Center");
        this.emptyContent = contentManager.getFactory().createContent((JComponent)panel2, null, false);
        contentManager.addContent(this.emptyContent);
    }

    void debugActive(@NotNull FlutterViewMessages.FlutterDebugEvent event) {
        if (event == null) {
            FlutterPerformanceView.$$$reportNull$$$0(2);
        }
        final FlutterApp app = event.app;
        ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)this.myProject);
        if (!(toolWindowManager instanceof ToolWindowManagerEx)) {
            return;
        }
        final ToolWindow toolWindow = toolWindowManager.getToolWindow(TOOL_WINDOW_ID);
        if (toolWindow == null) {
            return;
        }
        if (!toolWindow.isAvailable()) {
            toolWindow.setAvailable(true, null);
        }
        this.addPerformanceViewContent(app, toolWindow);
        app.getVmService().addVmServiceListener(new VmServiceListenerAdapter(){

            @Override
            public void connectionOpened() {
                FlutterPerformanceView.this.onAppChanged(app);
            }

            @Override
            public void connectionClosed() {
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (toolWindow.isDisposed()) {
                        return;
                    }
                    ContentManager contentManager = toolWindow.getContentManager();
                    FlutterPerformanceView.this.onAppChanged(app);
                    PerfViewAppState state = FlutterPerformanceView.this.perAppViewState.remove(app);
                    if (state != null) {
                        if (state.content != null) {
                            contentManager.removeContent(state.content, true);
                        }
                        if (state.disposable != null) {
                            Disposer.dispose((Disposable)state.disposable);
                        }
                    }
                    if (FlutterPerformanceView.this.perAppViewState.isEmpty()) {
                        FlutterPerformanceView.this.updateForEmptyContent(toolWindow);
                    }
                });
            }
        });
        this.onAppChanged(app);
    }

    private void addPerformanceViewContent(FlutterApp app, ToolWindow toolWindow) {
        boolean isInProfileMode;
        ContentManager contentManager = toolWindow.getContentManager();
        SimpleToolWindowPanel toolWindowPanel = new SimpleToolWindowPanel(true);
        FlutterDevice device = app.device();
        ArrayList<FlutterDevice> existingDevices = new ArrayList<FlutterDevice>();
        for (FlutterApp otherApp : this.perAppViewState.keySet()) {
            existingDevices.add(otherApp.device());
        }
        String tabName = device.getUniqueName(existingDevices);
        JPanel mainContentPanel = new JPanel(new BorderLayout());
        Content content = contentManager.getFactory().createContent(null, tabName, false);
        content.setComponent((JComponent)mainContentPanel);
        content.putUserData(ToolWindow.SHOW_CONTENT_ICON, (Object)Boolean.TRUE);
        content.setIcon(FlutterIcons.Phone);
        contentManager.addContent(content);
        Box perfViewsPanel = Box.createVerticalBox();
        perfViewsPanel.setBorder((Border)JBUI.Borders.empty((int)0, (int)3));
        mainContentPanel.add((Component)perfViewsPanel, "Center");
        if (this.emptyContent != null) {
            contentManager.removeContent(this.emptyContent, true);
            this.emptyContent = null;
        }
        toolWindow.setIcon(ExecutionUtil.getLiveIndicator((Icon)FlutterIcons.Flutter_13));
        PerfViewAppState state = this.getOrCreateStateForApp(app);
        assert (state.content == null);
        state.content = content;
        DefaultActionGroup toolbarGroup = this.createToolbar(toolWindow, app, this);
        toolWindowPanel.setToolbar(ActionManager.getInstance().createActionToolbar("FlutterPerfViewToolbar", (ActionGroup)toolbarGroup, true).getComponent());
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("PerformanceToolbar", (ActionGroup)toolbarGroup, true);
        JComponent toolbarComponent = toolbar.getComponent();
        toolbarComponent.setBorder(IdeBorderFactory.createBorder((int)8));
        mainContentPanel.add((Component)toolbarComponent, "North");
        JPanel footer = new JPanel(new BorderLayout());
        footer.setBorder(new CompoundBorder(IdeBorderFactory.createBorder((int)2), (Border)JBUI.Borders.empty((int)5, (int)7)));
        JBLabel runModeLabel = new JBLabel("Run mode: " + String.valueOf((Object)app.getLaunchMode()));
        if (app.getLaunchMode() == FlutterLaunchMode.DEBUG) {
            runModeLabel.setIcon(AllIcons.General.BalloonInformation);
            runModeLabel.setToolTipText("Note: debug mode frame rendering times are not indicative of release mode performance");
        }
        LinkLabel openDevtools = new LinkLabel("Open DevTools...", null);
        openDevtools.setListener((linkLabel, data) -> AsyncUtils.whenCompleteUiThread(DevToolsService.getInstance(app.getProject()).getDevToolsInstance(), (instance, ex) -> {
            if (app.getProject().isDisposed()) {
                return;
            }
            if (ex != null) {
                LOG.error(ex);
                return;
            }
            FlutterSdk flutterSdk = FlutterSdk.getFlutterSdk(app.getProject());
            BrowserLauncher.getInstance().browse(new DevToolsUrl(instance.host, instance.port, app.getConnector().getBrowserUrl(), null, false, null, null, flutterSdk == null ? null : flutterSdk.getVersion(), WorkspaceCache.getInstance(app.getProject()), null).getUrlString(), null);
        }), null);
        footer.add((Component)runModeLabel, "West");
        footer.add((Component)openDevtools, "East");
        mainContentPanel.add((Component)footer, "South");
        boolean debugConnectionAvailable = app.getLaunchMode().supportsDebugConnection();
        boolean bl = isInProfileMode = app.getMode().isProfiling() || app.getLaunchMode().isProfiling();
        if (debugConnectionAvailable) {
            state.disposable = Disposer.newDisposable();
            PerfFPSPanel fpsPanel = new PerfFPSPanel(app, this);
            perfViewsPanel.add((Component)((Object)fpsPanel));
            PerfMemoryPanel memoryPanel = new PerfMemoryPanel(app, this);
            perfViewsPanel.add((Component)((Object)memoryPanel));
            PerfWidgetRebuildsPanel widgetRebuildsPanel = new PerfWidgetRebuildsPanel(app, this);
            perfViewsPanel.add((Component)((Object)widgetRebuildsPanel));
            if (isInProfileMode) {
                this.activateToolWindow();
            }
        } else {
            JBLabel label = new JBLabel("Profiling is not available in release mode", 0);
            label.setForeground(UIUtil.getLabelDisabledForeground());
            mainContentPanel.add((Component)label, "Center");
        }
    }

    private DefaultActionGroup createToolbar(@NotNull ToolWindow toolWindow, @NotNull FlutterApp app, Disposable parentDisposable) {
        if (toolWindow == null) {
            FlutterPerformanceView.$$$reportNull$$$0(3);
        }
        if (app == null) {
            FlutterPerformanceView.$$$reportNull$$$0(4);
        }
        DefaultActionGroup toolbarGroup = new DefaultActionGroup();
        toolbarGroup.add((AnAction)this.registerAction(new PerformanceOverlayAction(app)));
        toolbarGroup.addSeparator();
        toolbarGroup.add((AnAction)this.registerAction(new DebugPaintAction(app)));
        toolbarGroup.add((AnAction)this.registerAction(new ShowPaintBaselinesAction(app, true)));
        toolbarGroup.addSeparator();
        toolbarGroup.add((AnAction)this.registerAction(new TimeDilationAction(app, true)));
        return toolbarGroup;
    }

    FlutterViewAction registerAction(FlutterViewAction action) {
        this.getOrCreateStateForApp((FlutterApp)action.app).flutterViewActions.add(action);
        return action;
    }

    public void showForApp(@NotNull FlutterApp app) {
        ToolWindow toolWindow;
        PerfViewAppState appState;
        if (app == null) {
            FlutterPerformanceView.$$$reportNull$$$0(5);
        }
        if ((appState = this.perAppViewState.get(app)) != null && (toolWindow = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow(TOOL_WINDOW_ID)) != null) {
            toolWindow.getContentManager().setSelectedContent(appState.content);
        }
    }

    public void showForAppRebuildCounts(@NotNull FlutterApp app) {
        ToolWindow toolWindow;
        PerfViewAppState appState;
        if (app == null) {
            FlutterPerformanceView.$$$reportNull$$$0(6);
        }
        if ((appState = this.perAppViewState.get(app)) != null && (toolWindow = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow(TOOL_WINDOW_ID)) != null) {
            toolWindow.getContentManager().setSelectedContent(appState.content);
        }
    }

    private void onAppChanged(FlutterApp app) {
        if (this.myProject.isDisposed()) {
            return;
        }
        ToolWindow toolWindow = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow(TOOL_WINDOW_ID);
        if (toolWindow == null) {
            return;
        }
    }

    private void activateToolWindow() {
        ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)this.myProject);
        ToolWindow toolWindow = toolWindowManager.getToolWindow(TOOL_WINDOW_ID);
        if (toolWindow == null || toolWindow.isVisible()) {
            return;
        }
        toolWindow.show(null);
    }

    private PerfViewAppState getStateForApp(FlutterApp app) {
        return this.perAppViewState.get(app);
    }

    private PerfViewAppState getOrCreateStateForApp(FlutterApp app) {
        return this.perAppViewState.computeIfAbsent(app, k -> new PerfViewAppState());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/performance/FlutterPerformanceView";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindow";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "app";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/performance/FlutterPerformanceView";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "debugActive";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createToolbar";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "showForApp";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "showForAppRebuildCounts";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

