/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.performance;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowFactory;
import com.intellij.openapi.wm.ToolWindowManager;
import io.flutter.performance.FlutterPerformanceView;
import io.flutter.utils.ViewListener;
import io.flutter.view.FlutterViewMessages;
import org.jetbrains.annotations.NotNull;

public class FlutterPerformanceViewFactory
implements ToolWindowFactory,
DumbAware {
    private static final String TOOL_WINDOW_VISIBLE_PROPERTY = "flutter.performance.tool.window.visible";

    public static void init(@NotNull Project project) {
        if (project == null) {
            FlutterPerformanceViewFactory.$$$reportNull$$$0(0);
        }
        project.getMessageBus().connect().subscribe(FlutterViewMessages.FLUTTER_DEBUG_TOPIC, event -> FlutterPerformanceViewFactory.initPerfView(project, event));
        ToolWindow window = ToolWindowManager.getInstance((Project)project).getToolWindow("Flutter Performance");
        if (window != null) {
            window.setAvailable(true);
            if (PropertiesComponent.getInstance((Project)project).getBoolean(TOOL_WINDOW_VISIBLE_PROPERTY, false)) {
                window.activate(null, false);
            }
        }
    }

    private static void initPerfView(@NotNull Project project, FlutterViewMessages.FlutterDebugEvent event) {
        if (project == null) {
            FlutterPerformanceViewFactory.$$$reportNull$$$0(1);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            FlutterPerformanceView flutterPerfView = (FlutterPerformanceView)project.getService(FlutterPerformanceView.class);
            ToolWindowManager.getInstance((Project)project).getToolWindow("Flutter Performance").setAvailable(true);
            flutterPerfView.debugActive(event);
        });
    }

    public void createToolWindowContent(@NotNull Project project, @NotNull ToolWindow toolWindow) {
        if (project == null) {
            FlutterPerformanceViewFactory.$$$reportNull$$$0(2);
        }
        if (toolWindow == null) {
            FlutterPerformanceViewFactory.$$$reportNull$$$0(3);
        }
        DumbService.getInstance((Project)project).runWhenSmart(() -> ((FlutterPerformanceView)project.getService(FlutterPerformanceView.class)).initToolWindow(toolWindow));
    }

    public boolean shouldBeAvailable(@NotNull Project project) {
        if (project == null) {
            FlutterPerformanceViewFactory.$$$reportNull$$$0(4);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindow";
                break;
            }
        }
        objectArray2[1] = "io/flutter/performance/FlutterPerformanceViewFactory";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "init";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "initPerfView";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createToolWindowContent";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldBeAvailable";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class FlutterPerformanceViewListener
    extends ViewListener {
        public FlutterPerformanceViewListener(@NotNull Project project) {
            if (project == null) {
                FlutterPerformanceViewListener.$$$reportNull$$$0(0);
            }
            super(project, "Flutter Performance", FlutterPerformanceViewFactory.TOOL_WINDOW_VISIBLE_PROPERTY);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "io/flutter/performance/FlutterPerformanceViewFactory$FlutterPerformanceViewListener", "<init>"));
        }
    }
}

