/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.performance;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBPanel;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import io.flutter.performance.FrameRenderingPanel;
import io.flutter.performance.StackLayout;
import io.flutter.run.daemon.FlutterApp;
import io.flutter.vmService.FlutterFramesMonitor;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.text.DecimalFormat;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FrameRenderingDisplay {
    static final DecimalFormat df = new DecimalFormat();

    public static JPanel createJPanelView(@NotNull Disposable parentDisposable, @NotNull FlutterApp app) {
        if (parentDisposable == null) {
            FrameRenderingDisplay.$$$reportNull$$$0(0);
        }
        if (app == null) {
            FrameRenderingDisplay.$$$reportNull$$$0(1);
        }
        JPanel panel2 = new JPanel(new StackLayout());
        panel2.setDoubleBuffered(true);
        assert (app.getVMServiceManager() != null);
        FlutterFramesMonitor flutterFramesMonitor = app.getVMServiceManager().getFlutterFramesMonitor();
        FrameRenderingPanel frameRenderingPanel = new FrameRenderingPanel(flutterFramesMonitor, app.getDisplayRefreshRateManager());
        JBLabel targetFrameTimeLabel = new JBLabel();
        targetFrameTimeLabel.setFont(UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.SMALL));
        targetFrameTimeLabel.setForeground(UIUtil.getLabelDisabledForeground());
        targetFrameTimeLabel.setBorder(JBUI.Borders.empty((int)2));
        targetFrameTimeLabel.setOpaque(false);
        FrameRenderingDisplay.updateTargetLabelForRefreshRate(app.getDisplayRefreshRateManager().getCurrentDisplayRefreshRateRaw(), 60.0, targetFrameTimeLabel);
        app.getDisplayRefreshRateManager().getCurrentDisplayRefreshRate(fps -> FrameRenderingDisplay.updateTargetLabelForRefreshRate(fps, 60.0, targetFrameTimeLabel), false);
        JBPanel targetFrameTimePanel = new JBPanel();
        targetFrameTimePanel.setLayout((LayoutManager)new BoxLayout((Container)targetFrameTimePanel, 1));
        targetFrameTimePanel.setOpaque(false);
        targetFrameTimePanel.add(Box.createVerticalGlue());
        targetFrameTimePanel.add((Component)targetFrameTimeLabel);
        targetFrameTimePanel.add(Box.createVerticalGlue());
        panel2.add(frameRenderingPanel);
        panel2.add((Component)targetFrameTimePanel);
        FlutterFramesMonitor.Listener listener = event -> {
            frameRenderingPanel.update();
            SwingUtilities.invokeLater(() -> targetFrameTimeLabel.repaint());
        };
        flutterFramesMonitor.addListener(listener);
        Disposer.register((Disposable)parentDisposable, () -> flutterFramesMonitor.removeListener(listener));
        return panel2;
    }

    private static void updateTargetLabelForRefreshRate(@Nullable Double fps, @NotNull Double defaultRefreshRate, JBLabel targetLabel) {
        if (defaultRefreshRate == null) {
            FrameRenderingDisplay.$$$reportNull$$$0(2);
        }
        if (fps == null) {
            fps = defaultRefreshRate;
        }
        double targetFrameTime = Math.floor(1000.0 / fps);
        String targetFrameTimeText = Math.round(targetFrameTime) + "ms";
        targetLabel.setText(targetFrameTimeText);
        targetLabel.setToolTipText("Targeting " + targetFrameTimeText + " per frame will\nresult in " + Math.round(fps) + " frames per second. ");
        SwingUtilities.invokeLater(() -> targetLabel.repaint());
    }

    static {
        df.setMaximumFractionDigits(1);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "app";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultRefreshRate";
                break;
            }
        }
        objectArray2[1] = "io/flutter/performance/FrameRenderingDisplay";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createJPanelView";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "updateTargetLabelForRefreshRate";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

