/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.performance;

import com.intellij.ui.JBColor;
import com.intellij.util.ui.UIUtil;
import io.flutter.performance.FrameRenderingDisplay;
import io.flutter.vmService.DisplayRefreshRateManager;
import io.flutter.vmService.FlutterFramesMonitor;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Path2D;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

class FrameRenderingPanel
extends JPanel {
    private final FlutterFramesMonitor framesMonitor;
    private final DisplayRefreshRateManager displayRefreshRateManager;
    private final Map<FlutterFramesMonitor.FlutterFrameEvent, JComponent> frameWidgets;
    private Rectangle lastSavedBounds;
    private static final Stroke STROKE = new BasicStroke(0.5f, 0, 0, 10.0f, new float[]{2.0f, 2.0f}, 0.0f);

    FrameRenderingPanel(@NotNull FlutterFramesMonitor framesMonitor, @NotNull DisplayRefreshRateManager displayRefreshRateManager) {
        if (framesMonitor == null) {
            FrameRenderingPanel.$$$reportNull$$$0(0);
        }
        if (displayRefreshRateManager == null) {
            FrameRenderingPanel.$$$reportNull$$$0(1);
        }
        this.frameWidgets = new HashMap<FlutterFramesMonitor.FlutterFrameEvent, JComponent>();
        this.framesMonitor = framesMonitor;
        this.displayRefreshRateManager = displayRefreshRateManager;
        this.setLayout(null);
        Color color = UIUtil.getLabelDisabledForeground();
        this.setForeground(new Color(color.getRed(), color.getGreen(), color.getBlue(), 127));
    }

    public void update() {
        SwingUtilities.invokeLater(this::updateFromFramesMonitor);
    }

    @Override
    public void doLayout() {
        if (this.lastSavedBounds != null && !this.lastSavedBounds.equals(this.getBounds())) {
            this.lastSavedBounds = null;
            SwingUtilities.invokeLater(this::updateFromFramesMonitor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Rectangle bounds = this.getBounds();
        int height = bounds.height;
        if (height <= 20) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        float msPerPixel = 33333.332f / (float)height;
        float y = (float)this.displayRefreshRateManager.getTargetMicrosPerFrame() / msPerPixel;
        Stroke oldStroke = g2.getStroke();
        try {
            g2.setStroke(STROKE);
            Path2D.Float path = new Path2D.Float();
            ((Path2D)path).moveTo(34.0, (float)height - y);
            ((Path2D)path).lineTo(bounds.width, (float)height - y);
            g2.draw(path);
        }
        finally {
            g2.setStroke(oldStroke);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateFromFramesMonitor() {
        Rectangle bounds;
        HashSet<FlutterFramesMonitor.FlutterFrameEvent> frames = new HashSet<FlutterFramesMonitor.FlutterFrameEvent>(this.frameWidgets.keySet());
        this.lastSavedBounds = bounds = this.getBounds();
        int height = bounds.height;
        int inc = height <= 20 ? 1 : 2;
        int x = bounds.width;
        int widgetWidth = Math.min(Math.max(Math.round((float)height / 8.0f), 2), 5);
        FlutterFramesMonitor flutterFramesMonitor = this.framesMonitor;
        synchronized (flutterFramesMonitor) {
            for (FlutterFramesMonitor.FlutterFrameEvent frame : this.framesMonitor.frames) {
                if (x + widgetWidth < 0) break;
                x -= widgetWidth + inc;
                float msPerPixel = 33333.332f / (float)height;
                JComponent widget = this.frameWidgets.get(frame);
                if (widget != null) {
                    frames.remove(frame);
                } else {
                    widget = new JLabel();
                    widget.setOpaque(true);
                    widget.setBackground((Color)(frame.isSlowFrame() ? JBColor.RED : UIUtil.getLabelForeground()));
                    widget.setToolTipText(frame.isSlowFrame() ? "This frame took " + FrameRenderingDisplay.df.format((double)frame.elapsedMicros / 1000.0) + "ms to render, which\ncan cause frame rate to drop below " + Math.round(this.displayRefreshRateManager.getCurrentDisplayRefreshRateRaw()) + " FPS." : "This frame took " + FrameRenderingDisplay.df.format((double)frame.elapsedMicros / 1000.0) + "ms to render.");
                    this.frameWidgets.put(frame, widget);
                    this.add(widget);
                }
                int pixelHeight = Math.round((float)frame.elapsedMicros / msPerPixel);
                if (pixelHeight > height) {
                    pixelHeight = height;
                }
                pixelHeight = Math.max(1, pixelHeight);
                widget.setPreferredSize(new Dimension(widgetWidth, pixelHeight));
                widget.setBounds(x, height - pixelHeight, widgetWidth, pixelHeight);
                if (!frame.frameSetStart) continue;
                x -= widgetWidth;
            }
        }
        if (!frames.isEmpty()) {
            for (FlutterFramesMonitor.FlutterFrameEvent frame : frames) {
                JComponent widget = this.frameWidgets.remove(frame);
                this.remove(widget);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "framesMonitor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "displayRefreshRateManager";
                break;
            }
        }
        objectArray[1] = "io/flutter/performance/FrameRenderingPanel";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

