/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.performance;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBPanel;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import io.flutter.performance.FrameRenderingDisplay;
import io.flutter.run.daemon.FlutterApp;
import io.flutter.vmService.FlutterFramesMonitor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class PerfFPSPanel
extends JBPanel<PerfFPSPanel> {
    private static final NumberFormat fpsFormat = new DecimalFormat();
    private static final String PERFORMANCE_TAB_LABEL = "Frame rendering times";
    private final Disposable parentDisposable;
    @NotNull
    private final FlutterApp app;

    PerfFPSPanel(@NotNull FlutterApp app, @NotNull Disposable parentDisposable) {
        if (app == null) {
            PerfFPSPanel.$$$reportNull$$$0(0);
        }
        if (parentDisposable == null) {
            PerfFPSPanel.$$$reportNull$$$0(1);
        }
        this.app = app;
        this.parentDisposable = parentDisposable;
        this.buildUI();
    }

    private void buildUI() {
        this.setLayout(new BorderLayout(0, 3));
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), PERFORMANCE_TAB_LABEL));
        this.setMinimumSize(new Dimension(0, 140));
        this.setPreferredSize(new Dimension(Short.MAX_VALUE, 140));
        assert (this.app.getVMServiceManager() != null);
        FlutterFramesMonitor flutterFramesMonitor = this.app.getVMServiceManager().getFlutterFramesMonitor();
        JBLabel fpsLabel = new JBLabel(" ", 0);
        fpsLabel.setForeground(UIUtil.getLabelDisabledForeground());
        FlutterFramesMonitor.Listener listener = event -> {
            fpsLabel.setText(fpsFormat.format(flutterFramesMonitor.getFPS()) + " frames per second");
            SwingUtilities.invokeLater(() -> fpsLabel.repaint());
        };
        flutterFramesMonitor.addListener(listener);
        Disposer.register((Disposable)this.parentDisposable, () -> flutterFramesMonitor.removeListener(listener));
        fpsLabel.setBorder((Border)JBUI.Borders.empty((int)0, (int)5));
        JPanel frameRenderingPanel = new JPanel(new BorderLayout());
        JPanel frameRenderingDisplay = FrameRenderingDisplay.createJPanelView(this.parentDisposable, this.app);
        frameRenderingPanel.add((Component)fpsLabel, "North");
        frameRenderingPanel.add((Component)frameRenderingDisplay, "Center");
        this.add(frameRenderingPanel, "Center");
    }

    static {
        fpsFormat.setMinimumFractionDigits(1);
        fpsFormat.setMaximumFractionDigits(1);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "app";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "parentDisposable";
                break;
            }
        }
        objectArray[1] = "io/flutter/performance/PerfFPSPanel";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

