/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.performance;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.components.panels.VerticalLayout;
import com.intellij.util.ui.JBUI;
import io.flutter.inspector.WidgetPerfTipsPanel;
import io.flutter.perf.FlutterWidgetPerfManager;
import io.flutter.perf.PerfMetric;
import io.flutter.perf.PerfReportKind;
import io.flutter.performance.WidgetPerfSummary;
import io.flutter.run.daemon.FlutterApp;
import io.flutter.vmService.ServiceExtensions;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import org.jetbrains.annotations.NotNull;

public class PerfWidgetRebuildsPanel
extends JBPanel<PerfWidgetRebuildsPanel> {
    private static final Logger LOG = Logger.getInstance(PerfWidgetRebuildsPanel.class);
    private static final String REBUILD_STATS_TAB_LABEL = "Widget rebuild stats";
    private static final boolean ENABLE_TRACK_REPAINTS = false;
    @NotNull
    private final FlutterApp app;
    private final WidgetPerfSummary perfSummary;
    private final JCheckBox trackRebuildsCheckbox;
    private JCheckBox trackRepaintsCheckbox;
    private final JPanel perfSummaryContainer;
    private final JPanel perfSummaryPlaceholder;
    private JComponent currentSummaryView;

    PerfWidgetRebuildsPanel(@NotNull FlutterApp app, @NotNull Disposable parentDisposable) {
        boolean isInProfileMode;
        if (app == null) {
            PerfWidgetRebuildsPanel.$$$reportNull$$$0(0);
        }
        if (parentDisposable == null) {
            PerfWidgetRebuildsPanel.$$$reportNull$$$0(1);
        }
        this.app = app;
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), REBUILD_STATS_TAB_LABEL));
        this.setPreferredSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        JPanel rebuildStatsPanel = new JPanel(new BorderLayout(0, 5));
        this.add(rebuildStatsPanel, "Center");
        this.perfSummaryContainer = new JPanel(new BorderLayout(0, 5));
        this.currentSummaryView = null;
        this.perfSummaryPlaceholder = new JPanel(new BorderLayout());
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)new JBLabel("<html><body style='padding-left:15px; padding-right:15px;'>Widget rebuild information tells you what widgets have been recently rebuilt for your application's current screen.<br></body></html>"), (int)20, (int)31);
        scrollPane.setBorder((Border)JBUI.Borders.empty());
        scrollPane.setViewportBorder((Border)JBUI.Borders.empty());
        this.perfSummaryPlaceholder.add(scrollPane);
        JPanel perfViewSettings = new JPanel((LayoutManager)new VerticalLayout(5, 4));
        this.trackRebuildsCheckbox = new JCheckBox("Track widget rebuilds");
        this.trackRebuildsCheckbox.setHorizontalAlignment(4);
        boolean bl = isInProfileMode = app.getMode().isProfiling() || app.getLaunchMode().isProfiling();
        if (isInProfileMode) {
            this.trackRebuildsCheckbox.setToolTipText("<html><body><p><b>This profiler identifies widgets that are rebuilt when the UI changes.</b></p><br><p>To enable 'Track widget rebuilds', start the app in debug mode.</p></body></html>");
        } else {
            this.trackRebuildsCheckbox.setToolTipText("<html><body><p><b>This profiler identifies widgets that are rebuilt when the UI changes.</b></p><br><p>Look for the indicators on the left margin of the code editor<br>and a list of the top rebuilt widgets in this window.</p></body></html>");
        }
        perfViewSettings.add(this.trackRebuildsCheckbox);
        perfViewSettings.add(new JSeparator());
        this.perfSummary = new WidgetPerfSummary(parentDisposable, app, PerfMetric.lastFrame, PerfReportKind.rebuild);
        this.perfSummaryContainer.add((Component)perfViewSettings, "North");
        this.updateShowPerfSummaryView();
        rebuildStatsPanel.add((Component)this.perfSummaryContainer, "Center");
        WidgetPerfTipsPanel perfTipsPanel = this.perfSummary.getWidgetPerfTipsPanel();
        rebuildStatsPanel.add((Component)perfTipsPanel, "South");
        perfTipsPanel.setVisible(false);
        FlutterWidgetPerfManager widgetPerfManager = FlutterWidgetPerfManager.getInstance(app.getProject());
        this.trackRebuildsCheckbox.setSelected(widgetPerfManager.isTrackRebuildWidgets());
        app.hasServiceExtension(ServiceExtensions.trackRebuildWidgets.getExtension(), this.trackRebuildsCheckbox::setEnabled, parentDisposable);
        this.trackRebuildsCheckbox.addChangeListener(l -> {
            if (app.getProject().isDisposed()) {
                return;
            }
            this.setTrackRebuildWidgets(this.trackRebuildsCheckbox.isSelected());
            this.updateShowPerfSummaryView();
        });
    }

    void updateShowPerfSummaryView() {
        JPanel summaryView;
        boolean show = this.getShowPerfTable();
        boolean firstRender = this.currentSummaryView == null;
        JPanel jPanel = summaryView = show ? this.perfSummary : this.perfSummaryPlaceholder;
        if (summaryView != this.currentSummaryView) {
            if (this.currentSummaryView != null) {
                this.perfSummaryContainer.remove(this.currentSummaryView);
            }
            this.currentSummaryView = summaryView;
            this.perfSummaryContainer.add((Component)summaryView, "Center");
            this.perfSummaryContainer.revalidate();
            this.perfSummaryContainer.repaint();
        }
        if (!show) {
            this.perfSummary.clearPerformanceTips();
        }
    }

    boolean getShowPerfTable() {
        FlutterWidgetPerfManager widgetPerfManager = FlutterWidgetPerfManager.getInstance(this.app.getProject());
        return widgetPerfManager.isTrackRebuildWidgets() || widgetPerfManager.isTrackRepaintWidgets();
    }

    private void setTrackRebuildWidgets(boolean selected) {
        FlutterWidgetPerfManager widgetPerfManager = FlutterWidgetPerfManager.getInstance(this.app.getProject());
        widgetPerfManager.setTrackRebuildWidgets(selected);
        FlutterWidgetPerfManager.trackRebuildWidgetsDefault = selected;
    }

    private void setTrackRepaintWidgets(boolean selected) {
        FlutterWidgetPerfManager widgetPerfManager = FlutterWidgetPerfManager.getInstance(this.app.getProject());
        widgetPerfManager.setTrackRepaintWidgets(selected);
        FlutterWidgetPerfManager.trackRepaintWidgetsDefault = selected;
    }

    private /* synthetic */ void lambda$new$1(FlutterApp app, ChangeEvent l) {
        if (app.getProject().isDisposed()) {
            return;
        }
        this.setTrackRepaintWidgets(this.trackRepaintsCheckbox.isSelected());
        this.updateShowPerfSummaryView();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "app";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "parentDisposable";
                break;
            }
        }
        objectArray[1] = "io/flutter/performance/PerfWidgetRebuildsPanel";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

