/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.performance;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.ScrollPaneFactory;
import io.flutter.inspector.WidgetPerfTipsPanel;
import io.flutter.perf.FlutterWidgetPerf;
import io.flutter.perf.FlutterWidgetPerfManager;
import io.flutter.perf.PerfMetric;
import io.flutter.perf.PerfReportKind;
import io.flutter.performance.WidgetPerfTable;
import io.flutter.run.daemon.FlutterApp;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.JPanel;
import javax.swing.Timer;

class WidgetPerfSummary
extends JPanel
implements Disposable {
    private static final int REFRESH_TABLE_DELAY = 100;
    private final FlutterWidgetPerfManager perfManager;
    private final Timer refreshTableTimer;
    private final WidgetPerfTable table;
    private final PerfReportKind reportKind;
    private final WidgetPerfTipsPanel myWidgetPerfTipsPanel;
    private long lastUpdateTime;

    WidgetPerfSummary(Disposable parentDisposable, FlutterApp app, PerfMetric metric, PerfReportKind reportKind) {
        this.setLayout(new BorderLayout());
        this.reportKind = reportKind;
        this.perfManager = FlutterWidgetPerfManager.getInstance(app.getProject());
        this.refreshTableTimer = new Timer(100, this::onUpdateTable);
        this.refreshTableTimer.start();
        this.table = new WidgetPerfTable(app, parentDisposable, metric);
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
        this.perfManager.addPerfListener(this.table);
        this.add((Component)ScrollPaneFactory.createScrollPane((Component)((Object)this.table), (boolean)true), "Center");
        this.myWidgetPerfTipsPanel = new WidgetPerfTipsPanel(parentDisposable, app);
    }

    public void dispose() {
        this.perfManager.removePerfListener(this.table);
        this.refreshTableTimer.stop();
    }

    public WidgetPerfTipsPanel getWidgetPerfTipsPanel() {
        return this.myWidgetPerfTipsPanel;
    }

    private void onUpdateTable(ActionEvent event) {
        long latestPerfUpdate;
        FlutterWidgetPerf stats = this.perfManager.getCurrentStats();
        if (stats != null && (latestPerfUpdate = stats.getLastLocalPerfEventTime()) != this.lastUpdateTime) {
            this.lastUpdateTime = latestPerfUpdate;
            this.table.showStats(stats.getStatsForMetric(this.table.getMetrics(), this.reportKind));
        }
    }

    public void clearPerformanceTips() {
        this.myWidgetPerfTipsPanel.clearTips();
    }
}

