/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.preview;

import com.intellij.ui.LayeredIcon;
import io.flutter.utils.CustomIconMaker;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.dartlang.analysis.server.protocol.Element;
import org.dartlang.analysis.server.protocol.FlutterOutline;
import org.dartlang.analysis.server.protocol.FlutterOutlineAttribute;
import org.jetbrains.annotations.NotNull;

class OutlineObject {
    private static final CustomIconMaker iconMaker = new CustomIconMaker();
    private static final Map<Icon, LayeredIcon> flutterDecoratedIcons = new HashMap<Icon, LayeredIcon>();
    final FlutterOutline outline;
    private Icon icon;

    OutlineObject(FlutterOutline outline) {
        this.outline = outline;
    }

    Icon getIcon() {
        if (this.outline.getKind().equals("DART_ELEMENT")) {
            return null;
        }
        if (this.icon == null) {
            String className = this.outline.getClassName();
            if (this.icon == null) {
                this.icon = iconMaker.fromWidgetName(className);
            }
        }
        return this.icon;
    }

    @NotNull
    String getSpeedSearchString() {
        List<FlutterOutlineAttribute> attributes;
        StringBuilder builder = new StringBuilder();
        Element dartElement = this.outline.getDartElement();
        if (dartElement != null) {
            builder.append(dartElement.getName());
        } else {
            builder.append(this.outline.getClassName());
        }
        if (this.outline.getVariableName() != null) {
            builder.append('|');
            builder.append(this.outline.getVariableName());
        }
        if ((attributes = this.outline.getAttributes()) != null) {
            for (FlutterOutlineAttribute attribute : attributes) {
                builder.append(attribute.getName());
                builder.append(':');
                builder.append(attribute.getLabel());
            }
        }
        String string = builder.toString();
        if (string == null) {
            OutlineObject.$$$reportNull$$$0(0);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "io/flutter/preview/OutlineObject", "getSpeedSearchString"));
    }
}

