/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.preview;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.lang.dart.analyzer.DartAnalysisServerService;
import org.dartlang.analysis.server.protocol.FlutterOutline;

public class OutlineOffsetConverter {
    private final VirtualFile currentFile;
    private final Project project;

    public OutlineOffsetConverter(Project project, VirtualFile currentFile) {
        this.project = project;
        this.currentFile = currentFile;
    }

    public int getConvertedFileOffset(int offset) {
        return DartAnalysisServerService.getInstance((Project)this.project).getConvertedOffset(this.currentFile, offset);
    }

    public int getConvertedOutlineOffset(FlutterOutline outline) {
        int offset = outline.getOffset();
        return this.getConvertedFileOffset(offset);
    }

    public int getConvertedOutlineEnd(FlutterOutline outline) {
        int end = outline.getOffset() + outline.getLength();
        return this.getConvertedFileOffset(end);
    }

    public FlutterOutline findOutlineAtOffset(FlutterOutline outline, int offset) {
        if (outline == null) {
            return null;
        }
        if (this.getConvertedOutlineOffset(outline) <= offset && offset <= this.getConvertedOutlineEnd(outline)) {
            if (outline.getChildren() != null) {
                for (FlutterOutline child : outline.getChildren()) {
                    FlutterOutline foundChild = this.findOutlineAtOffset(child, offset);
                    if (foundChild == null) continue;
                    return foundChild;
                }
            }
            return outline;
        }
        return null;
    }
}

