/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.preview;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import io.flutter.dart.FlutterDartAnalysisServer;
import io.flutter.editor.EditorPositionService;
import io.flutter.editor.PreviewViewController;
import io.flutter.editor.WidgetEditingContext;
import io.flutter.editor.WidgetViewModelData;
import io.flutter.inspector.InspectorGroupManagerService;
import io.flutter.inspector.InspectorService;
import io.flutter.preview.PreviewViewModelPanel;
import io.flutter.preview.TitleAction;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import org.dartlang.analysis.server.protocol.FlutterOutline;
import org.jetbrains.annotations.NotNull;

public class PreviewArea {
    public static int BORDER_WIDTH = 0;
    private final DefaultActionGroup toolbarGroup = new DefaultActionGroup();
    private final ActionToolbar windowToolbar;
    private final SimpleToolWindowPanel window;
    private final JLayeredPane layeredPanel = new JLayeredPane();
    private final JPanel deviceMirrorPanel;
    private final PreviewViewController preview;
    private final WidgetEditingContext context;
    private final Set<FlutterOutline> outlinesWithWidgets;
    private final InspectorGroupManagerService.Client inspectorClient;

    public PreviewArea(Project project, Set<FlutterOutline> outlinesWithWidgets, Disposable parent) {
        this.outlinesWithWidgets = outlinesWithWidgets;
        this.context = new WidgetEditingContext(project, FlutterDartAnalysisServer.getInstance(project), InspectorGroupManagerService.getInstance(project), EditorPositionService.getInstance(project));
        this.inspectorClient = new InspectorGroupManagerService.Client(parent);
        this.context.inspectorGroupManagerService.addListener(this.inspectorClient, parent);
        this.preview = new PreviewViewController(new WidgetViewModelData(this.context), false, this.layeredPanel, parent);
        this.deviceMirrorPanel = new PreviewViewModelPanel(this.preview);
        this.windowToolbar = ActionManager.getInstance().createActionToolbar("PreviewArea", (ActionGroup)this.toolbarGroup, true);
        this.toolbarGroup.add((AnAction)new TitleAction("Device Mirror"));
        this.window = new SimpleToolWindowPanel(true, true);
        this.window.setToolbar(this.windowToolbar.getComponent());
        this.deviceMirrorPanel.setLayout(new BorderLayout());
        this.window.setContent((JComponent)this.layeredPanel);
        this.layeredPanel.add((Component)this.deviceMirrorPanel, (Object)0);
        this.layeredPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                Dimension renderSize = PreviewArea.this.getRenderSize();
                PreviewArea.this.preview.setScreenshotBounds(new Rectangle(0, 0, renderSize.width, renderSize.height));
            }
        });
    }

    public JComponent getComponent() {
        return this.window;
    }

    public void select(@NotNull List<FlutterOutline> outlines, Editor editor) {
        if (outlines == null) {
            PreviewArea.$$$reportNull$$$0(0);
        }
        if (editor.isDisposed()) {
            return;
        }
        InspectorService.ObjectGroup group = this.getObjectGroup();
        if (group != null && !outlines.isEmpty()) {
            FlutterOutline outline = this.findWidgetToHighlight(outlines.get(0));
            if (outline == null) {
                return;
            }
            InspectorService.Location location = InspectorService.Location.outlineToLocation(editor, outline);
            if (location == null) {
                return;
            }
            group.setSelection(location, false, true);
        }
    }

    private FlutterOutline findWidgetToHighlight(FlutterOutline outline) {
        if (outline == null || outline.getClassName() != null) {
            return outline;
        }
        if (!this.outlinesWithWidgets.contains(outline)) {
            return null;
        }
        FlutterOutline candidate = null;
        for (FlutterOutline child : outline.getChildren()) {
            if (!this.outlinesWithWidgets.contains(child)) continue;
            if (candidate != null) {
                return null;
            }
            candidate = this.findWidgetToHighlight(child);
        }
        return candidate;
    }

    public Dimension getRenderSize() {
        int width = this.layeredPanel.getWidth();
        int height = this.layeredPanel.getHeight();
        for (Component child : this.layeredPanel.getComponents()) {
            child.setBounds(0, 0, width, height);
        }
        int renderWidth = width - 2 * BORDER_WIDTH;
        int renderHeight = height - 2 * BORDER_WIDTH;
        return new Dimension(renderWidth, renderHeight);
    }

    InspectorService.ObjectGroup getObjectGroup() {
        return this.inspectorClient.getCurrentObjectGroup();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outlines", "io/flutter/preview/PreviewArea", "select"));
    }
}

