/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.preview;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.icons.AllIcons;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.DefaultTreeExpander;
import com.intellij.ide.TreeExpander;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.RightAlignedToolbarAction;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.messages.MessageBusConnection;
import io.flutter.FlutterInitializer;
import io.flutter.FlutterUtils;
import io.flutter.dart.FlutterDartAnalysisServer;
import io.flutter.dart.FlutterOutlineListener;
import io.flutter.editor.PropertyEditorPanel;
import io.flutter.inspector.InspectorGroupManagerService;
import io.flutter.preview.OutlineComponent;
import io.flutter.preview.OutlineObject;
import io.flutter.preview.OutlineOffsetConverter;
import io.flutter.preview.OutlineTree;
import io.flutter.preview.OutlineTreeCellRenderer;
import io.flutter.preview.PreviewArea;
import io.flutter.preview.PreviewViewState;
import io.flutter.preview.TitleAction;
import io.flutter.preview.WidgetEditToolbar;
import io.flutter.settings.FlutterSettings;
import io.flutter.utils.EventStream;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.dartlang.analysis.server.protocol.Element;
import org.dartlang.analysis.server.protocol.FlutterOutline;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="FlutterPreviewView", storages={@Storage(value="$WORKSPACE_FILE$")})
public class PreviewView
implements PersistentStateComponent<PreviewViewState> {
    public static final String TOOL_WINDOW_ID = "Flutter Outline";
    @NotNull
    private final PreviewViewState state;
    @NotNull
    private final Project project;
    @NotNull
    private final FlutterDartAnalysisServer flutterAnalysisServer;
    private final InspectorGroupManagerService inspectorGroupManagerService;
    private SimpleToolWindowPanel windowPanel;
    private boolean isSettingSplitterProportion;
    private Splitter splitter;
    private Splitter propertyEditSplitter;
    private JScrollPane scrollPane;
    private OutlineTree tree;
    @Nullable
    private PreviewArea previewArea;
    private final Set<FlutterOutline> outlinesWithWidgets;
    private final Map<FlutterOutline, DefaultMutableTreeNode> outlineToNodeMap;
    private final EventStream<VirtualFile> currentFile;
    private String currentFilePath;
    FileEditor currentFileEditor;
    private Editor currentEditor;
    private FlutterOutline currentOutline;
    private final EventStream<List<FlutterOutline>> activeOutlines;
    private final WidgetEditToolbar widgetEditToolbar;
    private final FlutterOutlineListener outlineListener;
    private final CaretListener caretListener;
    private final TreeSelectionListener treeSelectionListener;
    private PropertyEditorPanel propertyEditPanel;
    private DefaultActionGroup propertyEditToolbarGroup;

    public PreviewView(@NotNull Project project) {
        FileEditor[] selectedEditors;
        if (project == null) {
            PreviewView.$$$reportNull$$$0(0);
        }
        this.state = new PreviewViewState();
        this.isSettingSplitterProportion = false;
        this.outlinesWithWidgets = Sets.newHashSet();
        this.outlineToNodeMap = Maps.newHashMap();
        this.outlineListener = new FlutterOutlineListener(){

            @Override
            public void outlineUpdated(@NotNull String filePath, @NotNull FlutterOutline outline, @Nullable String instrumentedCode) {
                if (filePath == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (outline == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (Objects.equals(PreviewView.this.currentFilePath, filePath)) {
                    ApplicationManager.getApplication().invokeLater(() -> PreviewView.this.updateOutline(outline));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "filePath";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "outline";
                        break;
                    }
                }
                objectArray[1] = "io/flutter/preview/PreviewView$1";
                objectArray[2] = "outlineUpdated";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        this.caretListener = new CaretListener(){

            public void caretPositionChanged(CaretEvent e) {
                Caret caret = e.getCaret();
                if (caret != null) {
                    ApplicationManager.getApplication().invokeLater(() -> PreviewView.this.applyEditorSelectionToTree(caret));
                }
            }

            public void caretAdded(@NotNull CaretEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
            }

            public void caretRemoved(@NotNull CaretEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(1);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "io/flutter/preview/PreviewView$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "caretAdded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "caretRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        this.treeSelectionListener = this::handleTreeSelectionEvent;
        this.project = project;
        this.currentFile = new EventStream();
        this.activeOutlines = new EventStream<ImmutableList>(ImmutableList.of());
        this.flutterAnalysisServer = FlutterDartAnalysisServer.getInstance(project);
        this.inspectorGroupManagerService = InspectorGroupManagerService.getInstance(project);
        VirtualFile[] selectedFiles = FileEditorManager.getInstance((Project)project).getSelectedFiles();
        if (selectedFiles.length != 0) {
            this.setSelectedFile(selectedFiles[0]);
        }
        if ((selectedEditors = FileEditorManager.getInstance((Project)project).getSelectedEditors()).length != 0) {
            this.setSelectedEditor(selectedEditors[0]);
        }
        MessageBusConnection bus = project.getMessageBus().connect((Disposable)project);
        bus.subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerListener(){

            public void selectionChanged(@NotNull FileEditorManagerEvent event) {
                if (event == null) {
                    3.$$$reportNull$$$0(0);
                }
                PreviewView.this.setSelectedFile(event.getNewFile());
                PreviewView.this.setSelectedEditor(event.getNewEditor());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "io/flutter/preview/PreviewView$3", "selectionChanged"));
            }
        });
        this.widgetEditToolbar = new WidgetEditToolbar(FlutterSettings.getInstance().isEnableHotUi(), this.activeOutlines, this.currentFile, project, this.flutterAnalysisServer);
    }

    @NotNull
    public PreviewViewState getState() {
        PreviewViewState previewViewState = this.state;
        if (previewViewState == null) {
            PreviewView.$$$reportNull$$$0(1);
        }
        return previewViewState;
    }

    public void loadState(@NotNull PreviewViewState state) {
        if (state == null) {
            PreviewView.$$$reportNull$$$0(2);
        }
        this.state.copyFrom(state);
    }

    public void initToolWindow(@NotNull ToolWindow toolWindow) {
        if (toolWindow == null) {
            PreviewView.$$$reportNull$$$0(3);
        }
        ContentFactory contentFactory = ContentFactory.getInstance();
        ContentManager contentManager = toolWindow.getContentManager();
        Content content = contentFactory.createContent(null, null, false);
        content.setCloseable(false);
        this.windowPanel = new OutlineComponent(this);
        content.setComponent((JComponent)this.windowPanel);
        this.windowPanel.setToolbar(this.widgetEditToolbar.getToolbar().getComponent());
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode();
        this.tree = new OutlineTree(rootNode);
        this.tree.setCellRenderer((TreeCellRenderer)((Object)new OutlineTreeCellRenderer()));
        this.tree.expandAll();
        this.initTreePopup();
        if (toolWindow instanceof ToolWindowEx) {
            ToolWindowEx toolWindowEx = (ToolWindowEx)toolWindow;
            CommonActionsManager actions = CommonActionsManager.getInstance();
            DefaultTreeExpander expander = new DefaultTreeExpander((JTree)((Object)this.tree));
            AnAction expandAllAction = actions.createExpandAllAction((TreeExpander)expander, (JComponent)((Object)this.tree));
            expandAllAction.getTemplatePresentation().setIcon(AllIcons.Actions.Expandall);
            AnAction collapseAllAction = actions.createCollapseAllAction((TreeExpander)expander, (JComponent)((Object)this.tree));
            collapseAllAction.getTemplatePresentation().setIcon(AllIcons.Actions.Collapseall);
            ShowOnlyWidgetsAction showOnlyWidgetsAction = new ShowOnlyWidgetsAction();
            toolWindowEx.setTitleActions(Arrays.asList(new AnAction[]{expandAllAction, collapseAllAction, showOnlyWidgetsAction}));
        }
        new TreeSpeedSearch((JTree)((Object)this.tree)){

            protected String getElementText(Object element) {
                TreePath path = (TreePath)element;
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                Object object = node.getUserObject();
                if (object instanceof OutlineObject) {
                    return ((OutlineObject)object).getSpeedSearchString();
                }
                return null;
            }
        };
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TreePath selectionPath;
                if (e.getClickCount() > 1 && (selectionPath = PreviewView.this.tree.getSelectionPath()) != null) {
                    PreviewView.this.selectPath(selectionPath, true);
                }
            }
        });
        this.tree.addTreeSelectionListener(this.treeSelectionListener);
        this.scrollPane = ScrollPaneFactory.createScrollPane((Component)((Object)this.tree));
        content.setPreferredFocusableComponent((JComponent)((Object)this.tree));
        contentManager.addContent(content);
        contentManager.setSelectedContent(content);
        this.splitter = new Splitter(true);
        this.setSplitterProportion(this.getState().getSplitterProportion());
        this.getState().addListener(e -> {
            float newProportion = this.getState().getSplitterProportion();
            if (this.splitter.getProportion() != newProportion) {
                this.setSplitterProportion(newProportion);
            }
        });
        this.splitter.addPropertyChangeListener("proportion", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (!PreviewView.this.isSettingSplitterProportion) {
                    PreviewView.this.getState().setSplitterProportion(PreviewView.this.splitter.getProportion());
                }
            }
        });
        this.scrollPane.setMinimumSize(new Dimension(1, 1));
        this.splitter.setFirstComponent((JComponent)this.scrollPane);
        this.windowPanel.setContent((JComponent)this.splitter);
    }

    private void initTreePopup() {
        this.tree.addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(Component comp, int x, int y) {
                List<FlutterOutline> selectedOutlines = PreviewView.this.getOutlinesSelectedInTree();
                if (selectedOutlines.isEmpty()) {
                    return;
                }
                for (FlutterOutline outline : selectedOutlines) {
                    if (outline.getDartElement() == null) continue;
                    return;
                }
                PreviewView.this.widgetEditToolbar.createPopupMenu(comp, x, y);
            }
        });
    }

    private OutlineOffsetConverter getOutlineOffsetConverter() {
        return new OutlineOffsetConverter(this.project, this.currentFile.getValue());
    }

    private void handleTreeSelectionEvent(TreeSelectionEvent e) {
        TreePath selectionPath = e.getNewLeadSelectionPath();
        if (selectionPath != null) {
            ApplicationManager.getApplication().invokeLater(() -> this.selectPath(selectionPath, false));
        }
        this.activeOutlines.setValue(this.getOutlinesSelectedInTree());
    }

    private void selectPath(TreePath selectionPath, boolean focusEditor) {
        FlutterOutline outline = this.getOutlineOfPath(selectionPath);
        this.jumpToOutlineInEditor(outline, focusEditor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jumpToOutlineInEditor(FlutterOutline outline, boolean focusEditor) {
        if (outline == null) {
            return;
        }
        int offset = outline.getDartElement() != null ? outline.getDartElement().getLocation().getOffset() : outline.getOffset();
        int editorOffset = this.getOutlineOffsetConverter().getConvertedFileOffset(offset);
        this.sendAnalyticEvent("jumpToSource");
        if (this.currentFile != null) {
            this.currentEditor.getCaretModel().removeCaretListener(this.caretListener);
            try {
                new OpenFileDescriptor(this.project, this.currentFile.getValue(), editorOffset).navigate(focusEditor);
            }
            finally {
                this.currentEditor.getCaretModel().addCaretListener(this.caretListener);
            }
        }
        if (this.previewArea != null) {
            this.previewArea.select((List<FlutterOutline>)ImmutableList.of((Object)outline), this.currentEditor);
        }
    }

    private Element getElementParentFor(@Nullable Element element) {
        if (element == null) {
            return null;
        }
        for (FlutterOutline outline : this.outlineToNodeMap.keySet()) {
            List<FlutterOutline> children = outline.getChildren();
            if (children == null) continue;
            for (FlutterOutline child : children) {
                if (child.getDartElement() != element) continue;
                return outline.getDartElement();
            }
        }
        return null;
    }

    private DefaultTreeModel getTreeModel() {
        return (DefaultTreeModel)this.tree.getModel();
    }

    private DefaultMutableTreeNode getRootNode() {
        return (DefaultMutableTreeNode)this.getTreeModel().getRoot();
    }

    private void updateOutline(@NotNull FlutterOutline outline) {
        if (outline == null) {
            PreviewView.$$$reportNull$$$0(4);
        }
        this.currentOutline = outline;
        DefaultMutableTreeNode rootNode = this.getRootNode();
        rootNode.removeAllChildren();
        this.outlinesWithWidgets.clear();
        this.outlineToNodeMap.clear();
        if (outline.getChildren() != null) {
            this.computeOutlinesWithWidgets(outline);
            this.updateOutlineImpl(rootNode, outline.getChildren());
        }
        this.getTreeModel().reload(rootNode);
        this.tree.expandAll();
        if (this.currentEditor != null) {
            Caret caret = this.currentEditor.getCaretModel().getPrimaryCaret();
            this.applyEditorSelectionToTree(caret);
        }
        if (FlutterSettings.getInstance().isEnableHotUi() && this.propertyEditPanel == null) {
            this.propertyEditSplitter = new Splitter(false, 0.75f);
            this.propertyEditPanel = new PropertyEditorPanel(this.inspectorGroupManagerService, this.project, this.flutterAnalysisServer, false, false, (Disposable)this.project);
            this.propertyEditPanel.initalize(null, this.activeOutlines, this.currentFile);
            this.propertyEditToolbarGroup = new DefaultActionGroup();
            ActionToolbar windowToolbar = ActionManager.getInstance().createActionToolbar("PropertyArea", (ActionGroup)this.propertyEditToolbarGroup, true);
            SimpleToolWindowPanel window = new SimpleToolWindowPanel(true, true);
            window.setToolbar(windowToolbar.getComponent());
            JScrollPane propertyScrollPane = ScrollPaneFactory.createScrollPane((Component)((Object)this.propertyEditPanel));
            window.setContent((JComponent)propertyScrollPane);
            this.propertyEditSplitter.setFirstComponent(window.getComponent());
            InspectorGroupManagerService.Client inspectorStateServiceClient = new InspectorGroupManagerService.Client((Disposable)this.project){

                @Override
                public void onInspectorAvailabilityChanged() {
                    super.onInspectorAvailabilityChanged();
                    if (this.getInspectorService() != null && this.getInspectorService().isHotUiScreenMirrorSupported()) {
                        if (PreviewView.this.previewArea == null) {
                            PreviewView.this.previewArea = new PreviewArea(PreviewView.this.project, PreviewView.this.outlinesWithWidgets, (Disposable)PreviewView.this.project);
                        }
                        PreviewView.this.propertyEditSplitter.setSecondComponent(PreviewView.this.previewArea.getComponent());
                    } else {
                        PreviewView.this.propertyEditSplitter.setSecondComponent(null);
                    }
                }
            };
            this.inspectorGroupManagerService.addListener(inspectorStateServiceClient, (Disposable)this.project);
            this.splitter.setSecondComponent((JComponent)this.propertyEditSplitter);
        }
        if (this.propertyEditToolbarGroup != null) {
            TitleAction propertyTitleAction = new TitleAction("Properties");
            this.propertyEditToolbarGroup.removeAll();
            this.propertyEditToolbarGroup.add((AnAction)propertyTitleAction);
        }
    }

    private boolean computeOutlinesWithWidgets(FlutterOutline outline) {
        List<FlutterOutline> children;
        boolean hasWidget = false;
        if (outline.getDartElement() == null) {
            this.outlinesWithWidgets.add(outline);
            hasWidget = true;
        }
        if ((children = outline.getChildren()) != null) {
            for (FlutterOutline child : children) {
                if (!this.computeOutlinesWithWidgets(child)) continue;
                this.outlinesWithWidgets.add(outline);
                hasWidget = true;
            }
        }
        return hasWidget;
    }

    private void updateOutlineImpl(@NotNull DefaultMutableTreeNode parent, @NotNull List<FlutterOutline> outlines) {
        if (parent == null) {
            PreviewView.$$$reportNull$$$0(5);
        }
        if (outlines == null) {
            PreviewView.$$$reportNull$$$0(6);
        }
        int index = 0;
        for (FlutterOutline outline : outlines) {
            if (FlutterSettings.getInstance().isShowOnlyWidgets() && !this.outlinesWithWidgets.contains(outline)) continue;
            OutlineObject object = new OutlineObject(outline);
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(object);
            this.outlineToNodeMap.put(outline, node);
            this.getTreeModel().insertNodeInto(node, parent, index++);
            if (outline.getChildren() == null) continue;
            this.updateOutlineImpl(node, outline.getChildren());
        }
    }

    @NotNull
    private List<FlutterOutline> getOutlinesSelectedInTree() {
        DefaultMutableTreeNode[] selectedNodes;
        ArrayList<FlutterOutline> selectedOutlines = new ArrayList<FlutterOutline>();
        for (DefaultMutableTreeNode selectedNode : selectedNodes = (DefaultMutableTreeNode[])this.tree.getSelectedNodes(DefaultMutableTreeNode.class, null)) {
            FlutterOutline outline = PreviewView.getOutlineOfNode(selectedNode);
            selectedOutlines.add(outline);
        }
        ArrayList<FlutterOutline> arrayList = selectedOutlines;
        if (arrayList == null) {
            PreviewView.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    private static FlutterOutline getOutlineOfNode(DefaultMutableTreeNode node) {
        OutlineObject object = (OutlineObject)node.getUserObject();
        return object.outline;
    }

    @Nullable
    private FlutterOutline getOutlineOfPath(@Nullable TreePath path) {
        if (path == null) {
            return null;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        return PreviewView.getOutlineOfNode(node);
    }

    private void addOutlinesCoveredByRange(List<FlutterOutline> covered, int start, int end, @Nullable FlutterOutline outline) {
        if (outline == null) {
            return;
        }
        OutlineOffsetConverter converter = this.getOutlineOffsetConverter();
        int outlineStart = converter.getConvertedOutlineOffset(outline);
        int outlineEnd = converter.getConvertedOutlineEnd(outline);
        if (outlineEnd < start || outlineStart > end) {
            return;
        }
        if (outlineStart >= start && outlineEnd <= end) {
            covered.add(outline);
            return;
        }
        if (outlineStart <= start && end <= outlineEnd && outline.getChildren() != null) {
            for (FlutterOutline child : outline.getChildren()) {
                this.addOutlinesCoveredByRange(covered, start, end, child);
            }
        }
    }

    private void setSelectedFile(VirtualFile newFile) {
        if (this.currentFile.getValue() != null) {
            this.flutterAnalysisServer.removeOutlineListener(this.currentFilePath, this.outlineListener);
            this.currentFile.setValue(null);
            this.currentFilePath = null;
        }
        if (newFile != null && !FlutterUtils.isDartFile(newFile)) {
            newFile = null;
        }
        if (this.windowPanel != null) {
            if (newFile != null) {
                this.windowPanel.setToolbar(this.widgetEditToolbar.getToolbar().getComponent());
            } else if (this.windowPanel.isToolbarVisible()) {
                this.windowPanel.setToolbar(null);
            }
        }
        if (this.tree != null) {
            DefaultMutableTreeNode rootNode = this.getRootNode();
            rootNode.removeAllChildren();
            this.getTreeModel().reload(rootNode);
        }
        if (newFile != null) {
            this.currentFile.setValue(newFile);
            this.currentFilePath = FileUtil.toSystemDependentName((String)newFile.getPath());
            this.flutterAnalysisServer.addOutlineListener(this.currentFilePath, this.outlineListener);
        }
    }

    private void setSelectedEditor(FileEditor newEditor) {
        if (this.currentEditor != null) {
            this.currentEditor.getCaretModel().removeCaretListener(this.caretListener);
        }
        if (newEditor instanceof TextEditor) {
            this.currentFileEditor = newEditor;
            this.currentEditor = ((TextEditor)newEditor).getEditor();
            this.currentEditor.getCaretModel().addCaretListener(this.caretListener);
        }
    }

    private void applyEditorSelectionToTree(Caret caret) {
        FlutterOutline outline;
        ArrayList<FlutterOutline> selectedOutlines = new ArrayList<FlutterOutline>();
        this.addOutlinesCoveredByRange(selectedOutlines, caret.getSelectionStart(), caret.getSelectionEnd(), this.currentOutline);
        if (selectedOutlines.isEmpty() && (outline = this.getOutlineOffsetConverter().findOutlineAtOffset(this.currentOutline, caret.getOffset())) != null) {
            selectedOutlines.add(outline);
        }
        this.activeOutlines.setValue(selectedOutlines);
        this.applyOutlinesSelectionToTree(selectedOutlines);
        if (this.previewArea != null) {
            this.previewArea.select(selectedOutlines, this.currentEditor);
        }
    }

    private void applyOutlinesSelectionToTree(List<FlutterOutline> outlines) {
        ArrayList<TreePath> selectedPaths = new ArrayList<TreePath>();
        Object[] lastNodePath = null;
        TreePath lastTreePath = null;
        for (FlutterOutline outline : outlines) {
            DefaultMutableTreeNode selectedNode = this.outlineToNodeMap.get(outline);
            if (selectedNode == null) continue;
            lastNodePath = selectedNode.getPath();
            lastTreePath = new TreePath(lastNodePath);
            selectedPaths.add(lastTreePath);
        }
        if (lastNodePath != null) {
            this.tree.scrollPathToVisible(lastTreePath);
            if (lastNodePath.length >= 2) {
                this.scrollTreeToNodeOnTop((TreeNode)lastNodePath[1]);
            }
            this.tree.scrollPathToVisible(lastTreePath);
        }
        this.tree.removeTreeSelectionListener(this.treeSelectionListener);
        this.tree.setSelectionPaths(selectedPaths.toArray(new TreePath[0]));
        this.tree.addTreeSelectionListener(this.treeSelectionListener);
        this.scrollPane.getHorizontalScrollBar().setValue(0);
    }

    private void scrollTreeToNodeOnTop(TreeNode node) {
        DefaultMutableTreeNode defaultNode;
        Rectangle bounds;
        if (node instanceof DefaultMutableTreeNode && (bounds = this.tree.getPathBounds(new TreePath((defaultNode = (DefaultMutableTreeNode)node).getPath()))) != null) {
            bounds.height = this.tree.getVisibleRect().height;
            this.tree.scrollRectToVisible(bounds);
        }
    }

    private void setSplitterProportion(float value) {
        this.isSettingSplitterProportion = true;
        try {
            this.splitter.setProportion(value);
        }
        finally {
            this.isSettingSplitterProportion = false;
        }
        PreviewView.doLayoutRecursively((Component)this.splitter);
    }

    private static void doLayoutRecursively(Component component) {
        if (component != null) {
            component.doLayout();
            if (component instanceof Container) {
                Container container = (Container)component;
                for (Component child : container.getComponents()) {
                    PreviewView.doLayoutRecursively(child);
                }
            }
        }
    }

    private void sendAnalyticEvent(@NotNull String name) {
        if (name == null) {
            PreviewView.$$$reportNull$$$0(8);
        }
        FlutterInitializer.getAnalytics().sendEvent("preview", name);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/preview/PreviewView";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindow";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outline";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outlines";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/preview/PreviewView";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutlinesSelectedInTree";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 7: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "initToolWindow";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "updateOutline";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "updateOutlineImpl";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "sendAnalyticEvent";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 7 -> new IllegalStateException(string);
        };
    }

    private class ShowOnlyWidgetsAction
    extends AnAction
    implements Toggleable,
    RightAlignedToolbarAction {
        ShowOnlyWidgetsAction() {
            super("Show Only Widgets", "Show only widgets", AllIcons.General.Filter);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            FlutterSettings flutterSettings;
            if (e == null) {
                ShowOnlyWidgetsAction.$$$reportNull$$$0(0);
            }
            flutterSettings.setShowOnlyWidgets(!(flutterSettings = FlutterSettings.getInstance()).isShowOnlyWidgets());
            if (PreviewView.this.currentOutline != null) {
                PreviewView.this.updateOutline(PreviewView.this.currentOutline);
            }
        }

        public void update(AnActionEvent e) {
            Presentation presentation = e.getPresentation();
            presentation.putClientProperty("selected", (Object)FlutterSettings.getInstance().isShowOnlyWidgets());
            presentation.setEnabled(PreviewView.this.currentOutline != null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "io/flutter/preview/PreviewView$ShowOnlyWidgetsAction", "actionPerformed"));
        }
    }
}

