/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.preview;

import com.google.common.util.concurrent.Uninterruptibles;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.lang.dart.assists.AssistUtils;
import com.jetbrains.lang.dart.assists.DartSourceEditException;
import icons.FlutterIcons;
import io.flutter.FlutterInitializer;
import io.flutter.FlutterMessages;
import io.flutter.dart.FlutterDartAnalysisServer;
import io.flutter.inspector.InspectorGroupManagerService;
import io.flutter.inspector.InspectorService;
import io.flutter.preview.OutlineOffsetConverter;
import io.flutter.preview.TextOnlyActionWrapper;
import io.flutter.run.FlutterReloadManager;
import io.flutter.run.daemon.FlutterApp;
import io.flutter.utils.EventStream;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.dartlang.analysis.server.protocol.FlutterOutline;
import org.dartlang.analysis.server.protocol.SourceChange;
import org.jetbrains.annotations.NotNull;

public class WidgetEditToolbar {
    final QuickAssistAction actionCenter;
    final QuickAssistAction actionPadding;
    final QuickAssistAction actionColumn;
    final QuickAssistAction actionRow;
    final QuickAssistAction actionContainer;
    final QuickAssistAction actionMoveUp;
    final QuickAssistAction actionMoveDown;
    final QuickAssistAction actionRemove;
    final ExtractMethodAction actionExtractMethod;
    final ExtractWidgetAction actionExtractWidget;
    private final FlutterDartAnalysisServer flutterAnalysisServer;
    private final EventStream<VirtualFile> activeFile;
    private final Map<String, AnAction> messageToActionMap = new HashMap<String, AnAction>();
    private final Map<AnAction, SourceChange> actionToChangeMap = new HashMap<AnAction, SourceChange>();
    private final Project project;
    private final boolean hotReloadOnAction;
    EventStream<List<FlutterOutline>> activeOutlines;
    private ActionToolbar toolbar;

    public WidgetEditToolbar(boolean hotReloadOnAction, EventStream<List<FlutterOutline>> activeOutlines, EventStream<VirtualFile> activeFile, Project project, FlutterDartAnalysisServer flutterAnalysisServer) {
        this.hotReloadOnAction = hotReloadOnAction;
        this.project = project;
        this.flutterAnalysisServer = flutterAnalysisServer;
        this.activeFile = activeFile;
        this.actionCenter = new QuickAssistAction("dart.assist.flutter.wrap.center", FlutterIcons.Center, "Wrap with Center");
        this.actionPadding = new QuickAssistAction("dart.assist.flutter.wrap.padding", FlutterIcons.Padding, "Wrap with Padding");
        this.actionColumn = new QuickAssistAction("dart.assist.flutter.wrap.column", FlutterIcons.Column, "Wrap with Column");
        this.actionRow = new QuickAssistAction("dart.assist.flutter.wrap.row", FlutterIcons.Row, "Wrap with Row");
        this.actionContainer = new QuickAssistAction("dart.assist.flutter.wrap.container", FlutterIcons.Container, "Wrap with Container");
        this.actionMoveUp = new QuickAssistAction("dart.assist.flutter.move.up", FlutterIcons.Up, "Move widget up");
        this.actionMoveDown = new QuickAssistAction("dart.assist.flutter.move.down", FlutterIcons.Down, "Move widget down");
        this.actionRemove = new QuickAssistAction("dart.assist.flutter.removeWidget", FlutterIcons.RemoveWidget, "Remove this widget");
        this.actionExtractMethod = new ExtractMethodAction();
        this.actionExtractWidget = new ExtractWidgetAction();
        this.activeOutlines = activeOutlines;
        activeOutlines.listen(this::activeOutlineChanged);
    }

    Editor getCurrentEditor() {
        TextEditor textEditor;
        Editor editor;
        VirtualFile file = this.activeFile.getValue();
        if (file == null) {
            return null;
        }
        FileEditor fileEditor = FileEditorManager.getInstance((Project)this.project).getSelectedEditor(file);
        if (fileEditor instanceof TextEditor && !(editor = (textEditor = (TextEditor)fileEditor).getEditor()).isDisposed()) {
            return editor;
        }
        return null;
    }

    public ActionToolbar getToolbar() {
        if (this.toolbar == null) {
            DefaultActionGroup toolbarGroup = new DefaultActionGroup();
            toolbarGroup.add((AnAction)this.actionCenter);
            toolbarGroup.add((AnAction)this.actionPadding);
            toolbarGroup.add((AnAction)this.actionColumn);
            toolbarGroup.add((AnAction)this.actionRow);
            toolbarGroup.add((AnAction)this.actionContainer);
            toolbarGroup.addSeparator();
            toolbarGroup.add((AnAction)this.actionExtractMethod);
            toolbarGroup.addSeparator();
            toolbarGroup.add((AnAction)this.actionMoveUp);
            toolbarGroup.add((AnAction)this.actionMoveDown);
            toolbarGroup.addSeparator();
            toolbarGroup.add((AnAction)this.actionRemove);
            this.toolbar = ActionManager.getInstance().createActionToolbar("PreviewViewToolbar", (ActionGroup)toolbarGroup, true);
        }
        return this.toolbar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void activeOutlineChanged(List<FlutterOutline> outlines) {
        Map<AnAction, SourceChange> map = this.actionToChangeMap;
        synchronized (map) {
            this.actionToChangeMap.clear();
        }
        VirtualFile selectionFile = this.activeFile.getValue();
        if (selectionFile != null && !outlines.isEmpty()) {
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                OutlineOffsetConverter converter = new OutlineOffsetConverter(this.project, this.activeFile.getValue());
                FlutterOutline firstOutline = (FlutterOutline)outlines.get(0);
                FlutterOutline lastOutline = (FlutterOutline)outlines.get(outlines.size() - 1);
                int offset = converter.getConvertedOutlineOffset(firstOutline);
                int length = converter.getConvertedOutlineEnd(lastOutline) - offset;
                List<SourceChange> changes = this.flutterAnalysisServer.edit_getAssists(selectionFile, offset, length);
                List<FlutterOutline> newOutlines = this.activeOutlines.getValue();
                if (!Objects.equals(this.activeFile.getValue(), selectionFile) || !outlines.equals(newOutlines)) {
                    return;
                }
                for (SourceChange change : changes) {
                    AnAction action = this.messageToActionMap.get(change.getMessage());
                    if (action == null) continue;
                    this.actionToChangeMap.put(action, change);
                }
                if (this.getToolbar() != null) {
                    ApplicationManager.getApplication().invokeLater(() -> this.getToolbar().updateActionsImmediately());
                }
            });
        }
    }

    FlutterOutline getWidgetOutline() {
        FlutterOutline outline;
        List<FlutterOutline> outlines = this.activeOutlines.getValue();
        if (outlines.size() == 1 && (outline = outlines.get(0)).getDartElement() == null) {
            return outline;
        }
        return null;
    }

    private void sendAnalyticEvent(@NotNull String name) {
        if (name == null) {
            WidgetEditToolbar.$$$reportNull$$$0(0);
        }
        FlutterInitializer.getAnalytics().sendEvent("preview", name);
    }

    private void applyChangeAndShowException(SourceChange change) {
        ApplicationManager.getApplication().runWriteAction(() -> {
            try {
                InspectorService inspectorService;
                AssistUtils.applySourceChange((Project)this.project, (SourceChange)change, (boolean)false);
                if (this.hotReloadOnAction && (inspectorService = InspectorGroupManagerService.getInstance(this.project).getInspectorService()) != null) {
                    ArrayList<FlutterApp> apps = new ArrayList<FlutterApp>();
                    apps.add(inspectorService.getApp());
                    FlutterReloadManager.getInstance(this.project).saveAllAndReloadAll(apps, "Refactor widget");
                }
            }
            catch (DartSourceEditException exception) {
                FlutterMessages.showError("Error applying change", exception.getMessage(), this.project);
            }
        });
    }

    public void createPopupMenu(Component comp, int x, int y) {
        for (int i = 0; i < 20 && this.actionToChangeMap.isEmpty(); ++i) {
            Uninterruptibles.sleepUninterruptibly((long)5L, (TimeUnit)TimeUnit.MILLISECONDS);
        }
        DefaultActionGroup group = new DefaultActionGroup();
        boolean hasAction = false;
        if (this.actionCenter.isEnabled()) {
            hasAction = true;
            group.add((AnAction)new TextOnlyActionWrapper(this.actionCenter));
        }
        if (this.actionPadding.isEnabled()) {
            hasAction = true;
            group.add((AnAction)new TextOnlyActionWrapper(this.actionPadding));
        }
        if (this.actionColumn.isEnabled()) {
            hasAction = true;
            group.add((AnAction)new TextOnlyActionWrapper(this.actionColumn));
        }
        if (this.actionRow.isEnabled()) {
            hasAction = true;
            group.add((AnAction)new TextOnlyActionWrapper(this.actionRow));
        }
        if (this.actionContainer.isEnabled()) {
            hasAction = true;
            group.add((AnAction)new TextOnlyActionWrapper(this.actionContainer));
        }
        group.addSeparator();
        if (this.actionExtractMethod.isEnabled()) {
            hasAction = true;
            group.add((AnAction)new TextOnlyActionWrapper(this.actionExtractMethod));
        }
        if (this.actionExtractWidget.isEnabled()) {
            hasAction = true;
            group.add((AnAction)new TextOnlyActionWrapper(this.actionExtractWidget));
        }
        group.addSeparator();
        if (this.actionMoveUp.isEnabled()) {
            hasAction = true;
            group.add((AnAction)new TextOnlyActionWrapper(this.actionMoveUp));
        }
        if (this.actionMoveDown.isEnabled()) {
            hasAction = true;
            group.add((AnAction)new TextOnlyActionWrapper(this.actionMoveDown));
        }
        group.addSeparator();
        if (this.actionRemove.isEnabled()) {
            hasAction = true;
            group.add((AnAction)new TextOnlyActionWrapper(this.actionRemove));
        }
        if (!hasAction) {
            return;
        }
        ActionManager actionManager = ActionManager.getInstance();
        ActionPopupMenu popupMenu = actionManager.createActionPopupMenu("unknown", (ActionGroup)group);
        popupMenu.getComponent().show(comp, x, y);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "io/flutter/preview/WidgetEditToolbar", "sendAnalyticEvent"));
    }

    private class QuickAssistAction
    extends AnAction {
        private final String id;

        QuickAssistAction(String id, Icon icon, String assistMessage) {
            if (id == null) {
                QuickAssistAction.$$$reportNull$$$0(0);
            }
            super(assistMessage, null, icon);
            this.id = id;
            WidgetEditToolbar.this.messageToActionMap.put(assistMessage, this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(@NotNull AnActionEvent e) {
            SourceChange change;
            if (e == null) {
                QuickAssistAction.$$$reportNull$$$0(1);
            }
            WidgetEditToolbar.this.sendAnalyticEvent(this.id);
            Map<AnAction, SourceChange> map = WidgetEditToolbar.this.actionToChangeMap;
            synchronized (map) {
                change = WidgetEditToolbar.this.actionToChangeMap.get((Object)this);
                WidgetEditToolbar.this.actionToChangeMap.clear();
            }
            if (change != null) {
                WidgetEditToolbar.this.applyChangeAndShowException(change);
            }
        }

        public void update(AnActionEvent e) {
            boolean hasChange = WidgetEditToolbar.this.actionToChangeMap.containsKey((Object)this);
            e.getPresentation().setEnabled(hasChange);
        }

        boolean isEnabled() {
            return WidgetEditToolbar.this.actionToChangeMap.containsKey((Object)this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "id";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "io/flutter/preview/WidgetEditToolbar$QuickAssistAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class ExtractMethodAction
    extends AnAction {
        private final String id = "dart.assist.flutter.extractMethod";

        ExtractMethodAction() {
            super("Extract Method...", null, FlutterIcons.ExtractMethod);
            this.id = "dart.assist.flutter.extractMethod";
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            FlutterOutline outline;
            AnAction action;
            if (e == null) {
                ExtractMethodAction.$$$reportNull$$$0(0);
            }
            if ((action = ActionManager.getInstance().getAction("ExtractMethod")) != null && (outline = WidgetEditToolbar.this.getWidgetOutline()) != null) {
                TransactionGuard.submitTransaction((Disposable)WidgetEditToolbar.this.project, () -> {
                    Editor editor = WidgetEditToolbar.this.getCurrentEditor();
                    if (editor == null) {
                        return;
                    }
                    OutlineOffsetConverter converter = new OutlineOffsetConverter(WidgetEditToolbar.this.project, WidgetEditToolbar.this.activeFile.getValue());
                    int offset = converter.getConvertedOutlineOffset(outline);
                    editor.getCaretModel().moveToOffset(offset);
                    JComponent editorComponent = editor.getComponent();
                    DataContext editorContext = DataManager.getInstance().getDataContext((Component)editorComponent);
                    AnActionEvent editorEvent = AnActionEvent.createFromDataContext((String)"unknown", null, (DataContext)editorContext);
                    action.actionPerformed(editorEvent);
                });
            }
        }

        public void update(AnActionEvent e) {
            boolean isEnabled = this.isEnabled();
            e.getPresentation().setEnabled(isEnabled);
        }

        boolean isEnabled() {
            return WidgetEditToolbar.this.getWidgetOutline() != null && WidgetEditToolbar.this.getCurrentEditor() != null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "io/flutter/preview/WidgetEditToolbar$ExtractMethodAction", "actionPerformed"));
        }
    }

    private class ExtractWidgetAction
    extends AnAction {
        private final String id = "dart.assist.flutter.extractwidget";

        ExtractWidgetAction() {
            super("Extract Widget...");
            this.id = "dart.assist.flutter.extractwidget";
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            AnAction action;
            if (e == null) {
                ExtractWidgetAction.$$$reportNull$$$0(0);
            }
            if ((action = ActionManager.getInstance().getAction("Flutter.ExtractWidget")) != null) {
                TransactionGuard.submitTransaction((Disposable)WidgetEditToolbar.this.project, () -> {
                    Editor editor = WidgetEditToolbar.this.getCurrentEditor();
                    if (editor == null) {
                        return;
                    }
                    JComponent editorComponent = editor.getComponent();
                    DataContext editorContext = DataManager.getInstance().getDataContext((Component)editorComponent);
                    AnActionEvent editorEvent = AnActionEvent.createFromDataContext((String)"unknown", null, (DataContext)editorContext);
                    action.actionPerformed(editorEvent);
                });
            }
        }

        public void update(AnActionEvent e) {
            boolean isEnabled = this.isEnabled();
            e.getPresentation().setEnabled(isEnabled);
        }

        boolean isEnabled() {
            return WidgetEditToolbar.this.getWidgetOutline() != null && WidgetEditToolbar.this.getCurrentEditor() != null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "io/flutter/preview/WidgetEditToolbar$ExtractWidgetAction", "actionPerformed"));
        }
    }
}

