/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.project;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IconProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.ui.LayeredIcon;
import com.jetbrains.lang.dart.DartFileType;
import com.jetbrains.lang.dart.psi.DartFile;
import icons.FlutterIcons;
import io.flutter.FlutterUtils;
import io.flutter.pub.PubRoot;
import io.flutter.pub.PubRootCache;
import io.flutter.utils.FlutterModuleUtils;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlutterIconProvider
extends IconProvider {
    private static final Icon TEST_FILE = FlutterIconProvider.overlayIcons(DartFileType.INSTANCE.getIcon(), AllIcons.Nodes.JunitTestMark);

    @Nullable
    public Icon getIcon(@NotNull PsiElement element, @Iconable.IconFlags int flags) {
        Project project;
        if (element == null) {
            FlutterIconProvider.$$$reportNull$$$0(0);
        }
        if (!FlutterModuleUtils.declaresFlutter(project = element.getProject())) {
            return null;
        }
        if (element instanceof PsiDirectory) {
            VirtualFile dir = ((PsiDirectory)element).getVirtualFile();
            if (!dir.isInLocalFileSystem()) {
                return null;
            }
            PubRootCache pubRootCache = PubRootCache.getInstance(project);
            PubRoot pubRoot = pubRootCache.getRoot(dir);
            if (pubRoot != null && dir.equals(pubRoot.getRoot()) && pubRoot.declaresFlutter()) {
                return FlutterIcons.Flutter;
            }
            PubRoot root = pubRootCache.getRoot(dir.getParent());
            if (root == null) {
                return null;
            }
            if (dir.equals(root.getLib())) {
                return AllIcons.Modules.SourceRoot;
            }
            if (Objects.equals(dir, root.getAndroidDir())) {
                return AllIcons.Nodes.KeymapTools;
            }
            if (Objects.equals(dir, root.getiOsDir())) {
                return AllIcons.Nodes.KeymapTools;
            }
            if (Objects.equals(dir, root.getIntegrationTestDir())) {
                return AllIcons.Nodes.TestSourceFolder;
            }
            if (dir.isDirectory() && dir.getName().equals(".idea")) {
                return AllIcons.Modules.GeneratedFolder;
            }
        }
        if (element instanceof DartFile) {
            DartFile dartFile = (DartFile)element;
            VirtualFile file = dartFile.getVirtualFile();
            if (file == null || !file.isInLocalFileSystem()) {
                return null;
            }
            if (FlutterUtils.isInTestDir(dartFile) && file.getName().endsWith("_test.dart")) {
                return TEST_FILE;
            }
        }
        return null;
    }

    @NotNull
    private static Icon overlayIcons(Icon ... icons) {
        if (icons == null) {
            FlutterIconProvider.$$$reportNull$$$0(1);
        }
        LayeredIcon result = new LayeredIcon(icons.length);
        for (int layer = 0; layer < icons.length; ++layer) {
            result.setIcon(icons[layer], layer);
        }
        LayeredIcon layeredIcon = result;
        if (layeredIcon == null) {
            FlutterIconProvider.$$$reportNull$$$0(2);
        }
        return layeredIcon;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icons";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/project/FlutterIconProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/project/FlutterIconProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "overlayIcons";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getIcon";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "overlayIcons";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

