/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.project;

import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.projectImport.ProjectOpenProcessor;
import icons.FlutterIcons;
import io.flutter.FlutterBundle;
import io.flutter.FlutterUtils;
import io.flutter.pub.PubRoot;
import io.flutter.utils.FlutterModuleUtils;
import java.util.Arrays;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlutterProjectOpenProcessor
extends ProjectOpenProcessor {
    private static final Logger LOG = Logger.getInstance(FlutterProjectOpenProcessor.class);

    @NotNull
    public String getName() {
        String string = FlutterBundle.message("flutter.module.name", new Object[0]);
        if (string == null) {
            FlutterProjectOpenProcessor.$$$reportNull$$$0(0);
        }
        return string;
    }

    public Icon getIcon() {
        return FlutterIcons.Flutter;
    }

    public boolean canOpenProject(@Nullable VirtualFile file) {
        if (file == null) {
            return false;
        }
        ApplicationInfo info = ApplicationInfo.getInstance();
        if (FlutterUtils.isAndroidStudio()) {
            return false;
        }
        PubRoot root = PubRoot.forDirectory(file);
        return root != null && root.declaresFlutter();
    }

    @Nullable
    public Project doOpenProject(@NotNull VirtualFile file, @Nullable Project projectToClose, boolean forceOpenInNewFrame) {
        ProjectOpenProcessor importProvider;
        if (file == null) {
            FlutterProjectOpenProcessor.$$$reportNull$$$0(1);
        }
        if ((importProvider = this.getDelegateImportProvider(file)) == null) {
            return null;
        }
        Project project = importProvider.doOpenProject(file, projectToClose, forceOpenInNewFrame);
        if (project == null || project.isDisposed()) {
            return project;
        }
        FlutterProjectOpenProcessor.convertToFlutterProject(project);
        return project;
    }

    @Nullable
    protected ProjectOpenProcessor getDelegateImportProvider(@NotNull VirtualFile file) {
        if (file == null) {
            FlutterProjectOpenProcessor.$$$reportNull$$$0(2);
        }
        return Arrays.stream((ProjectOpenProcessor[])Extensions.getExtensions((ExtensionPointName)EXTENSION_POINT_NAME)).filter(processor -> processor.canOpenProject(file) && !Objects.equals(processor.getName(), this.getName())).findFirst().orElse(null);
    }

    private static void convertToFlutterProject(@NotNull Project project) {
        if (project == null) {
            FlutterProjectOpenProcessor.$$$reportNull$$$0(3);
        }
        for (Module module : FlutterModuleUtils.getModules(project)) {
            if (!FlutterModuleUtils.declaresFlutter(module) || FlutterModuleUtils.isFlutterModule(module)) continue;
            FlutterModuleUtils.setFlutterModuleAndReload(module, project);
        }
    }

    public boolean isStrongProjectInfoHolder() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/project/FlutterProjectOpenProcessor";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/project/FlutterProjectOpenProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "doOpenProject";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getDelegateImportProvider";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "convertToFlutterProject";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3 -> new IllegalArgumentException(string);
        };
    }
}

