/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.project;

import com.intellij.ide.util.importProject.ModuleDescriptor;
import com.intellij.ide.util.importProject.ProjectDescriptor;
import com.intellij.ide.util.projectWizard.importSources.DetectedProjectRoot;
import com.intellij.ide.util.projectWizard.importSources.ProjectFromSourcesBuilder;
import com.intellij.ide.util.projectWizard.importSources.ProjectStructureDetector;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.messages.MessageBusConnection;
import io.flutter.module.FlutterModuleBuilder;
import io.flutter.pub.PubRoot;
import io.flutter.utils.FlutterModuleUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class FlutterProjectStructureDetector
extends ProjectStructureDetector {
    private static final Logger LOG = Logger.getInstance(ProjectStructureDetector.class);

    @NotNull
    public ProjectStructureDetector.DirectoryProcessingResult detectRoots(@NotNull File parent, @NotNull File[] children, @NotNull File base, @NotNull List<DetectedProjectRoot> result) {
        PubRoot pubRoot;
        VirtualFile dir;
        if (parent == null) {
            FlutterProjectStructureDetector.$$$reportNull$$$0(0);
        }
        if (base == null) {
            FlutterProjectStructureDetector.$$$reportNull$$$0(1);
        }
        if (result == null) {
            FlutterProjectStructureDetector.$$$reportNull$$$0(2);
        }
        if (children == null) {
            FlutterProjectStructureDetector.$$$reportNull$$$0(3);
        }
        if ((dir = VfsUtil.findFileByIoFile((File)parent, (boolean)false)) != null && (pubRoot = PubRoot.forDirectory(dir)) != null) {
            if (pubRoot.declaresFlutter()) {
                result.add(new FlutterProjectRoot(parent));
            } else {
                result.add(new DartProjectRoot(parent));
            }
            ProjectStructureDetector.DirectoryProcessingResult directoryProcessingResult = ProjectStructureDetector.DirectoryProcessingResult.SKIP_CHILDREN;
            if (directoryProcessingResult == null) {
                FlutterProjectStructureDetector.$$$reportNull$$$0(4);
            }
            return directoryProcessingResult;
        }
        ProjectStructureDetector.DirectoryProcessingResult directoryProcessingResult = ProjectStructureDetector.DirectoryProcessingResult.PROCESS_CHILDREN;
        if (directoryProcessingResult == null) {
            FlutterProjectStructureDetector.$$$reportNull$$$0(5);
        }
        return directoryProcessingResult;
    }

    public String getDetectorId() {
        return "Flutter";
    }

    public void setupProjectStructure(@NotNull Collection<DetectedProjectRoot> roots, @NotNull ProjectDescriptor projectDescriptor, @NotNull ProjectFromSourcesBuilder builder) {
        if (roots == null) {
            FlutterProjectStructureDetector.$$$reportNull$$$0(6);
        }
        if (projectDescriptor == null) {
            FlutterProjectStructureDetector.$$$reportNull$$$0(7);
        }
        if (builder == null) {
            FlutterProjectStructureDetector.$$$reportNull$$$0(8);
        }
        ArrayList<ModuleDescriptor> modules = new ArrayList<ModuleDescriptor>();
        for (DetectedProjectRoot root : roots) {
            if (root == null) continue;
            modules.add(new ModuleDescriptor(root.getDirectory(), FlutterModuleUtils.getFlutterModuleType(), Collections.emptyList()));
        }
        projectDescriptor.setModules(modules);
        builder.setupModulesByContentRoots(projectDescriptor, roots);
        String name = builder.getContext().getProjectName();
        if (name != null) {
            this.scheduleAndroidModuleAddition(name, modules, 0);
        }
    }

    private void scheduleAndroidModuleAddition(final @NotNull String projectName, final @NotNull List<ModuleDescriptor> modules, int tries) {
        if (projectName == null) {
            FlutterProjectStructureDetector.$$$reportNull$$$0(9);
        }
        if (modules == null) {
            FlutterProjectStructureDetector.$$$reportNull$$$0(10);
        }
        final MessageBusConnection[] connection = new MessageBusConnection[]{ApplicationManager.getApplication().getMessageBus().connect()};
        FlutterProjectStructureDetector.scheduleDisconnectIfCancelled(connection);
        connection[0].subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){

            public void projectOpened(@NotNull Project project) {
                if (project == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (connection[0] != null) {
                    connection[0].disconnect();
                    connection[0] = null;
                }
                if (!projectName.equals(project.getName())) {
                    return;
                }
                StartupManager.getInstance((Project)project).runAfterOpened(() -> DumbService.getInstance((Project)project).smartInvokeLater(() -> {
                    for (ModuleDescriptor module : modules) {
                        File exampleFile;
                        File android;
                        File example;
                        assert (module != null);
                        Set roots = module.getContentRoots();
                        String moduleName = module.getName();
                        if (roots == null || roots.size() != 1 || moduleName == null) continue;
                        File root = (File)roots.iterator().next();
                        assert (root != null);
                        if (!FlutterProjectStructureDetector.projectHasContentRoot(project, root)) continue;
                        String imlName = moduleName + "_android.iml";
                        File moduleDir = null;
                        if (new File(root, imlName).exists()) {
                            moduleDir = root;
                        } else {
                            for (String name : new String[]{"android", ".android"}) {
                                File dir = new File(root, name);
                                if (!dir.exists() || !new File(dir, imlName).exists()) continue;
                                moduleDir = dir;
                                break;
                            }
                        }
                        if (moduleDir == null) continue;
                        try {
                            FlutterModuleBuilder.addAndroidModule(project, null, moduleDir.getPath(), module.getName(), true);
                        }
                        catch (IllegalStateException illegalStateException) {
                            // empty catch block
                        }
                        if (!(example = new File(root, "example")).exists() || !(android = new File(example, "android")).exists() || !(exampleFile = new File(android, moduleName + "_example_android.iml")).exists()) continue;
                        try {
                            FlutterModuleBuilder.addAndroidModuleFromFile(project, null, LocalFileSystem.getInstance().findFileByIoFile(exampleFile));
                        }
                        catch (IllegalStateException illegalStateException) {}
                    }
                }));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "io/flutter/project/FlutterProjectStructureDetector$1", "projectOpened"));
            }
        });
    }

    private static void scheduleDisconnectIfCancelled(MessageBusConnection[] connection) {
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            Project project = ProjectManager.getInstance().getDefaultProject();
            try {
                Thread.sleep(300000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (connection[0] != null) {
                connection[0].disconnect();
                connection[0] = null;
            }
        });
    }

    private static boolean projectHasContentRoot(@NotNull Project project, @NotNull File root) {
        if (project == null) {
            FlutterProjectStructureDetector.$$$reportNull$$$0(11);
        }
        if (root == null) {
            FlutterProjectStructureDetector.$$$reportNull$$$0(12);
        }
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByIoFile(root);
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            for (VirtualFile file : ModuleRootManager.getInstance((Module)module).getContentRoots()) {
                if (file == null || !file.equals(virtualFile)) continue;
                return true;
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "base";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/project/FlutterProjectStructureDetector";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectDescriptor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectName";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/project/FlutterProjectStructureDetector";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "detectRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "detectRoots";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setupProjectStructure";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "scheduleAndroidModuleAddition";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "projectHasContentRoot";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5 -> new IllegalStateException(string);
        };
    }

    private static class FlutterProjectRoot
    extends DetectedProjectRoot {
        public FlutterProjectRoot(@NotNull File directory) {
            if (directory == null) {
                FlutterProjectRoot.$$$reportNull$$$0(0);
            }
            super(directory);
        }

        @NotNull
        public String getRootTypeName() {
            return "Flutter";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "io/flutter/project/FlutterProjectStructureDetector$FlutterProjectRoot", "<init>"));
        }
    }

    private static class DartProjectRoot
    extends DetectedProjectRoot {
        public DartProjectRoot(@NotNull File directory) {
            if (directory == null) {
                DartProjectRoot.$$$reportNull$$$0(0);
            }
            super(directory);
        }

        @NotNull
        public String getRootTypeName() {
            return "Dart";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "io/flutter/project/FlutterProjectStructureDetector$DartProjectRoot", "<init>"));
        }
    }
}

