/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.project;

import com.intellij.ProjectTopics;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.util.messages.MessageBusConnection;
import io.flutter.FlutterUtils;
import java.io.Closeable;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;

public class ProjectWatch
implements Closeable {
    @NotNull
    private final Runnable callback;
    private final AtomicReference<Runnable> unsubscribe;
    private static final Logger LOG = Logger.getInstance(ProjectWatch.class);

    private ProjectWatch(@NotNull Project project, @NotNull Runnable callback) {
        if (project == null) {
            ProjectWatch.$$$reportNull$$$0(0);
        }
        if (callback == null) {
            ProjectWatch.$$$reportNull$$$0(1);
        }
        this.unsubscribe = new AtomicReference();
        this.callback = callback;
        ProjectManagerListener listener = new ProjectManagerListener(){

            public void projectClosed(@NotNull Project project) {
                if (project == null) {
                    1.$$$reportNull$$$0(0);
                }
                ProjectWatch.this.fireEvent();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "io/flutter/project/ProjectWatch$1", "projectClosed"));
            }
        };
        ProjectManager manager = ProjectManager.getInstance();
        manager.addProjectManagerListener(project, listener);
        MessageBusConnection bus = project.getMessageBus().connect();
        bus.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void rootsChanged(@NotNull ModuleRootEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                ProjectWatch.this.fireEvent();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "io/flutter/project/ProjectWatch$2", "rootsChanged"));
            }
        });
        this.unsubscribe.set(() -> {
            bus.disconnect();
            manager.removeProjectManagerListener(project, listener);
        });
    }

    @NotNull
    public static ProjectWatch subscribe(@NotNull Project project, @NotNull Runnable callback) {
        if (project == null) {
            ProjectWatch.$$$reportNull$$$0(2);
        }
        if (callback == null) {
            ProjectWatch.$$$reportNull$$$0(3);
        }
        return new ProjectWatch(project, callback);
    }

    @Override
    public void close() {
        Runnable unsubscribe = this.unsubscribe.getAndSet(null);
        if (unsubscribe != null) {
            unsubscribe.run();
        }
    }

    private void fireEvent() {
        if (this.unsubscribe.get() == null) {
            return;
        }
        try {
            this.callback.run();
        }
        catch (Exception e) {
            FlutterUtils.warn(LOG, "Uncaught exception in ProjectWatch callback", e);
            this.close();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
        }
        objectArray2[1] = "io/flutter/project/ProjectWatch";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "subscribe";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

