/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.pub;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.jetbrains.lang.dart.util.DotPackagesFileUtil;
import io.flutter.FlutterUtils;
import io.flutter.pub.PubRoots;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PubRoot {
    private static final Logger LOG = Logger.getInstance(PubRoot.class);
    @NotNull
    private final VirtualFile root;
    @NotNull
    private final VirtualFile pubspec;
    private static final String[] TEST_DIRS = new String[]{"/test/", "/integration_test/", "/test_driver/", "/testing/"};
    private FlutterUtils.FlutterPubspecInfo cachedPubspecInfo;

    private PubRoot(@NotNull VirtualFile root, @NotNull VirtualFile pubspec) {
        if (root == null) {
            PubRoot.$$$reportNull$$$0(0);
        }
        if (pubspec == null) {
            PubRoot.$$$reportNull$$$0(1);
        }
        this.root = root;
        this.pubspec = pubspec;
    }

    @Nullable
    public static PubRoot forFile(@Nullable VirtualFile file) {
        PubRoot root;
        if (file == null) {
            return null;
        }
        if (file.isDirectory() && (root = PubRoot.forDirectory(file.getParent())) != null) {
            return root;
        }
        return PubRoot.forFile(file.getParent());
    }

    @Nullable
    public static PubRoot forEventWithRefresh(@NotNull AnActionEvent event) {
        List<PubRoot> roots;
        PubRoot root;
        PsiFile psiFile;
        if (event == null) {
            PubRoot.$$$reportNull$$$0(2);
        }
        if ((psiFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(event.getDataContext())) != null && (root = PubRoot.forPsiFile(psiFile)) != null) {
            return root.refresh();
        }
        Module module = (Module)LangDataKeys.MODULE.getData(event.getDataContext());
        if (module != null && !(roots = PubRoots.forModule(module)).isEmpty()) {
            return roots.get(0);
        }
        return null;
    }

    @Nullable
    public static PubRoot forPsiFile(@NotNull PsiFile psiFile) {
        VirtualFile file;
        if (psiFile == null) {
            PubRoot.$$$reportNull$$$0(3);
        }
        if ((file = psiFile.getVirtualFile()) == null) {
            return null;
        }
        if (PubRoot.isPubspec(file)) {
            return PubRoot.forDirectory(file.getParent());
        }
        return PubRoot.forDescendant(file, psiFile.getProject());
    }

    @Nullable
    public static PubRoot forDescendant(@NotNull VirtualFile fileOrDir, @NotNull Project project) {
        if (fileOrDir == null) {
            PubRoot.$$$reportNull$$$0(4);
        }
        if (project == null) {
            PubRoot.$$$reportNull$$$0(5);
        }
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)project).getFileIndex();
        return (PubRoot)ApplicationManager.getApplication().runReadAction(() -> {
            VirtualFile root = index.getContentRootForFile(fileOrDir);
            return PubRoot.forDirectory(root);
        });
    }

    @Nullable
    public static PubRoot forDirectory(@Nullable VirtualFile dir) {
        if (dir == null || !dir.isDirectory() || dir.getPath().endsWith("/")) {
            return null;
        }
        VirtualFile pubspec = dir.findChild("pubspec.yaml");
        if (pubspec == null || !pubspec.exists() || pubspec.isDirectory()) {
            return null;
        }
        return new PubRoot(dir, pubspec);
    }

    @Nullable
    public static PubRoot forDirectoryWithRefresh(@NotNull VirtualFile dir) {
        if (dir == null) {
            PubRoot.$$$reportNull$$$0(6);
        }
        dir.refresh(false, false);
        return PubRoot.forDirectory(dir);
    }

    @Nullable
    public String getRelativePath(@NotNull VirtualFile file) {
        if (file == null) {
            PubRoot.$$$reportNull$$$0(7);
        }
        String root = this.root.getPath();
        String path = file.getPath();
        if (!path.startsWith(root) || path.length() < root.length() + 2) {
            return null;
        }
        return path.substring(root.length() + 1);
    }

    public boolean hasTests(@NotNull VirtualFile dir) {
        if (dir == null) {
            PubRoot.$$$reportNull$$$0(8);
        }
        if (!dir.isDirectory()) {
            return false;
        }
        if (this.getRoot().equals(dir)) {
            return true;
        }
        String path = dir.getPath() + "/";
        for (String testDir : TEST_DIRS) {
            if (!path.contains(testDir)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public PubRoot refresh() {
        return PubRoot.forDirectoryWithRefresh(this.root);
    }

    @NotNull
    public VirtualFile getRoot() {
        VirtualFile virtualFile = this.root;
        if (virtualFile == null) {
            PubRoot.$$$reportNull$$$0(9);
        }
        return virtualFile;
    }

    @NotNull
    public String getPath() {
        String string = this.root.getPath();
        if (string == null) {
            PubRoot.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    public VirtualFile getPubspec() {
        VirtualFile virtualFile = this.pubspec;
        if (virtualFile == null) {
            PubRoot.$$$reportNull$$$0(11);
        }
        return virtualFile;
    }

    public boolean declaresFlutter() {
        this.validateUpdateCachedPubspecInfo();
        return this.cachedPubspecInfo.declaresFlutter();
    }

    private void validateUpdateCachedPubspecInfo() {
        if (this.cachedPubspecInfo == null || this.cachedPubspecInfo.getModificationStamp() != this.pubspec.getModificationStamp()) {
            this.cachedPubspecInfo = FlutterUtils.getFlutterPubspecInfo(this.pubspec);
        }
    }

    public boolean isFlutterPlugin() {
        return FlutterUtils.isFlutterPlugin(this.pubspec);
    }

    public boolean isFlutterModule() {
        return this.root.findChild(".android") != null;
    }

    public boolean isNonEditableFlutterModule() {
        return this.isFlutterModule() && this.root.findChild("android") == null;
    }

    @Nullable
    public VirtualFile getPackageConfigFile() {
        VirtualFile tools = this.root.findChild(".dart_tool");
        if (tools == null || !tools.isDirectory()) {
            return null;
        }
        VirtualFile config = tools.findChild("package_config.json");
        if (config != null && !config.isDirectory()) {
            return config;
        }
        return null;
    }

    @Nullable
    public VirtualFile getPackagesFile() {
        VirtualFile packages = this.root.findChild(".packages");
        if (packages != null && !packages.isDirectory()) {
            return packages;
        }
        return null;
    }

    @Nullable
    public Map<String, String> getPackagesMap() {
        VirtualFile packageConfigFile = this.getPackageConfigFile();
        if (packageConfigFile != null) {
            return DotPackagesFileUtil.getPackagesMapFromPackageConfigJsonFile((VirtualFile)packageConfigFile);
        }
        VirtualFile packagesFile = this.getPackagesFile();
        if (packagesFile != null) {
            return DotPackagesFileUtil.getPackagesMap((VirtualFile)packagesFile);
        }
        return null;
    }

    public boolean hasUpToDatePackages() {
        VirtualFile configFile = this.getPackageConfigFile();
        if (configFile != null) {
            return this.pubspec.getTimeStamp() < configFile.getTimeStamp();
        }
        VirtualFile packagesFile = this.getPackagesFile();
        if (packagesFile == null) {
            return false;
        }
        return this.pubspec.getTimeStamp() < packagesFile.getTimeStamp();
    }

    @Nullable
    public VirtualFile getLib() {
        VirtualFile lib = this.root.findChild("lib");
        if (lib != null && lib.isDirectory()) {
            return lib;
        }
        return null;
    }

    @Nullable
    public VirtualFile getFileToOpen() {
        VirtualFile[] files;
        VirtualFile main = this.getLibMain();
        if (main != null) {
            return main;
        }
        VirtualFile lib = this.getLib();
        if (lib != null && (files = lib.getChildren()).length != 0) {
            return files[0];
        }
        return null;
    }

    @Nullable
    public VirtualFile getLibMain() {
        VirtualFile lib = this.getLib();
        return lib == null ? null : lib.findChild("main.dart");
    }

    public VirtualFile getExampleLibMain() {
        VirtualFile libDir;
        VirtualFile exampleDir = this.root.findChild("example");
        if (exampleDir != null && (libDir = exampleDir.findChild("lib")) != null) {
            return libDir.findChild("main.dart");
        }
        return null;
    }

    @Nullable
    public VirtualFile getIntegrationTestDir() {
        return this.root.findChild("integration_test");
    }

    @Nullable
    public VirtualFile getExampleDir() {
        return this.root.findChild("example");
    }

    @Nullable
    public VirtualFile getAndroidDir() {
        VirtualFile dir = this.root.findChild("android");
        if (dir == null) {
            dir = this.root.findChild(".android");
        }
        return dir;
    }

    @Nullable
    public VirtualFile getiOsDir() {
        VirtualFile dir = this.root.findChild("ios");
        if (dir == null) {
            dir = this.root.findChild(".ios");
        }
        return dir;
    }

    public boolean hasAndroidModule(Project project) {
        VirtualFile androidDir = this.getAndroidDir();
        if (androidDir == null) {
            return false;
        }
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            for (VirtualFile contentRoot : ModuleRootManager.getInstance((Module)module).getContentRoots()) {
                if (!contentRoot.equals(androidDir)) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    public Module getModule(@NotNull Project project) {
        if (project == null) {
            PubRoot.$$$reportNull$$$0(12);
        }
        if (project.isDisposed()) {
            return null;
        }
        return ProjectRootManager.getInstance((Project)project).getFileIndex().getModuleForFile(this.pubspec);
    }

    public boolean contains(@NotNull VirtualFile file) {
        if (file == null) {
            PubRoot.$$$reportNull$$$0(13);
        }
        for (VirtualFile dir = file.getParent(); dir != null; dir = dir.getParent()) {
            if (!dir.equals(this.root)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "PubRoot(" + this.root.getName() + ")";
    }

    public static boolean isPubspec(@NotNull VirtualFile file) {
        if (file == null) {
            PubRoot.$$$reportNull$$$0(14);
        }
        return !file.isDirectory() && file.getName().equals("pubspec.yaml");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9, 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pubspec";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileOrDir";
                break;
            }
            case 5: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 7: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/pub/PubRoot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/pub/PubRoot";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoot";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getPubspec";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "forEventWithRefresh";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "forPsiFile";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "forDescendant";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "forDirectoryWithRefresh";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getRelativePath";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "hasTests";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getModule";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isPubspec";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9, 10, 11 -> new IllegalStateException(string);
        };
    }
}

