/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.pub;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import io.flutter.pub.PubRoot;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PubRootCache {
    @NotNull
    final Project project;
    private final Map<VirtualFile, PubRoot> cache;

    @NotNull
    public static PubRootCache getInstance(@NotNull Project project) {
        if (project == null) {
            PubRootCache.$$$reportNull$$$0(0);
        }
        PubRootCache pubRootCache = Objects.requireNonNull((PubRootCache)project.getService(PubRootCache.class));
        if (pubRootCache == null) {
            PubRootCache.$$$reportNull$$$0(1);
        }
        return pubRootCache;
    }

    private PubRootCache(@NotNull Project project) {
        if (project == null) {
            PubRootCache.$$$reportNull$$$0(2);
        }
        this.cache = new HashMap<VirtualFile, PubRoot>();
        this.project = project;
    }

    @Nullable
    public PubRoot getRoot(@NotNull PsiFile psiFile) {
        VirtualFile file;
        if (psiFile == null) {
            PubRootCache.$$$reportNull$$$0(3);
        }
        if ((file = psiFile.getVirtualFile()) == null) {
            return null;
        }
        return this.getRoot(file);
    }

    @Nullable
    public PubRoot getRoot(VirtualFile file) {
        if ((file = this.findPubspecDir(file)) == null) {
            return null;
        }
        PubRoot root = this.cache.get(file);
        if (root == null) {
            this.cache.put(file, PubRoot.forDirectory(file));
            root = this.cache.get(file);
        }
        return root;
    }

    @NotNull
    public List<PubRoot> getRoots(Module module) {
        ArrayList<PubRoot> result = new ArrayList<PubRoot>();
        for (VirtualFile dir : ModuleRootManager.getInstance((Module)module).getContentRoots()) {
            PubRoot root = this.cache.get(dir);
            if (root == null) {
                this.cache.put(dir, PubRoot.forDirectory(dir));
                root = this.cache.get(dir);
            }
            if (root == null) continue;
            result.add(root);
        }
        ArrayList<PubRoot> arrayList = result;
        if (arrayList == null) {
            PubRootCache.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @NotNull
    public List<PubRoot> getRoots(@NotNull Project project) {
        if (project == null) {
            PubRootCache.$$$reportNull$$$0(5);
        }
        ArrayList<PubRoot> result = new ArrayList<PubRoot>();
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            result.addAll(this.getRoots(module));
        }
        ArrayList<PubRoot> arrayList = result;
        if (arrayList == null) {
            PubRootCache.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    @Nullable
    private VirtualFile findPubspecDir(VirtualFile file) {
        VirtualFile pubspec;
        if (file == null) {
            return null;
        }
        if (file.isDirectory() && (pubspec = file.findChild("pubspec.yaml")) != null && pubspec.exists() && !pubspec.isDirectory()) {
            return file;
        }
        return this.findPubspecDir(file.getParent());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 4, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/pub/PubRootCache";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/pub/PubRootCache";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 4: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getRoot";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getRoots";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 4, 6 -> new IllegalStateException(string);
        };
    }
}

