/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.run;

import com.intellij.execution.configuration.EnvironmentVariablesTextFieldWithBrowseButton;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.fields.ExpandableTextField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.jetbrains.lang.dart.ide.runner.server.ui.DartCommandLineConfigurationEditorForm;
import io.flutter.run.SdkFields;
import io.flutter.run.SdkRunConfig;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;

public class FlutterConfigurationEditorForm
extends SettingsEditor<SdkRunConfig> {
    private JPanel myMainPanel;
    private JLabel myDartFileLabel;
    private TextFieldWithBrowseButton myFileField;
    private ExpandableTextField myAdditionalArgumentsField;
    private JTextField myBuildFlavorField;
    private ExpandableTextField myAttachArgsField;
    private EnvironmentVariablesTextFieldWithBrowseButton myEnvironmentVariables;
    private JLabel myEnvvarLabel;

    public FlutterConfigurationEditorForm(Project project) {
        this.$$$setupUI$$$();
        DartCommandLineConfigurationEditorForm.initDartFileTextWithBrowse((Project)project, (TextFieldWithBrowseButton)this.myFileField);
    }

    protected void resetEditorFrom(@NotNull SdkRunConfig config) {
        if (config == null) {
            FlutterConfigurationEditorForm.$$$reportNull$$$0(0);
        }
        SdkFields fields = config.getFields();
        this.myFileField.setText(FileUtil.toSystemDependentName((String)StringUtil.notNullize((String)fields.getFilePath())));
        this.myBuildFlavorField.setText(fields.getBuildFlavor());
        this.myAdditionalArgumentsField.setText(fields.getAdditionalArgs());
        this.myAttachArgsField.setText(fields.getAttachArgs());
        this.myEnvironmentVariables.setEnvs(fields.getEnvs());
    }

    protected void applyEditorTo(@NotNull SdkRunConfig config) throws ConfigurationException {
        if (config == null) {
            FlutterConfigurationEditorForm.$$$reportNull$$$0(1);
        }
        SdkFields fields = new SdkFields();
        fields.setFilePath(StringUtil.nullize((String)FileUtil.toSystemIndependentName((String)this.myFileField.getText().trim()), (boolean)true));
        fields.setBuildFlavor(StringUtil.nullize((String)this.myBuildFlavorField.getText().trim()));
        fields.setAdditionalArgs(StringUtil.nullize((String)this.myAdditionalArgumentsField.getText().trim()));
        fields.setAttachArgs(StringUtil.nullize((String)this.myAttachArgsField.getText().trim()));
        fields.setEnvs(this.myEnvironmentVariables.getEnvs());
        config.setFields(fields);
    }

    @NotNull
    protected JComponent createEditor() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            FlutterConfigurationEditorForm.$$$reportNull$$$0(2);
        }
        return jPanel;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        EnvironmentVariablesTextFieldWithBrowseButton environmentVariablesTextFieldWithBrowseButton;
        JLabel jLabel;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        ExpandableTextField expandableTextField;
        ExpandableTextField expandableTextField2;
        JTextField jTextField;
        JLabel jLabel2;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(11, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(10, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myDartFileLabel = jLabel2 = new JLabel();
        jLabel2.setInheritsPopupMenu(true);
        jLabel2.setText("Dart entrypoint:");
        jLabel2.setDisplayedMnemonic('E');
        jLabel2.setDisplayedMnemonicIndex(5);
        jLabel2.setToolTipText("The main Dart entrypoint script.");
        jPanel.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Build flavor:");
        jLabel3.setToolTipText("The build flavor. This is either a gradle product flavor or an Xcode custom scheme.");
        jPanel.add((Component)jLabel3, new GridConstraints(6, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myBuildFlavorField = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(6, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel4 = new JLabel();
        ((Component)jLabel4).setEnabled(false);
        jLabel4.setText("The entry-point for the application (e.g. lib/main.dart).");
        jPanel.add((Component)jLabel4, new GridConstraints(1, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myAdditionalArgumentsField = expandableTextField2 = new ExpandableTextField();
        expandableTextField2.setMargin(new Insets(2, 6, 2, 29));
        expandableTextField2.setText("");
        jPanel.add((Component)expandableTextField2, new GridConstraints(2, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        JLabel jLabel5 = new JLabel();
        jLabel5.setText("Additional run args:");
        jLabel5.setDisplayedMnemonic('A');
        jLabel5.setDisplayedMnemonicIndex(15);
        jLabel5.setToolTipText("Additional command-line arguments to pass into 'flutter run'.");
        jPanel.add((Component)jLabel5, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel6 = new JLabel();
        ((Component)jLabel6).setEnabled(false);
        jLabel6.setText("Additional arguments to 'flutter run'.");
        jPanel.add((Component)jLabel6, new GridConstraints(3, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myAttachArgsField = expandableTextField = new ExpandableTextField();
        expandableTextField.setMargin(new Insets(2, 6, 2, 29));
        jPanel.add((Component)expandableTextField, new GridConstraints(4, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        JLabel jLabel7 = new JLabel();
        jLabel7.setText("Additional attach args:");
        jLabel7.setDisplayedMnemonic('T');
        jLabel7.setDisplayedMnemonicIndex(12);
        jLabel7.setToolTipText("Additional command-line arguments to pass into 'flutter attach'.");
        jPanel.add((Component)jLabel7, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel8 = new JLabel();
        ((Component)jLabel8).setEnabled(false);
        jLabel8.setText("Additional arguments to 'flutter attach'.");
        jPanel.add((Component)jLabel8, new GridConstraints(5, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myFileField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        textFieldWithBrowseButton.setFocusable(true);
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myEnvvarLabel = jLabel = new JLabel();
        jLabel.setText("Environment variables:");
        jPanel.add((Component)jLabel, new GridConstraints(8, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myEnvironmentVariables = environmentVariablesTextFieldWithBrowseButton = new EnvironmentVariablesTextFieldWithBrowseButton();
        jPanel.add((Component)environmentVariablesTextFieldWithBrowseButton, new GridConstraints(8, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        JLabel jLabel9 = new JLabel();
        ((Component)jLabel9).setEnabled(false);
        jLabel9.setText("Additional environment variables.");
        jPanel.add((Component)jLabel9, new GridConstraints(9, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel10 = new JLabel();
        ((Component)jLabel10).setEnabled(false);
        jLabel10.setText("An optional build flavor; either a Gradle product flavor or an Xcode custom scheme.");
        jPanel.add((Component)jLabel10, new GridConstraints(7, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        jLabel2.setLabelFor((Component)textFieldWithBrowseButton);
        jLabel3.setLabelFor(jTextField);
        jLabel5.setLabelFor((Component)expandableTextField2);
        jLabel7.setLabelFor((Component)expandableTextField2);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/run/FlutterConfigurationEditorForm";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/run/FlutterConfigurationEditorForm";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

