/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.run;

import com.intellij.execution.ExecutionResult;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Computable;
import com.intellij.ui.content.Content;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerBundle;
import com.jetbrains.lang.dart.util.DartUrlResolver;
import io.flutter.FlutterUtils;
import io.flutter.actions.ReloadAllFlutterApps;
import io.flutter.actions.ReloadFlutterApp;
import io.flutter.actions.RestartAllFlutterApps;
import io.flutter.actions.RestartFlutterApp;
import io.flutter.inspector.InspectorService;
import io.flutter.run.FlutterPopFrameAction;
import io.flutter.run.OpenDevToolsAction;
import io.flutter.run.common.RunMode;
import io.flutter.run.daemon.FlutterApp;
import io.flutter.view.FlutterViewMessages;
import io.flutter.vmService.DartVmServiceDebugProcess;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.dartlang.vm.service.VmService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlutterDebugProcess
extends DartVmServiceDebugProcess {
    private static final Logger LOG = Logger.getInstance(FlutterDebugProcess.class);
    @NotNull
    private final FlutterApp app;
    CompletableFuture<InspectorService> inspectorService;

    public FlutterDebugProcess(@NotNull FlutterApp app, @NotNull ExecutionEnvironment executionEnvironment, @NotNull XDebugSession session, @NotNull ExecutionResult executionResult, @NotNull DartUrlResolver dartUrlResolver, @NotNull DartVmServiceDebugProcess.PositionMapper mapper) {
        if (app == null) {
            FlutterDebugProcess.$$$reportNull$$$0(0);
        }
        if (executionEnvironment == null) {
            FlutterDebugProcess.$$$reportNull$$$0(1);
        }
        if (session == null) {
            FlutterDebugProcess.$$$reportNull$$$0(2);
        }
        if (executionResult == null) {
            FlutterDebugProcess.$$$reportNull$$$0(3);
        }
        if (dartUrlResolver == null) {
            FlutterDebugProcess.$$$reportNull$$$0(4);
        }
        if (mapper == null) {
            FlutterDebugProcess.$$$reportNull$$$0(5);
        }
        super(executionEnvironment, session, executionResult, dartUrlResolver, app.getConnector(), mapper);
        this.app = app;
    }

    @NotNull
    public FlutterApp getApp() {
        FlutterApp flutterApp = this.app;
        if (flutterApp == null) {
            FlutterDebugProcess.$$$reportNull$$$0(6);
        }
        return flutterApp;
    }

    public CompletableFuture<InspectorService> getInspectorService() {
        if (this.inspectorService == null && this.getVmConnected() && this.app.getVmService() != null) {
            this.inspectorService = InspectorService.create(this.app, this, this.app.getVmService());
        }
        return this.inspectorService;
    }

    @Override
    protected void onVmConnected(@NotNull VmService vmService) {
        if (vmService == null) {
            FlutterDebugProcess.$$$reportNull$$$0(7);
        }
        this.app.setFlutterDebugProcess(this);
        FlutterViewMessages.sendDebugActive(this.getSession().getProject(), this.app, vmService);
    }

    @Override
    public void registerAdditionalActions(@NotNull DefaultActionGroup leftToolbar, @NotNull DefaultActionGroup topToolbar, @NotNull DefaultActionGroup settings) {
        if (leftToolbar == null) {
            FlutterDebugProcess.$$$reportNull$$$0(8);
        }
        if (topToolbar == null) {
            FlutterDebugProcess.$$$reportNull$$$0(9);
        }
        if (settings == null) {
            FlutterDebugProcess.$$$reportNull$$$0(10);
        }
        if (this.app.getMode() != RunMode.DEBUG) {
            AnAction[] settingsActions;
            AnAction[] topActions;
            AnAction[] leftActions = leftToolbar.getChildActionsOrStubs();
            List<String> actionClassNames = Arrays.asList("com.intellij.execution.actions.StopAction", "com.intellij.ui.content.tabs.PinToolwindowTabAction", "com.intellij.execution.ui.actions.CloseAction", "com.intellij.ide.actions.ContextHelpAction");
            for (AnAction a : leftActions) {
                if (actionClassNames.contains(a.getClass().getName())) continue;
                leftToolbar.remove(a);
            }
            for (AnAction action : topActions = topToolbar.getChildActionsOrStubs()) {
                topToolbar.remove(action);
            }
            for (AnAction a : settingsActions = settings.getChildActionsOrStubs()) {
                settings.remove(a);
            }
        }
        Computable isSessionActive = () -> this.app.isStarted() && this.getVmConnected() && !this.getSession().isStopped();
        Computable canReload = () -> this.app.getLaunchMode().supportsReload() && (Boolean)isSessionActive.compute() != false && !this.app.isReloading();
        Computable debugUrlAvailable = () -> (Boolean)isSessionActive.compute() != false && this.app.getConnector().getBrowserUrl() != null;
        if (this.app.getMode() == RunMode.DEBUG) {
            topToolbar.addSeparator();
            topToolbar.addAction((AnAction)new FlutterPopFrameAction());
        }
        topToolbar.addSeparator();
        topToolbar.addAction((AnAction)new ReloadFlutterApp(this.app, (Computable<Boolean>)canReload));
        topToolbar.addAction((AnAction)new RestartFlutterApp(this.app, (Computable<Boolean>)canReload));
        topToolbar.addSeparator();
        topToolbar.addAction((AnAction)new OpenDevToolsAction(this.app, (Computable<Boolean>)debugUrlAvailable));
        settings.addAction((AnAction)new ReloadAllFlutterApps(this.app, (Computable<Boolean>)canReload));
        settings.addAction((AnAction)new RestartAllFlutterApps(this.app, (Computable<Boolean>)canReload));
    }

    public void sessionInitialized() {
        if (this.app.getMode() != RunMode.DEBUG) {
            FlutterDebugProcess.suppressDebugViews(this.getSession().getUI());
        }
    }

    private static void suppressDebugViews(@Nullable RunnerLayoutUi ui) {
        if (ui == null) {
            return;
        }
        String name = XDebuggerBundle.message((String)"debugger.session.tab.console.content.name", (Object[])new Object[0]);
        for (Content c : ui.getContents()) {
            if (Objects.equals(c.getTabName(), name)) continue;
            try {
                ApplicationManager.getApplication().invokeAndWait(() -> ui.removeContent(c, false));
            }
            catch (ProcessCanceledException e) {
                FlutterUtils.warn(LOG, e);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "app";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executionEnvironment";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executionResult";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dartUrlResolver";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapper";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/run/FlutterDebugProcess";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vmService";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leftToolbar";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topToolbar";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/run/FlutterDebugProcess";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getApp";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "onVmConnected";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "registerAdditionalActions";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6 -> new IllegalStateException(string);
        };
    }
}

