/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.run;

import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.util.Key;
import org.jetbrains.annotations.NotNull;

public enum FlutterLaunchMode {
    DEBUG("debug"),
    PROFILE("profile"),
    RELEASE("release");

    private static final Key<FlutterLaunchMode> LAUNCH_MODE_KEY;
    private final String myCliCommand;

    public static void addToEnvironment(ExecutionEnvironment env, FlutterLaunchMode mode) {
        env.putUserData(LAUNCH_MODE_KEY, (Object)mode);
    }

    @NotNull
    public static FlutterLaunchMode fromEnv(@NotNull ExecutionEnvironment env) {
        FlutterLaunchMode launchMode;
        if (env == null) {
            FlutterLaunchMode.$$$reportNull$$$0(0);
        }
        FlutterLaunchMode flutterLaunchMode = (launchMode = (FlutterLaunchMode)((Object)env.getUserData(LAUNCH_MODE_KEY))) == null ? DEBUG : launchMode;
        if (flutterLaunchMode == null) {
            FlutterLaunchMode.$$$reportNull$$$0(1);
        }
        return flutterLaunchMode;
    }

    private FlutterLaunchMode(String cliCommand) {
        this.myCliCommand = cliCommand;
    }

    public String getCliCommand() {
        return this.myCliCommand;
    }

    public boolean supportsDebugConnection() {
        return this == DEBUG || this == PROFILE;
    }

    public boolean supportsReload() {
        return this == DEBUG;
    }

    public boolean isProfiling() {
        return this == PROFILE;
    }

    public String toString() {
        return this.myCliCommand;
    }

    static {
        LAUNCH_MODE_KEY = Key.create((String)"FlutterLaunchMode");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/run/FlutterLaunchMode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/run/FlutterLaunchMode";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "fromEnv";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "fromEnv";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

