/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.run;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.util.PathUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.jetbrains.lang.dart.analyzer.DartAnalysisServerService;
import com.jetbrains.lang.dart.util.DartResolveUtil;
import com.jetbrains.lang.dart.util.DartUrlResolver;
import gnu.trove.THashMap;
import io.flutter.FlutterInitializer;
import io.flutter.FlutterUtils;
import io.flutter.analytics.Analytics;
import io.flutter.bazel.WorkspaceCache;
import io.flutter.dart.DartPlugin;
import io.flutter.run.ObservatoryFile;
import io.flutter.vmService.DartVmServiceDebugProcess;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.dartlang.vm.service.element.LibraryRef;
import org.dartlang.vm.service.element.Script;
import org.dartlang.vm.service.element.ScriptRef;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlutterPositionMapper
implements DartVmServiceDebugProcess.PositionMapper {
    private static final Logger LOG = Logger.getInstance(FlutterPositionMapper.class);
    @NotNull
    private final Project project;
    @NotNull
    private final VirtualFile sourceRoot;
    @NotNull
    private final DartUrlResolver resolver;
    @Nullable
    private final Analyzer analyzer;
    @Nullable
    private DartVmServiceDebugProcess.ScriptProvider scriptProvider;
    @Nullable
    private String remoteBaseUri;
    @Nullable
    private String remoteSourceRoot;
    private final Map<String, ObservatoryFile.Cache> fileCache;

    public FlutterPositionMapper(@NotNull Project project, @NotNull VirtualFile sourceRoot, @NotNull DartUrlResolver resolver, @Nullable Analyzer analyzer) {
        if (project == null) {
            FlutterPositionMapper.$$$reportNull$$$0(0);
        }
        if (sourceRoot == null) {
            FlutterPositionMapper.$$$reportNull$$$0(1);
        }
        if (resolver == null) {
            FlutterPositionMapper.$$$reportNull$$$0(2);
        }
        this.fileCache = new THashMap();
        this.project = project;
        this.sourceRoot = sourceRoot;
        this.resolver = resolver;
        this.analyzer = analyzer;
    }

    @NotNull
    public Project getProject() {
        Project project = this.project;
        if (project == null) {
            FlutterPositionMapper.$$$reportNull$$$0(3);
        }
        return project;
    }

    @Override
    public void onConnect(@NotNull DartVmServiceDebugProcess.ScriptProvider provider, @Nullable String remoteBaseUri) {
        if (provider == null) {
            FlutterPositionMapper.$$$reportNull$$$0(4);
        }
        if (this.scriptProvider != null) {
            throw new IllegalStateException("already connected");
        }
        this.scriptProvider = provider;
        this.remoteBaseUri = remoteBaseUri;
    }

    @Override
    public void onLibrariesDownloaded(@NotNull Iterable<LibraryRef> libraries) {
        if (libraries == null) {
            FlutterPositionMapper.$$$reportNull$$$0(5);
        }
        for (LibraryRef library : libraries) {
            String remoteUri = library.getUri();
            if (remoteUri.startsWith("dart:") || remoteUri.startsWith("package:")) continue;
            this.remoteSourceRoot = this.findRemoteSourceRoot(remoteUri);
            if (this.remoteSourceRoot == null) continue;
            return;
        }
    }

    private String findRemoteSourceRoot(String remotePath) {
        PsiFile[] localFilesWithSameName = (PsiFile[])ApplicationManager.getApplication().runReadAction(() -> {
            String remoteFileName = PathUtil.getFileName((String)remotePath);
            GlobalSearchScope scope = GlobalSearchScopesCore.directoryScope((Project)this.project, (VirtualFile)this.sourceRoot, (boolean)true);
            return FilenameIndex.getFilesByName((Project)this.project, (String)remoteFileName, (GlobalSearchScope)scope);
        });
        String match = null;
        for (PsiFile psiFile : localFilesWithSameName) {
            VirtualFile local = DartResolveUtil.getRealVirtualFile((PsiFile)psiFile);
            if (local == null) continue;
            assert (local.getPath().startsWith(this.sourceRoot.getPath() + "/"));
            String relativeLocal = local.getPath().substring(this.sourceRoot.getPath().length());
            if (!remotePath.endsWith(relativeLocal)) continue;
            if (match != null) {
                return null;
            }
            match = remotePath.substring(0, remotePath.length() - relativeLocal.length());
        }
        return match;
    }

    @Override
    @NotNull
    public Collection<String> getBreakpointUris(@NotNull VirtualFile file) {
        String root;
        String path;
        String uriByServer;
        if (file == null) {
            FlutterPositionMapper.$$$reportNull$$$0(6);
        }
        HashSet<String> results = new HashSet<String>();
        String uriByIde = this.resolver.getDartUrlForFile(file);
        if (uriByIde.startsWith("dart:")) {
            results.add(uriByIde);
            HashSet<String> hashSet = results;
            if (hashSet == null) {
                FlutterPositionMapper.$$$reportNull$$$0(7);
            }
            return hashSet;
        }
        if (uriByIde.startsWith("file:")) {
            results.add(FlutterPositionMapper.threeSlashize(uriByIde));
        } else {
            results.add(uriByIde);
            results.add(FlutterPositionMapper.threeSlashize(new File(file.getPath()).toURI().toString()));
        }
        if (WorkspaceCache.getInstance(this.project).isBazel()) {
            FlutterInitializer.getAnalytics().sendEvent("breakpoint", this.analyzer == null ? "analyzer-found" : "analyzer-null");
        }
        if (this.analyzer != null && (uriByServer = this.analyzer.getUri(file.getPath())) != null) {
            results.add(uriByServer);
        }
        if ((path = file.getPath()).startsWith(root = this.sourceRoot.getPath())) {
            if (this.remoteSourceRoot != null) {
                results.add(this.remoteSourceRoot + path.substring(root.length()));
            }
            if (this.remoteBaseUri != null) {
                results.add(this.remoteBaseUri + path.substring(root.length()));
            }
        }
        HashSet<String> hashSet = results;
        if (hashSet == null) {
            FlutterPositionMapper.$$$reportNull$$$0(8);
        }
        return hashSet;
    }

    @Override
    @Nullable
    public XSourcePosition getSourcePosition(@NotNull String isolateId, @NotNull ScriptRef scriptRef, int tokenPos, CompletableFuture<String> fileFuture) {
        if (isolateId == null) {
            FlutterPositionMapper.$$$reportNull$$$0(9);
        }
        if (scriptRef == null) {
            FlutterPositionMapper.$$$reportNull$$$0(10);
        }
        return this.getSourcePosition(isolateId, scriptRef.getId(), scriptRef.getUri(), tokenPos, fileFuture);
    }

    @Override
    @Nullable
    public XSourcePosition getSourcePosition(@NotNull String isolateId, @NotNull Script script, int tokenPos) {
        if (isolateId == null) {
            FlutterPositionMapper.$$$reportNull$$$0(11);
        }
        if (script == null) {
            FlutterPositionMapper.$$$reportNull$$$0(12);
        }
        return this.getSourcePosition(isolateId, script.getId(), script.getUri(), tokenPos);
    }

    private XSourcePosition getSourcePosition(@NotNull String isolateId, @NotNull String scriptId, @NotNull String scriptUri, int tokenPos) {
        if (isolateId == null) {
            FlutterPositionMapper.$$$reportNull$$$0(13);
        }
        if (scriptId == null) {
            FlutterPositionMapper.$$$reportNull$$$0(14);
        }
        if (scriptUri == null) {
            FlutterPositionMapper.$$$reportNull$$$0(15);
        }
        return this.getSourcePosition(isolateId, scriptId, scriptUri, tokenPos, null);
    }

    @Nullable
    private XSourcePosition getSourcePosition(@NotNull String isolateId, @NotNull String scriptId, @NotNull String scriptUri, int tokenPos, CompletableFuture<String> fileFuture) {
        if (isolateId == null) {
            FlutterPositionMapper.$$$reportNull$$$0(16);
        }
        if (scriptId == null) {
            FlutterPositionMapper.$$$reportNull$$$0(17);
        }
        if (scriptUri == null) {
            FlutterPositionMapper.$$$reportNull$$$0(18);
        }
        if (this.scriptProvider == null) {
            FlutterUtils.warn(LOG, "attempted to get source position before connected to observatory");
            return null;
        }
        VirtualFile local = this.findLocalFile(scriptUri, fileFuture);
        ObservatoryFile.Cache cache = this.fileCache.computeIfAbsent(isolateId, id -> new ObservatoryFile.Cache((String)id, this.scriptProvider));
        ObservatoryFile remote = cache.downloadOrGet(scriptId, local == null);
        if (remote == null) {
            return null;
        }
        return remote.createPosition(local, tokenPos);
    }

    @VisibleForTesting
    @Nullable
    String getRemoteSourceRoot() {
        return this.remoteSourceRoot;
    }

    @Nullable
    private VirtualFile findLocalFile(@NotNull ScriptRef scriptRef) {
        if (scriptRef == null) {
            FlutterPositionMapper.$$$reportNull$$$0(19);
        }
        return this.findLocalFile(scriptRef.getUri());
    }

    @Nullable
    private VirtualFile findLocalFile(@NotNull Script script) {
        if (script == null) {
            FlutterPositionMapper.$$$reportNull$$$0(20);
        }
        return this.findLocalFile(script.getUri());
    }

    @Nullable
    protected VirtualFile findLocalFile(@NotNull String uri) {
        if (uri == null) {
            FlutterPositionMapper.$$$reportNull$$$0(21);
        }
        return this.findLocalFile(uri, null);
    }

    @Nullable
    protected VirtualFile findLocalFile(@NotNull String uri, CompletableFuture<String> fileFuture) {
        if (uri == null) {
            FlutterPositionMapper.$$$reportNull$$$0(22);
        }
        return (VirtualFile)ApplicationManager.getApplication().runReadAction(() -> {
            String path;
            if (this.remoteSourceRoot != null && uri.startsWith(this.remoteSourceRoot)) {
                String rootUri = StringUtil.trimEnd((String)this.resolver.getDartUrlForFile(this.sourceRoot), (char)'/');
                String suffix = uri.substring(this.remoteSourceRoot.length());
                return this.resolver.findFileByDartUrl(rootUri + suffix);
            }
            if (this.remoteBaseUri != null && uri.startsWith(this.remoteBaseUri)) {
                String rootUri = StringUtil.trimEnd((String)this.resolver.getDartUrlForFile(this.sourceRoot), (char)'/');
                String suffix = uri.substring(this.remoteBaseUri.length());
                return this.resolver.findFileByDartUrl(rootUri + suffix);
            }
            String remoteUri = uri.startsWith("/") ? new File(uri).toURI().toString() : uri;
            if (this.analyzer != null && !FlutterPositionMapper.isDartPatchUri(remoteUri) && (path = this.analyzer.getAbsolutePath(remoteUri)) != null) {
                if (fileFuture != null && WorkspaceCache.getInstance(this.project).isBazel() && path.contains("google3")) {
                    Analytics analytics = FlutterInitializer.getAnalytics();
                    try {
                        String vmServiceFilePath = (String)fileFuture.get(1000L, TimeUnit.MILLISECONDS);
                        if (!path.equals(vmServiceFilePath)) {
                            analytics.sendEvent("file-mapping", String.format("mismatch|%s|%s", path, vmServiceFilePath));
                        }
                    }
                    catch (Exception e) {
                        analytics.sendEvent("file-mapping", String.format("exception|%s|%s", path, e.getMessage()));
                    }
                }
                return LocalFileSystem.getInstance().findFileByPath(path);
            }
            return this.resolver.findFileByDartUrl(remoteUri);
        });
    }

    @NotNull
    private static String threeSlashize(@NotNull String uri) {
        if (uri == null) {
            FlutterPositionMapper.$$$reportNull$$$0(23);
        }
        if (!uri.startsWith("file:")) {
            String string = uri;
            if (string == null) {
                FlutterPositionMapper.$$$reportNull$$$0(24);
            }
            return string;
        }
        if (uri.startsWith("file:///")) {
            String string = uri;
            if (string == null) {
                FlutterPositionMapper.$$$reportNull$$$0(25);
            }
            return string;
        }
        if (uri.startsWith("file://")) {
            String string = "file:///" + uri.substring("file://".length());
            if (string == null) {
                FlutterPositionMapper.$$$reportNull$$$0(26);
            }
            return string;
        }
        if (uri.startsWith("file:/")) {
            String string = "file:///" + uri.substring("file:/".length());
            if (string == null) {
                FlutterPositionMapper.$$$reportNull$$$0(27);
            }
            return string;
        }
        if (uri.startsWith("file:")) {
            String string = "file:///" + uri.substring("file:".length());
            if (string == null) {
                FlutterPositionMapper.$$$reportNull$$$0(28);
            }
            return string;
        }
        String string = uri;
        if (string == null) {
            FlutterPositionMapper.$$$reportNull$$$0(29);
        }
        return string;
    }

    private static boolean isDartPatchUri(@NotNull String uri) {
        if (uri == null) {
            FlutterPositionMapper.$$$reportNull$$$0(30);
        }
        return uri.startsWith("dart:_") || uri.startsWith("dart:") && uri.contains("-patch/");
    }

    @Override
    public void shutdown() {
        if (this.analyzer != null) {
            this.analyzer.close();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 7, 8, 24, 25, 26, 27, 28, 29 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceRoot";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolver";
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/run/FlutterPositionMapper";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraries";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: 
            case 11: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isolateId";
                break;
            }
            case 10: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptRef";
                break;
            }
            case 12: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "script";
                break;
            }
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptId";
                break;
            }
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptUri";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uri";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/run/FlutterPositionMapper";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getBreakpointUris";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "threeSlashize";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "onConnect";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "onLibrariesDownloaded";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getBreakpointUris";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getSourcePosition";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "findLocalFile";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "threeSlashize";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "isDartPatchUri";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 7, 8, 24, 25, 26, 27, 28, 29 -> new IllegalStateException(string);
        };
    }

    public static interface Analyzer {
        @Nullable
        public String getAbsolutePath(@NotNull String var1);

        @Nullable
        public String getUri(@NotNull String var1);

        public void close();

        @Nullable
        public static Analyzer create(@NotNull Project project, @NotNull VirtualFile sourceLocation) {
            DartAnalysisServerService service;
            if (project == null) {
                Analyzer.$$$reportNull$$$0(0);
            }
            if (sourceLocation == null) {
                Analyzer.$$$reportNull$$$0(1);
            }
            if (!(service = DartPlugin.getInstance().getAnalysisService(project)).serverReadyForRequest()) {
                FlutterUtils.warn(LOG, "Dart analysis server is not running. Some breakpoints may not work.");
                return null;
            }
            final String contextId = service.execution_createContext(sourceLocation.getPath());
            if (contextId == null) {
                FlutterUtils.warn(LOG, "Failed to get execution context from analysis server. Some breakpoints may not work.");
                return null;
            }
            return new Analyzer(){

                @Override
                @Nullable
                public String getAbsolutePath(@NotNull String dartUri) {
                    if (dartUri == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return service.execution_mapUri(contextId, null, dartUri);
                }

                @Override
                @Nullable
                public String getUri(@NotNull String absolutePath) {
                    if (absolutePath == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return service.execution_mapUri(contextId, absolutePath, null);
                }

                @Override
                public void close() {
                    service.execution_deleteContext(contextId);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "dartUri";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "absolutePath";
                            break;
                        }
                    }
                    objectArray2[1] = "io/flutter/run/FlutterPositionMapper$Analyzer$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "getAbsolutePath";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "getUri";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "sourceLocation";
                    break;
                }
            }
            objectArray[1] = "io/flutter/run/FlutterPositionMapper$Analyzer";
            objectArray[2] = "create";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

