/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.run;

import com.intellij.AppTopics;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.concurrency.JobScheduler;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.ide.actions.SaveAllAction;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileDocumentManagerListener;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.LightweightHint;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.lang.dart.psi.DartFile;
import icons.FlutterIcons;
import io.flutter.FlutterConstants;
import io.flutter.FlutterUtils;
import io.flutter.actions.FlutterAppAction;
import io.flutter.actions.ProjectActions;
import io.flutter.bazel.Workspace;
import io.flutter.bazel.WorkspaceCache;
import io.flutter.run.FlutterDevice;
import io.flutter.run.common.RunMode;
import io.flutter.run.daemon.FlutterApp;
import io.flutter.settings.FlutterSettings;
import io.flutter.utils.FlutterModuleUtils;
import io.flutter.utils.MostlySilentColoredProcessHandler;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JComponent;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlutterReloadManager {
    private static final Logger LOG = Logger.getInstance(FlutterReloadManager.class);
    private static final Map<String, NotificationGroup> toolWindowNotificationGroups = new HashMap<String, NotificationGroup>();
    @NotNull
    private final Project myProject;
    private Notification lastNotification;

    private static NotificationGroup getNotificationGroup(String toolWindowId) {
        if (!toolWindowNotificationGroups.containsKey(toolWindowId)) {
            NotificationGroup notificationGroup = NotificationGroup.toolWindowGroup((String)("Flutter " + toolWindowId), (String)toolWindowId, (boolean)false);
            toolWindowNotificationGroups.put(toolWindowId, notificationGroup);
        }
        return toolWindowNotificationGroups.get(toolWindowId);
    }

    public static void init(@NotNull Project project) {
        if (project == null) {
            FlutterReloadManager.$$$reportNull$$$0(0);
        }
        FlutterReloadManager.getInstance(project);
    }

    @Nullable
    public static FlutterReloadManager getInstance(@NotNull Project project) {
        if (project == null) {
            FlutterReloadManager.$$$reportNull$$$0(1);
        }
        return (FlutterReloadManager)project.getService(FlutterReloadManager.class);
    }

    private FlutterReloadManager(@NotNull Project project) {
        if (project == null) {
            FlutterReloadManager.$$$reportNull$$$0(2);
        }
        this.myProject = project;
        MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect((Disposable)project);
        connection.subscribe(AnActionListener.TOPIC, (Object)new AnActionListener(){
            @Nullable
            private Project eventProject;
            @Nullable
            private Editor eventEditor;

            public void beforeActionPerformed(@NotNull AnAction action, @NotNull DataContext dataContext, @NotNull AnActionEvent event) {
                if (action == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (dataContext == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (event == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (!(action instanceof SaveAllAction)) {
                    return;
                }
                try {
                    this.eventProject = event.getProject();
                    this.eventEditor = (Editor)CommonDataKeys.EDITOR.getData(event.getDataContext());
                }
                catch (Throwable t) {
                    LOG.warn("Exception from FlutterReloadManager", t);
                }
            }

            public void afterActionPerformed(@NotNull AnAction action, @NotNull DataContext dataContext, @NotNull AnActionEvent event) {
                if (action == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (dataContext == null) {
                    1.$$$reportNull$$$0(4);
                }
                if (event == null) {
                    1.$$$reportNull$$$0(5);
                }
                if (!(action instanceof SaveAllAction)) {
                    return;
                }
                if (FlutterReloadManager.this.myProject != this.eventProject) {
                    return;
                }
                try {
                    FlutterReloadManager.this.handleSaveAllNotification(this.eventEditor);
                }
                catch (Throwable t) {
                    FlutterUtils.warn(LOG, "Exception from hot reload on save", t);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "action";
                        break;
                    }
                    case 1: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "dataContext";
                        break;
                    }
                    case 2: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                }
                objectArray2[1] = "io/flutter/run/FlutterReloadManager$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "beforeActionPerformed";
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "afterActionPerformed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        connection.subscribe(AppTopics.FILE_DOCUMENT_SYNC, (Object)new FileDocumentManagerListener(){

            public void beforeAllDocumentsSaving() {
                if (!FlutterSettings.getInstance().isReloadOnSave()) {
                    return;
                }
                if (FlutterReloadManager.this.myProject.isDisposed()) {
                    return;
                }
                if (!FlutterModuleUtils.hasFlutterModule(FlutterReloadManager.this.myProject)) {
                    return;
                }
                boolean isModified = false;
                for (FileEditor fileEditor : FileEditorManager.getInstance((Project)FlutterReloadManager.this.myProject).getAllEditors()) {
                    if (!fileEditor.isModified()) continue;
                    isModified = true;
                    break;
                }
                if (!isModified) {
                    return;
                }
                ApplicationManager.getApplication().invokeLater(() -> {
                    Editor anEditor = (Editor)ApplicationManager.getApplication().runReadAction(() -> {
                        Editor someEditor = null;
                        for (Editor editor : EditorFactory.getInstance().getAllEditors()) {
                            if (editor.isDisposed() || editor.getProject() != FlutterReloadManager.this.myProject) continue;
                            PsiFile psiFile = PsiDocumentManager.getInstance((Project)FlutterReloadManager.this.myProject).getPsiFile(editor.getDocument());
                            if (psiFile instanceof DartFile && someEditor == null) {
                                someEditor = editor;
                            }
                            if (null == PsiTreeUtil.findChildOfType((PsiElement)psiFile, PsiErrorElement.class, (boolean)false) || editor.getDocument().getTextLength() == 0) continue;
                            return null;
                        }
                        return someEditor;
                    });
                    FlutterReloadManager.this.handleSaveAllNotification(anEditor);
                }, ModalityState.any());
            }
        });
    }

    private void handleSaveAllNotification(@Nullable Editor editor) {
        VirtualFile file;
        if (!FlutterSettings.getInstance().isReloadOnSave() || editor == null) {
            return;
        }
        @NotNull String configPath = PathManager.getConfigDir().toString();
        if (SystemInfo.isWindows) {
            configPath = configPath.replace('\\', '/');
        }
        if ((file = FileDocumentManager.getInstance().getFile(editor.getDocument())) == null) {
            return;
        }
        if (file.getPath().startsWith(configPath.toString())) {
            return;
        }
        if (System.currentTimeMillis() - file.getTimeStamp() > 500L) {
            return;
        }
        AnAction reloadAction = ProjectActions.getAction(this.myProject, "Flutter.ReloadFlutterApp");
        FlutterApp app = this.getApp(reloadAction);
        if (app == null) {
            return;
        }
        if (!app.getLaunchMode().supportsReload() || !app.appSupportsHotReload()) {
            return;
        }
        if (!app.isStarted() || app.isReloading()) {
            return;
        }
        FlutterApp.State previousAppState = app.transitionStartingHotReload();
        JobScheduler.getScheduler().schedule(() -> {
            if (WorkspaceCache.getInstance(this.myProject).isBazel()) {
                this.syncFiles();
            }
            this.clearLastNotification();
            if (!app.isConnected()) {
                return;
            }
            if (this.hasErrorsInFile(editor.getDocument())) {
                app.cancelHotReloadState(previousAppState);
                this.showAnalysisNotification("Reload not performed", "Analysis issues found", true);
                return;
            }
            Notification notification = this.showRunNotification(app, null, "Reloading\u2026", false);
            long startTime = System.currentTimeMillis();
            app.performHotReload(true, FlutterConstants.RELOAD_REASON_SAVE).thenAccept(result -> {
                if (!result.ok()) {
                    notification.expire();
                    this.showRunNotification(app, "Hot Reload Error", result.getMessage(), true);
                } else {
                    long delay = Math.max(0L, 2000L - (System.currentTimeMillis() - startTime));
                    JobScheduler.getScheduler().schedule(() -> UIUtil.invokeLaterIfNeeded(() -> {
                        notification.expire();
                        if (this.isLastNotification(notification)) {
                            this.removeRunNotifications(app);
                        }
                    }), delay, TimeUnit.MILLISECONDS);
                }
            });
        }, 0L, TimeUnit.MILLISECONDS);
    }

    private void syncFiles() {
        Workspace workspace = WorkspaceCache.getInstance(this.myProject).get();
        assert (workspace != null);
        String script = workspace.getRoot().getPath() + "/" + workspace.getSyncScript();
        GeneralCommandLine commandLine = new GeneralCommandLine().withWorkDirectory(workspace.getRoot().getPath());
        commandLine.setCharset(StandardCharsets.UTF_8);
        commandLine.setExePath(FileUtil.toSystemDependentName((String)script));
        try {
            MostlySilentColoredProcessHandler handler = new MostlySilentColoredProcessHandler(commandLine);
            handler.startNotify();
            if (!handler.getProcess().waitFor(10L, TimeUnit.SECONDS)) {
                LOG.error("Syncing files timed out");
            }
        }
        catch (ExecutionException | InterruptedException e) {
            LOG.error("Unable to sync files: " + String.valueOf(e));
        }
    }

    private void reloadApp(@NotNull FlutterApp app, @NotNull String reason) {
        if (app == null) {
            FlutterReloadManager.$$$reportNull$$$0(3);
        }
        if (reason == null) {
            FlutterReloadManager.$$$reportNull$$$0(4);
        }
        if (app.isStarted()) {
            ((CompletableFuture)app.performHotReload(true, reason).thenAccept(result -> {
                if (!result.ok()) {
                    this.showRunNotification(app, "Hot Reload Error", result.getMessage(), true);
                }
            })).exceptionally(throwable -> {
                this.showRunNotification(app, "Hot Reload Error", throwable.getMessage(), true);
                return null;
            });
        }
    }

    public void saveAllAndReload(@NotNull FlutterApp app, @NotNull String reason) {
        if (app == null) {
            FlutterReloadManager.$$$reportNull$$$0(5);
        }
        if (reason == null) {
            FlutterReloadManager.$$$reportNull$$$0(6);
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        this.clearLastNotification();
        this.reloadApp(app, reason);
    }

    public void saveAllAndReloadAll(@NotNull List<FlutterApp> appsToReload, @NotNull String reason) {
        if (appsToReload == null) {
            FlutterReloadManager.$$$reportNull$$$0(7);
        }
        if (reason == null) {
            FlutterReloadManager.$$$reportNull$$$0(8);
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        this.clearLastNotification();
        for (FlutterApp app : appsToReload) {
            this.reloadApp(app, reason);
        }
    }

    private void restartApp(@NotNull FlutterApp app, @NotNull String reason) {
        if (app == null) {
            FlutterReloadManager.$$$reportNull$$$0(9);
        }
        if (reason == null) {
            FlutterReloadManager.$$$reportNull$$$0(10);
        }
        if (app.isStarted()) {
            ((CompletableFuture)app.performRestartApp(reason).thenAccept(result -> {
                if (!result.ok()) {
                    this.showRunNotification(app, "Hot Restart Error", result.getMessage(), true);
                }
            })).exceptionally(throwable -> {
                this.showRunNotification(app, "Hot Restart Error", throwable.getMessage(), true);
                return null;
            });
            FlutterDevice device = app.device();
            if (device != null) {
                device.bringToFront();
            }
        }
    }

    public void saveAllAndRestart(@NotNull FlutterApp app, @NotNull String reason) {
        if (app == null) {
            FlutterReloadManager.$$$reportNull$$$0(11);
        }
        if (reason == null) {
            FlutterReloadManager.$$$reportNull$$$0(12);
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        this.clearLastNotification();
        this.restartApp(app, reason);
    }

    public void saveAllAndRestartAll(@NotNull List<FlutterApp> appsToRestart, @NotNull String reason) {
        if (appsToRestart == null) {
            FlutterReloadManager.$$$reportNull$$$0(13);
        }
        if (reason == null) {
            FlutterReloadManager.$$$reportNull$$$0(14);
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        this.clearLastNotification();
        for (FlutterApp app : appsToRestart) {
            this.restartApp(app, reason);
        }
    }

    @Nullable
    private FlutterApp getApp(AnAction reloadAction) {
        if (reloadAction instanceof FlutterAppAction) {
            return ((FlutterAppAction)reloadAction).getApp();
        }
        return null;
    }

    private void showAnalysisNotification(@NotNull String title, @NotNull String content, boolean isError) {
        ToolWindow dartProblemsView;
        if (title == null) {
            FlutterReloadManager.$$$reportNull$$$0(15);
        }
        if (content == null) {
            FlutterReloadManager.$$$reportNull$$$0(16);
        }
        if ((dartProblemsView = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow("Dart Analysis")) != null && !dartProblemsView.isVisible()) {
            content = (String)content + " (<a href='open.analysis.view'>view issues</a>)";
        }
        NotificationGroup notificationGroup = FlutterReloadManager.getNotificationGroup("Dart Analysis");
        Notification notification = notificationGroup.createNotification(title, (String)content, isError ? NotificationType.ERROR : NotificationType.INFORMATION, (NotificationListener)new NotificationListener.Adapter(){

            protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent e) {
                if (notification == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (e == null) {
                    3.$$$reportNull$$$0(1);
                }
                notification.expire();
                ToolWindow dartProblemsView = ToolWindowManager.getInstance((Project)FlutterReloadManager.this.myProject).getToolWindow("Dart Analysis");
                if (dartProblemsView != null) {
                    dartProblemsView.activate(null);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "notification";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "e";
                        break;
                    }
                }
                objectArray[1] = "io/flutter/run/FlutterReloadManager$3";
                objectArray[2] = "hyperlinkActivated";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        notification.setIcon(FlutterIcons.Flutter);
        notification.notify(this.myProject);
        this.lastNotification = notification;
    }

    private Notification showRunNotification(@NotNull FlutterApp app, @Nullable String title, @NotNull String content, boolean isError) {
        if (app == null) {
            FlutterReloadManager.$$$reportNull$$$0(17);
        }
        if (content == null) {
            FlutterReloadManager.$$$reportNull$$$0(18);
        }
        String toolWindowId = app.getMode() == RunMode.DEBUG ? "Debug" : "Run";
        NotificationGroup notificationGroup = FlutterReloadManager.getNotificationGroup(toolWindowId);
        Notification notification = title == null ? notificationGroup.createNotification(content, isError ? NotificationType.ERROR : NotificationType.INFORMATION) : notificationGroup.createNotification(title, content, isError ? NotificationType.ERROR : NotificationType.INFORMATION, null);
        notification.setIcon(FlutterIcons.Flutter);
        notification.notify(this.myProject);
        this.lastNotification = notification;
        return notification;
    }

    private boolean isLastNotification(Notification notification) {
        return notification == this.lastNotification;
    }

    private void clearLastNotification() {
        this.lastNotification = null;
    }

    private void removeRunNotifications(FlutterApp app) {
        String toolWindowId = app.getMode() == RunMode.DEBUG ? "Debug" : "Run";
        Balloon balloon = ToolWindowManager.getInstance((Project)this.myProject).getToolWindowBalloon(toolWindowId);
        if (balloon != null) {
            balloon.hide();
        }
    }

    private boolean hasErrorsInFile(@NotNull Document document) {
        PsiErrorElement firstError;
        if (document == null) {
            FlutterReloadManager.$$$reportNull$$$0(19);
        }
        return (firstError = (PsiErrorElement)ApplicationManager.getApplication().runReadAction(() -> {
            PsiFile psiFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(document);
            if (psiFile instanceof DartFile) {
                return (PsiErrorElement)PsiTreeUtil.findChildOfType((PsiElement)psiFile, PsiErrorElement.class, (boolean)false);
            }
            return null;
        })) != null;
    }

    private LightweightHint showEditorHint(@NotNull Editor editor, String message, boolean isError) {
        if (editor == null) {
            FlutterReloadManager.$$$reportNull$$$0(20);
        }
        AtomicReference ref = new AtomicReference();
        ApplicationManager.getApplication().invokeAndWait(() -> {
            JComponent component = isError ? HintUtil.createErrorLabel((String)message) : HintUtil.createInformationLabel((String)message);
            LightweightHint hint = new LightweightHint(component);
            ref.set(hint);
            HintManagerImpl.getInstanceImpl().showEditorHint(hint, editor, (short)2, 58, isError ? 0 : 3000, false);
        });
        return (LightweightHint)ref.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 5: 
            case 9: 
            case 11: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "app";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reason";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appsToReload";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appsToRestart";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        objectArray2[1] = "io/flutter/run/FlutterReloadManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "init";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getInstance";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "reloadApp";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "saveAllAndReload";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "saveAllAndReloadAll";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "restartApp";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "saveAllAndRestart";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "saveAllAndRestartAll";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "showAnalysisNotification";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "showRunNotification";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "hasErrorsInFile";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "showEditorHint";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

