/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.run;

import com.intellij.ide.browsers.BrowserLauncher;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import icons.FlutterIcons;
import io.flutter.FlutterInitializer;
import io.flutter.ObservatoryConnector;
import io.flutter.bazel.WorkspaceCache;
import io.flutter.devtools.DevToolsIdeFeature;
import io.flutter.devtools.DevToolsUrl;
import io.flutter.run.daemon.DevToolsService;
import io.flutter.run.daemon.FlutterApp;
import io.flutter.sdk.FlutterSdk;
import io.flutter.utils.AsyncUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OpenDevToolsAction
extends DumbAwareAction {
    private static final Logger LOG = Logger.getInstance(OpenDevToolsAction.class);
    private static final String title = "Open Flutter DevTools";
    @Nullable
    private final ObservatoryConnector myConnector;
    private final Computable<Boolean> myIsApplicable;

    public OpenDevToolsAction() {
        this.myConnector = null;
        this.myIsApplicable = null;
    }

    public OpenDevToolsAction(@NotNull FlutterApp app, @NotNull Computable<Boolean> isApplicable) {
        if (app == null) {
            OpenDevToolsAction.$$$reportNull$$$0(0);
        }
        if (isApplicable == null) {
            OpenDevToolsAction.$$$reportNull$$$0(1);
        }
        this(app.getConnector(), isApplicable);
    }

    public OpenDevToolsAction(@NotNull ObservatoryConnector connector, @NotNull Computable<Boolean> isApplicable) {
        if (connector == null) {
            OpenDevToolsAction.$$$reportNull$$$0(2);
        }
        if (isApplicable == null) {
            OpenDevToolsAction.$$$reportNull$$$0(3);
        }
        super(title, title, FlutterIcons.Dart_16);
        this.myConnector = connector;
        this.myIsApplicable = isApplicable;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            OpenDevToolsAction.$$$reportNull$$$0(4);
        }
        if (this.myIsApplicable == null) {
            e.getPresentation().setEnabled(true);
        } else {
            e.getPresentation().setEnabled(((Boolean)this.myIsApplicable.compute()).booleanValue());
        }
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        if (event == null) {
            OpenDevToolsAction.$$$reportNull$$$0(5);
        }
        FlutterInitializer.sendAnalyticsAction((AnAction)this);
        Project project = event.getProject();
        if (project == null) {
            return;
        }
        AsyncUtils.whenCompleteUiThread(DevToolsService.getInstance(project).getDevToolsInstance(), (instance, ex) -> {
            if (project.isDisposed()) {
                return;
            }
            if (ex != null) {
                LOG.error(ex);
                return;
            }
            String serviceUrl = this.myConnector != null && this.myConnector.getBrowserUrl() != null ? this.myConnector.getBrowserUrl() : null;
            FlutterSdk flutterSdk = FlutterSdk.getFlutterSdk(project);
            BrowserLauncher.getInstance().browse(new DevToolsUrl(instance.host, instance.port, serviceUrl, null, false, null, null, flutterSdk == null ? null : flutterSdk.getVersion(), WorkspaceCache.getInstance(project), DevToolsIdeFeature.RUN_CONSOLE).getUrlString(), null);
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "app";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isApplicable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connector";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        objectArray2[1] = "io/flutter/run/OpenDevToolsAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

