/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.run;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.jetbrains.lang.dart.sdk.DartConfigurable;
import com.jetbrains.lang.dart.sdk.DartSdk;
import io.flutter.FlutterBundle;
import io.flutter.dart.DartPlugin;
import io.flutter.pub.PubRoot;
import io.flutter.run.AttachState;
import io.flutter.run.FlutterDevice;
import io.flutter.run.FlutterLaunchMode;
import io.flutter.run.LaunchState;
import io.flutter.run.MainFile;
import io.flutter.run.SdkFields;
import io.flutter.run.SdkRunConfig;
import io.flutter.run.common.RunMode;
import io.flutter.run.daemon.FlutterApp;
import io.flutter.sdk.FlutterSdkManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SdkAttachConfig
extends SdkRunConfig {
    public PubRoot pubRoot;

    public SdkAttachConfig(SdkRunConfig config) {
        super(config.getProject(), config.getFactory(), config.getName());
        this.setFields(config.getFields());
    }

    @Override
    @Nullable
    public RefactoringElementListener getRefactoringElementListener(PsiElement element) {
        return null;
    }

    @Override
    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        throw new IllegalStateException("Attach configurations are not editable");
    }

    @Override
    @NotNull
    public LaunchState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) throws ExecutionException {
        if (executor == null) {
            SdkAttachConfig.$$$reportNull$$$0(0);
        }
        if (env == null) {
            SdkAttachConfig.$$$reportNull$$$0(1);
        }
        try {
            this.checkRunnable(env.getProject());
        }
        catch (RuntimeConfigurationError e) {
            throw new ExecutionException((Throwable)e);
        }
        SdkFields launchFields = this.getFields();
        MainFile mainFile = MainFile.verify(launchFields.getFilePath(), env.getProject()).get();
        Project project = env.getProject();
        RunMode mode = RunMode.fromEnv(env);
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)mainFile.getFile(), (Project)env.getProject());
        LaunchState.CreateAppCallback createAppCallback = device -> {
            if (device == null) {
                return null;
            }
            GeneralCommandLine command = this.getCommand(env, device);
            final FlutterApp app = FlutterApp.start(env, project, module, mode, device, command, StringUtil.capitalize((String)mode.mode()) + "App", "StopApp");
            FlutterSdkManager.Listener sdkListener = new FlutterSdkManager.Listener(){

                @Override
                public void flutterSdkRemoved() {
                    app.shutdownAsync();
                }
            };
            FlutterSdkManager.getInstance(project).addListener(sdkListener);
            Disposer.register((Disposable)app, () -> FlutterSdkManager.getInstance(project).removeListener(sdkListener));
            return app;
        };
        AttachState launcher = new AttachState(env, mainFile.getAppDir(), mainFile.getFile(), this, createAppCallback);
        this.addConsoleFilters(launcher, env, mainFile, module);
        AttachState attachState = launcher;
        if (attachState == null) {
            SdkAttachConfig.$$$reportNull$$$0(2);
        }
        return attachState;
    }

    @Override
    @NotNull
    public GeneralCommandLine getCommand(@NotNull ExecutionEnvironment env, @NotNull FlutterDevice device) throws ExecutionException {
        if (env == null) {
            SdkAttachConfig.$$$reportNull$$$0(3);
        }
        if (device == null) {
            SdkAttachConfig.$$$reportNull$$$0(4);
        }
        GeneralCommandLine generalCommandLine = this.getFields().createFlutterSdkAttachCommand(env.getProject(), FlutterLaunchMode.fromEnv(env), device);
        if (generalCommandLine == null) {
            SdkAttachConfig.$$$reportNull$$$0(5);
        }
        return generalCommandLine;
    }

    private void checkRunnable(@NotNull Project project) throws RuntimeConfigurationError {
        DartSdk sdk;
        if (project == null) {
            SdkAttachConfig.$$$reportNull$$$0(6);
        }
        if ((sdk = DartPlugin.getDartSdk(project)) == null) {
            throw new RuntimeConfigurationError(FlutterBundle.message("dart.sdk.is.not.configured", new Object[0]), () -> DartConfigurable.openDartSettings((Project)project));
        }
        MainFile.Result main = MainFile.verify(this.getFields().getFilePath(), project);
        if (!main.canLaunch()) {
            throw new RuntimeConfigurationError(main.getError());
        }
        if (PubRoot.forDirectory(main.get().getAppDir()) == null) {
            throw new RuntimeConfigurationError("Entrypoint isn't within a Flutter pub root");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/run/SdkAttachConfig";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/run/SdkAttachConfig";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 2: 
            case 5: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getCommand";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "checkRunnable";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 5 -> new IllegalStateException(string);
        };
    }
}

