/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.run;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.util.xmlb.annotations.OptionTag;
import com.intellij.util.xmlb.annotations.XMap;
import com.jetbrains.lang.dart.sdk.DartConfigurable;
import com.jetbrains.lang.dart.sdk.DartSdk;
import io.flutter.FlutterBundle;
import io.flutter.FlutterInitializer;
import io.flutter.dart.DartPlugin;
import io.flutter.pub.PubRoot;
import io.flutter.pub.PubRootCache;
import io.flutter.run.FlutterDevice;
import io.flutter.run.FlutterLaunchMode;
import io.flutter.run.MainFile;
import io.flutter.run.common.RunMode;
import io.flutter.run.daemon.DevToolsInstance;
import io.flutter.run.daemon.DevToolsService;
import io.flutter.sdk.FlutterCommand;
import io.flutter.sdk.FlutterSdk;
import io.flutter.settings.FlutterSettings;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SdkFields {
    private static final Logger LOG = Logger.getInstance(SdkFields.class);
    @Nullable
    private String filePath;
    @Nullable
    private String buildFlavor;
    @Nullable
    private String additionalArgs;
    @Nullable
    private String attachArgs;
    @NotNull
    private Map<String, String> envs = new LinkedHashMap<String, String>();

    public SdkFields() {
    }

    public SdkFields(VirtualFile launchFile) {
        this.filePath = launchFile.getPath();
    }

    @Nullable
    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(@Nullable String path) {
        this.filePath = path;
    }

    @Nullable
    public String getBuildFlavor() {
        return this.buildFlavor;
    }

    public void setBuildFlavor(@Nullable String buildFlavor) {
        this.buildFlavor = buildFlavor;
    }

    @Nullable
    public String getAdditionalArgs() {
        return this.additionalArgs;
    }

    public void setAdditionalArgs(@Nullable String additionalArgs) {
        this.additionalArgs = additionalArgs;
    }

    public boolean hasAdditionalArgs() {
        return this.additionalArgs != null;
    }

    public String[] getAdditionalArgsParsed() {
        if (this.hasAdditionalArgs()) {
            assert (this.additionalArgs != null);
            return ParametersListUtil.parse((String)this.additionalArgs, (boolean)false, (boolean)true, (boolean)true).toArray(new String[0]);
        }
        return new String[0];
    }

    @Nullable
    public String getAttachArgs() {
        return this.attachArgs;
    }

    public void setAttachArgs(@Nullable String attachArgs) {
        this.attachArgs = attachArgs;
    }

    public boolean hasAttachArgs() {
        return this.attachArgs != null;
    }

    public String[] getAttachArgsParsed() {
        if (this.hasAttachArgs()) {
            assert (this.attachArgs != null);
            return ParametersListUtil.parse((String)this.attachArgs, (boolean)false, (boolean)true, (boolean)true).toArray(new String[0]);
        }
        return new String[0];
    }

    @Deprecated
    @Nullable
    public String getWorkingDirectory() {
        return null;
    }

    @Deprecated
    public void setWorkingDirectory(@Nullable String dir) {
    }

    @OptionTag
    @XMap
    @NotNull
    public Map<String, String> getEnvs() {
        Map<String, String> map = this.envs;
        if (map == null) {
            SdkFields.$$$reportNull$$$0(0);
        }
        return map;
    }

    public void setEnvs(Map<String, String> envs) {
        if (envs != null) {
            this.envs = envs;
        }
    }

    void checkRunnable(@NotNull Project project) throws RuntimeConfigurationError {
        if (project == null) {
            SdkFields.$$$reportNull$$$0(1);
        }
        SdkFields.checkSdk(project);
        MainFile.Result main = MainFile.verify(this.filePath, project);
        if (!main.canLaunch()) {
            throw new RuntimeConfigurationError(main.getError());
        }
        if (PubRootCache.getInstance(project).getRoot(main.get().getAppDir()) == null) {
            throw new RuntimeConfigurationError("Entrypoint isn't within a Flutter pub root");
        }
    }

    public GeneralCommandLine createFlutterSdkRunCommand(@NotNull Project project, @NotNull RunMode runMode, @NotNull FlutterLaunchMode flutterLaunchMode, @NotNull FlutterDevice device, boolean firstRun) throws ExecutionException {
        if (project == null) {
            SdkFields.$$$reportNull$$$0(2);
        }
        if (runMode == null) {
            SdkFields.$$$reportNull$$$0(3);
        }
        if (flutterLaunchMode == null) {
            SdkFields.$$$reportNull$$$0(4);
        }
        if (device == null) {
            SdkFields.$$$reportNull$$$0(5);
        }
        MainFile main = MainFile.verify(this.filePath, project).get();
        FlutterSdk flutterSdk = FlutterSdk.getFlutterSdk(project);
        if (flutterSdk == null) {
            throw new ExecutionException(FlutterBundle.message("flutter.sdk.is.not.configured", new Object[0]));
        }
        PubRoot root = PubRoot.forDirectory(main.getAppDir());
        if (root == null) {
            throw new ExecutionException("Entrypoint isn't within a Flutter pub root");
        }
        Object[] args = this.getAdditionalArgsParsed();
        if (this.buildFlavor != null) {
            args = (String[])ArrayUtil.append((Object[])args, (Object)("--flavor=" + this.buildFlavor));
        }
        if (FlutterSettings.getInstance().isShowStructuredErrors() && flutterSdk.getVersion().isDartDefineSupported()) {
            args = (String[])ArrayUtil.append((Object[])args, (Object)"--dart-define=flutter.inspector.structuredErrors=true");
        }
        if (flutterSdk.getVersion().flutterRunSupportsDevToolsUrl()) {
            try {
                ProgressManager progress = ProgressManager.getInstance();
                CompletableFuture devToolsFuture = new CompletableFuture();
                progress.runProcessWithProgressSynchronously(() -> {
                    progress.getProgressIndicator().setIndeterminate(true);
                    try {
                        CompletableFuture<DevToolsInstance> futureInstance = DevToolsService.getInstance(project).getDevToolsInstance();
                        if (firstRun) {
                            devToolsFuture.complete(futureInstance.get(30L, TimeUnit.SECONDS));
                        } else {
                            DevToolsInstance instance = futureInstance.getNow(null);
                            if (instance == null) {
                                devToolsFuture.completeExceptionally(new Exception("DevTools instance not available after first run."));
                            } else {
                                devToolsFuture.complete(instance);
                            }
                        }
                    }
                    catch (Exception e) {
                        devToolsFuture.completeExceptionally(e);
                    }
                }, "Starting DevTools", false, project);
                DevToolsInstance instance = (DevToolsInstance)devToolsFuture.get();
                args = (String[])ArrayUtil.append((Object[])args, (Object)("--devtools-server-address=http://" + instance.host + ":" + instance.port));
                if (firstRun) {
                    FlutterInitializer.getAnalytics().sendEvent("devtools", "first-run-success");
                }
            }
            catch (Exception e) {
                LOG.info((Throwable)e);
                FlutterInitializer.getAnalytics().sendExpectedException("devtools", e);
            }
        }
        FlutterCommand command = flutterSdk.flutterRun(root, main.getFile(), device, runMode, flutterLaunchMode, project, (String[])args);
        GeneralCommandLine commandLine = command.createGeneralCommandLine(project);
        commandLine.getEnvironment().putAll(this.getEnvs());
        commandLine.withParentEnvironmentType(GeneralCommandLine.ParentEnvironmentType.CONSOLE);
        return commandLine;
    }

    public GeneralCommandLine createFlutterSdkAttachCommand(@NotNull Project project, @NotNull FlutterLaunchMode flutterLaunchMode, @Nullable FlutterDevice device) throws ExecutionException {
        if (project == null) {
            SdkFields.$$$reportNull$$$0(6);
        }
        if (flutterLaunchMode == null) {
            SdkFields.$$$reportNull$$$0(7);
        }
        MainFile main = MainFile.verify(this.filePath, project).get();
        FlutterSdk flutterSdk = FlutterSdk.getFlutterSdk(project);
        if (flutterSdk == null) {
            throw new ExecutionException(FlutterBundle.message("flutter.sdk.is.not.configured", new Object[0]));
        }
        PubRoot root = PubRoot.forDirectory(main.getAppDir());
        if (root == null) {
            throw new ExecutionException("Entrypoint isn't within a Flutter pub root");
        }
        String[] args = this.getAttachArgsParsed();
        FlutterCommand command = flutterSdk.flutterAttach(root, main.getFile(), device, flutterLaunchMode, args);
        return command.createGeneralCommandLine(project);
    }

    SdkFields copy() {
        SdkFields copy = new SdkFields();
        copy.setFilePath(this.filePath);
        copy.setAdditionalArgs(this.additionalArgs);
        copy.setBuildFlavor(this.buildFlavor);
        copy.envs.putAll(this.envs);
        return copy;
    }

    private static void checkSdk(@NotNull Project project) throws RuntimeConfigurationError {
        DartSdk sdk;
        if (project == null) {
            SdkFields.$$$reportNull$$$0(8);
        }
        if ((sdk = DartPlugin.getDartSdk(project)) == null) {
            throw new RuntimeConfigurationError(FlutterBundle.message("dart.sdk.is.not.configured", new Object[0]), () -> DartConfigurable.openDartSettings((Project)project));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/run/SdkFields";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runMode";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flutterLaunchMode";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnvs";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/run/SdkFields";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "checkRunnable";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createFlutterSdkRunCommand";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createFlutterSdkAttachCommand";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "checkSdk";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8 -> new IllegalArgumentException(string);
        };
    }
}

