/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.run;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.LocatableConfigurationBase;
import com.intellij.execution.configurations.RefactoringListenerProvider;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.filters.UrlFilter;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.RunConfigurationWithSuppressedDefaultRunAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.listeners.UndoRefactoringElementAdapter;
import com.intellij.util.PathUtil;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultValuesSerializationFilters;
import com.intellij.util.xmlb.XmlSerializer;
import com.jetbrains.lang.dart.ide.runner.DartConsoleFilter;
import io.flutter.FlutterUtils;
import io.flutter.console.FlutterConsoleFilter;
import io.flutter.run.FlutterConfigurationEditorForm;
import io.flutter.run.FlutterDevice;
import io.flutter.run.FlutterLaunchMode;
import io.flutter.run.LaunchState;
import io.flutter.run.MainFile;
import io.flutter.run.SdkFields;
import io.flutter.run.common.RunMode;
import io.flutter.run.daemon.FlutterApp;
import io.flutter.sdk.FlutterSdkManager;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SdkRunConfig
extends LocatableConfigurationBase<LaunchState>
implements LaunchState.RunConfig,
RefactoringListenerProvider,
RunConfigurationWithSuppressedDefaultRunAction {
    private static final Logger LOG = Logger.getInstance(SdkRunConfig.class);
    private boolean firstRun;
    @NotNull
    private SdkFields fields;

    public SdkRunConfig(@NotNull Project project, @NotNull ConfigurationFactory factory, @NotNull String name) {
        if (project == null) {
            SdkRunConfig.$$$reportNull$$$0(0);
        }
        if (factory == null) {
            SdkRunConfig.$$$reportNull$$$0(1);
        }
        if (name == null) {
            SdkRunConfig.$$$reportNull$$$0(2);
        }
        super(project, factory, name);
        this.firstRun = true;
        this.fields = new SdkFields();
    }

    @NotNull
    public SdkFields getFields() {
        SdkFields sdkFields = this.fields;
        if (sdkFields == null) {
            SdkRunConfig.$$$reportNull$$$0(3);
        }
        return sdkFields;
    }

    public void setFields(@NotNull SdkFields newFields) {
        if (newFields == null) {
            SdkRunConfig.$$$reportNull$$$0(4);
        }
        this.fields = newFields;
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        this.fields.checkRunnable(this.getProject());
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        return new FlutterConfigurationEditorForm(this.getProject());
    }

    @Override
    @NotNull
    public LaunchState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) throws ExecutionException {
        if (executor == null) {
            SdkRunConfig.$$$reportNull$$$0(5);
        }
        if (env == null) {
            SdkRunConfig.$$$reportNull$$$0(6);
        }
        SdkFields launchFields = this.fields.copy();
        try {
            launchFields.checkRunnable(env.getProject());
        }
        catch (RuntimeConfigurationError e) {
            throw new ExecutionException((Throwable)e);
        }
        MainFile mainFile = MainFile.verify(launchFields.getFilePath(), env.getProject()).get();
        Project project = env.getProject();
        RunMode mode = RunMode.fromEnv(env);
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)mainFile.getFile(), (Project)env.getProject());
        LaunchState.CreateAppCallback createAppCallback = device -> {
            if (device == null) {
                return null;
            }
            GeneralCommandLine command = this.getCommand(env, device);
            Path buildPath = command.getWorkDirectory().toPath().resolve("build");
            Path cachedParametersPath = buildPath.resolve("last_build_run.json");
            String[] parametersToTrack = new String[]{"--preview-dart-2", "--track-widget-creation"};
            JsonArray jsonArray = new JsonArray();
            block4: for (String parameter : command.getParametersList().getList()) {
                for (String allowedParameter : parametersToTrack) {
                    if (!parameter.startsWith(allowedParameter)) continue;
                    jsonArray.add((JsonElement)new JsonPrimitive(parameter));
                    continue block4;
                }
            }
            String json = new Gson().toJson((JsonElement)jsonArray);
            String existingJson = null;
            if (Files.exists(cachedParametersPath, new LinkOption[0])) {
                try {
                    existingJson = new String(Files.readAllBytes(cachedParametersPath), StandardCharsets.UTF_8);
                }
                catch (IOException e) {
                    FlutterUtils.warn(LOG, "Unable to get existing json from " + String.valueOf(cachedParametersPath));
                }
            }
            if (!StringUtil.equals((CharSequence)json, existingJson)) {
                try {
                    if (Files.exists(buildPath, new LinkOption[0])) {
                        if (Files.isDirectory(buildPath, new LinkOption[0])) {
                            Files.walkFileTree(buildPath, new RecursiveDeleter("*.{fingerprint,dill}"));
                        }
                    } else {
                        Files.createDirectory(buildPath, new FileAttribute[0]);
                    }
                    Files.write(cachedParametersPath, json.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                }
                catch (IOException e) {
                    FlutterUtils.warn(LOG, e);
                }
            }
            final FlutterApp app = FlutterApp.start(env, project, module, mode, device, command, StringUtil.capitalize((String)mode.mode()) + "App", "StopApp");
            FlutterSdkManager.Listener sdkListener = new FlutterSdkManager.Listener(){

                @Override
                public void flutterSdkRemoved() {
                    app.shutdownAsync();
                }
            };
            FlutterSdkManager.getInstance(project).addListener(sdkListener);
            Disposer.register((Disposable)app, () -> FlutterSdkManager.getInstance(project).removeListener(sdkListener));
            return app;
        };
        LaunchState launcher = new LaunchState(env, mainFile.getAppDir(), mainFile.getFile(), this, createAppCallback);
        this.addConsoleFilters(launcher, env, mainFile, module);
        LaunchState launchState = launcher;
        if (launchState == null) {
            SdkRunConfig.$$$reportNull$$$0(7);
        }
        return launchState;
    }

    protected void addConsoleFilters(@NotNull LaunchState launcher, @NotNull ExecutionEnvironment env, @NotNull MainFile mainFile, @Nullable Module module) {
        if (launcher == null) {
            SdkRunConfig.$$$reportNull$$$0(8);
        }
        if (env == null) {
            SdkRunConfig.$$$reportNull$$$0(9);
        }
        if (mainFile == null) {
            SdkRunConfig.$$$reportNull$$$0(10);
        }
        TextConsoleBuilder builder = launcher.getConsoleBuilder();
        builder.addFilter((Filter)new DartConsoleFilter(env.getProject(), mainFile.getFile()));
        if (module != null) {
            builder.addFilter((Filter)new FlutterConsoleFilter(module));
        }
        builder.addFilter((Filter)new UrlFilter());
    }

    @Override
    @NotNull
    public GeneralCommandLine getCommand(@NotNull ExecutionEnvironment env, @NotNull FlutterDevice device) throws ExecutionException {
        if (env == null) {
            SdkRunConfig.$$$reportNull$$$0(11);
        }
        if (device == null) {
            SdkRunConfig.$$$reportNull$$$0(12);
        }
        SdkFields launchFields = this.fields.copy();
        Project project = env.getProject();
        RunMode mode = RunMode.fromEnv(env);
        boolean initialFirstRun = this.firstRun;
        this.firstRun = false;
        GeneralCommandLine generalCommandLine = this.fields.createFlutterSdkRunCommand(project, mode, FlutterLaunchMode.fromEnv(env), device, initialFirstRun);
        if (generalCommandLine == null) {
            SdkRunConfig.$$$reportNull$$$0(13);
        }
        return generalCommandLine;
    }

    @Nullable
    public String suggestedName() {
        String filePath = this.fields.getFilePath();
        return filePath == null ? null : PathUtil.getFileName((String)filePath);
    }

    public SdkRunConfig clone() {
        SdkRunConfig clone = (SdkRunConfig)super.clone();
        clone.fields = this.fields.copy();
        return clone;
    }

    public void writeExternal(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            SdkRunConfig.$$$reportNull$$$0(14);
        }
        super.writeExternal(element);
        XmlSerializer.serializeInto((Object)this.getFields(), (Element)element, (SerializationFilter)new SkipDefaultValuesSerializationFilters());
    }

    public void readExternal(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            SdkRunConfig.$$$reportNull$$$0(15);
        }
        super.readExternal(element);
        XmlSerializer.deserializeInto((Object)this.getFields(), (Element)element);
    }

    @Nullable
    public RefactoringElementListener getRefactoringElementListener(PsiElement element) {
        String filePath = this.getFields().getFilePath();
        if (filePath == null) {
            return null;
        }
        String affectedPath = this.getAffectedPath(element);
        if (affectedPath == null) {
            return null;
        }
        if (element instanceof PsiFile && filePath.equals(affectedPath)) {
            return new RenameRefactoringListener(affectedPath);
        }
        if (element instanceof PsiDirectory && filePath.startsWith(affectedPath + "/")) {
            return new RenameRefactoringListener(affectedPath);
        }
        return null;
    }

    private String getAffectedPath(PsiElement element) {
        if (!(element instanceof PsiFileSystemItem)) {
            return null;
        }
        VirtualFile file = ((PsiFileSystemItem)element).getVirtualFile();
        return file == null ? null : file.getPath();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 7, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: 
            case 7: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/run/SdkRunConfig";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newFields";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 6: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "launcher";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mainFile";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/run/SdkRunConfig";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFields";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 7: 
            case 13: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setFields";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addConsoleFilters";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getCommand";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 7, 13 -> new IllegalStateException(string);
        };
    }

    private class RenameRefactoringListener
    extends UndoRefactoringElementAdapter {
        @NotNull
        private String myAffectedPath;

        private RenameRefactoringListener(String affectedPath) {
            if (affectedPath == null) {
                RenameRefactoringListener.$$$reportNull$$$0(0);
            }
            this.myAffectedPath = affectedPath;
        }

        private String getNewPathAndUpdateAffectedPath(@NotNull PsiElement newElement) {
            VirtualFile newFile;
            if (newElement == null) {
                RenameRefactoringListener.$$$reportNull$$$0(1);
            }
            String oldPath = SdkRunConfig.this.fields.getFilePath();
            VirtualFile virtualFile = newFile = newElement instanceof PsiFileSystemItem ? ((PsiFileSystemItem)newElement).getVirtualFile() : null;
            if (newFile != null && oldPath != null && oldPath.startsWith(this.myAffectedPath)) {
                String newPath = newFile.getPath() + oldPath.substring(this.myAffectedPath.length());
                this.myAffectedPath = newFile.getPath();
                return newPath;
            }
            return oldPath;
        }

        protected void refactored(@NotNull PsiElement element, @Nullable String oldQualifiedName) {
            if (element == null) {
                RenameRefactoringListener.$$$reportNull$$$0(2);
            }
            boolean generatedName = SdkRunConfig.this.getName().equals(SdkRunConfig.this.suggestedName());
            String filePath = SdkRunConfig.this.fields.getFilePath();
            String newPath = this.getNewPathAndUpdateAffectedPath(element);
            SdkRunConfig.this.fields.setFilePath(newPath);
            if (generatedName) {
                SdkRunConfig.this.setGeneratedName();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "affectedPath";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newElement";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            objectArray2[1] = "io/flutter/run/SdkRunConfig$RenameRefactoringListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getNewPathAndUpdateAffectedPath";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "refactored";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class RecursiveDeleter
    extends SimpleFileVisitor<Path> {
        private final PathMatcher matcher;

        RecursiveDeleter(String pattern) {
            this.matcher = FileSystems.getDefault().getPathMatcher("glob:" + pattern);
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
            Path name = file.getFileName();
            if (name != null && this.matcher.matches(name)) {
                try {
                    Files.delete(file);
                }
                catch (IOException e) {
                    FlutterUtils.warn(LOG, e);
                }
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException exc) {
            FlutterUtils.warn(LOG, exc);
            return FileVisitResult.CONTINUE;
        }
    }
}

