/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.run.bazel;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.CommandLineTokenizer;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.lang.dart.sdk.DartConfigurable;
import com.jetbrains.lang.dart.sdk.DartSdk;
import io.flutter.FlutterBundle;
import io.flutter.bazel.Workspace;
import io.flutter.bazel.WorkspaceCache;
import io.flutter.dart.DartPlugin;
import io.flutter.run.FlutterDevice;
import io.flutter.run.common.RunMode;
import io.flutter.run.daemon.DevToolsInstance;
import io.flutter.run.daemon.DevToolsService;
import io.flutter.settings.FlutterSettings;
import io.flutter.utils.ElementIO;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BazelFields {
    private static final Logger LOG = Logger.getInstance(BazelFields.class);
    @Nullable
    private final String target;
    private final boolean enableReleaseMode;
    @Nullable
    private final String bazelArgs;
    @Nullable
    private final DevToolsService devToolsService;
    @Nullable
    private final String additionalArgs;

    BazelFields(@Nullable String target, @Nullable String bazelArgs, @Nullable String additionalArgs, boolean enableReleaseMode) {
        this(target, bazelArgs, additionalArgs, enableReleaseMode, null);
    }

    BazelFields(@Nullable String target, @Nullable String bazelArgs, @Nullable String additionalArgs, boolean enableReleaseMode, @Nullable DevToolsService devToolsService) {
        this.target = target;
        this.bazelArgs = bazelArgs;
        this.additionalArgs = additionalArgs;
        this.enableReleaseMode = enableReleaseMode;
        this.devToolsService = devToolsService;
    }

    BazelFields(@NotNull BazelFields original) {
        if (original == null) {
            BazelFields.$$$reportNull$$$0(0);
        }
        this.target = original.target;
        this.enableReleaseMode = original.enableReleaseMode;
        this.bazelArgs = original.bazelArgs;
        this.additionalArgs = original.additionalArgs;
        this.devToolsService = original.devToolsService;
    }

    @Nullable
    public String getBazelArgs() {
        return this.bazelArgs;
    }

    @Nullable
    public String getAdditionalArgs() {
        return this.additionalArgs;
    }

    @Nullable
    public String getTarget() {
        return this.target;
    }

    public boolean getEnableReleaseMode() {
        return this.enableReleaseMode;
    }

    BazelFields copy() {
        return new BazelFields(this);
    }

    @Nullable
    private String getRunScriptFromWorkspace(@NotNull Project project) {
        Workspace workspace;
        Object runScript;
        if (project == null) {
            BazelFields.$$$reportNull$$$0(1);
        }
        Object object = runScript = (workspace = this.getWorkspace(project)) == null ? null : workspace.getRunScript();
        if (runScript != null) {
            runScript = workspace.getRoot().getPath() + "/" + (String)runScript;
        }
        return runScript;
    }

    private String getToolsScriptFromWorkspace(@NotNull Project project) {
        Workspace workspace;
        Object toolsScript;
        if (project == null) {
            BazelFields.$$$reportNull$$$0(2);
        }
        Object object = toolsScript = (workspace = this.getWorkspace(project)) == null ? null : workspace.getToolsScript();
        if (toolsScript != null) {
            toolsScript = workspace.getRoot().getPath() + File.separatorChar + (String)toolsScript;
        }
        return toolsScript;
    }

    @Nullable
    protected Workspace getWorkspace(@NotNull Project project) {
        if (project == null) {
            BazelFields.$$$reportNull$$$0(3);
        }
        return WorkspaceCache.getInstance(project).get();
    }

    void checkRunnable(@NotNull Project project) throws RuntimeConfigurationError {
        DartSdk sdk;
        if (project == null) {
            BazelFields.$$$reportNull$$$0(4);
        }
        if ((sdk = DartPlugin.getDartSdk(project)) == null) {
            throw new RuntimeConfigurationError(FlutterBundle.message("dart.sdk.is.not.configured", new Object[0]), () -> DartConfigurable.openDartSettings((Project)project));
        }
        String runScript = this.getRunScriptFromWorkspace(project);
        if (runScript == null) {
            throw new RuntimeConfigurationError(FlutterBundle.message("flutter.run.bazel.noLaunchingScript", new Object[0]));
        }
        VirtualFile scriptFile = LocalFileSystem.getInstance().findFileByPath(runScript);
        if (scriptFile == null) {
            throw new RuntimeConfigurationError(FlutterBundle.message("flutter.run.bazel.launchingScriptNotFound", FileUtil.toSystemDependentName((String)runScript)));
        }
        if (StringUtil.isEmptyOrSpaces((String)this.target)) {
            throw new RuntimeConfigurationError(FlutterBundle.message("flutter.run.bazel.noBazelOrDartTargetSet", new Object[0]));
        }
        if (!this.target.endsWith("dart") && !this.target.startsWith("//")) {
            throw new RuntimeConfigurationError(FlutterBundle.message("flutter.run.bazel.startWithSlashSlash", new Object[0]));
        }
    }

    GeneralCommandLine getLaunchCommand(@NotNull Project project, @Nullable FlutterDevice device, @NotNull RunMode mode) throws ExecutionException {
        if (project == null) {
            BazelFields.$$$reportNull$$$0(5);
        }
        if (mode == null) {
            BazelFields.$$$reportNull$$$0(6);
        }
        return this.getLaunchCommand(project, device, mode, false);
    }

    GeneralCommandLine getLaunchCommand(@NotNull Project project, @Nullable FlutterDevice device, @NotNull RunMode mode, boolean isAttach) throws ExecutionException {
        String inputBazelArgs;
        String launchingScript;
        if (project == null) {
            BazelFields.$$$reportNull$$$0(7);
        }
        if (mode == null) {
            BazelFields.$$$reportNull$$$0(8);
        }
        try {
            this.checkRunnable(project);
        }
        catch (RuntimeConfigurationError e) {
            throw new ExecutionException((Throwable)e);
        }
        Workspace workspace = this.getWorkspace(project);
        String string = launchingScript = isAttach ? this.getToolsScriptFromWorkspace(project) : this.getRunScriptFromWorkspace(project);
        assert (launchingScript != null);
        assert (workspace != null);
        String target = this.getTarget();
        assert (target != null);
        String additionalArgs = this.getAdditionalArgs();
        GeneralCommandLine commandLine = new GeneralCommandLine().withWorkDirectory(workspace.getRoot().getPath());
        commandLine.setCharset(StandardCharsets.UTF_8);
        commandLine.setExePath(FileUtil.toSystemDependentName((String)launchingScript));
        if (isAttach) {
            commandLine.addParameter("attach");
        }
        if (!(inputBazelArgs = StringUtil.notNullize((String)this.bazelArgs)).isEmpty()) {
            commandLine.addParameter(String.format("--bazel-options=%s", inputBazelArgs));
        }
        if (this.enableReleaseMode) {
            commandLine.addParameter("--release");
        } else if (mode.equals((Object)RunMode.PROFILE)) {
            commandLine.addParameter("--profile");
        }
        commandLine.addParameter("--machine");
        if (!this.enableReleaseMode && mode == RunMode.DEBUG) {
            commandLine.addParameter("--start-paused");
        }
        CommandLineTokenizer additionalArgsTokenizer = new CommandLineTokenizer(StringUtil.notNullize((String)additionalArgs));
        while (additionalArgsTokenizer.hasMoreTokens()) {
            commandLine.addParameter(additionalArgsTokenizer.nextToken());
        }
        String enableBazelHotRestartParam = "--enable-google3-hot-reload";
        String disableBazelHotRestartParam = "--no-enable-google3-hot-reload";
        boolean hasEnabledArg = StringUtil.notNullize((String)additionalArgs).contains("--enable-google3-hot-reload");
        boolean hasDisabledArg = StringUtil.notNullize((String)additionalArgs).contains("--no-enable-google3-hot-reload");
        if (!FlutterSettings.getInstance().isEnableBazelHotRestart() && hasDisabledArg) {
            Notification notification = new Notification("Flutter Messages", "Google3-specific hot restart is disabled by default", "You can now remove this flag from your configuration's additional args: --no-enable-google3-hot-reload", NotificationType.INFORMATION);
            Notifications.Bus.notify((Notification)notification, (Project)project);
        } else if (FlutterSettings.getInstance().isEnableBazelHotRestart() && !hasEnabledArg && !hasDisabledArg) {
            commandLine.addParameter("--enable-google3-hot-reload");
        }
        if (device != null) {
            commandLine.addParameter("-d");
            commandLine.addParameter(device.deviceId());
            String message = workspace.getUpdatedIosRunMessage();
            if (message != null && FlutterSettings.getInstance().isShowBazelIosRunNotification()) {
                String title = device.isIOS() ? "Running iOS apps has improved!" : "Try running an iOS app!";
                Notification notification = new Notification("Flutter Messages", title, message, NotificationType.INFORMATION);
                Notifications.Bus.notify((Notification)notification, (Project)project);
                FlutterSettings.getInstance().setShowBazelIosRunNotification(false);
            }
        }
        try {
            ProgressManager progress = ProgressManager.getInstance();
            CompletableFuture devToolsFuture = new CompletableFuture();
            progress.runProcessWithProgressSynchronously(() -> {
                progress.getProgressIndicator().setIndeterminate(true);
                try {
                    DevToolsService service = this.devToolsService == null ? DevToolsService.getInstance(project) : this.devToolsService;
                    DevToolsInstance instance = service.getDevToolsInstance().get(30L, TimeUnit.SECONDS);
                    if (instance != null) {
                        devToolsFuture.complete(instance);
                    } else {
                        devToolsFuture.completeExceptionally(new Exception("DevTools instance not available."));
                    }
                }
                catch (Exception e) {
                    devToolsFuture.completeExceptionally(e);
                }
            }, "Starting DevTools", false, project);
            DevToolsInstance instance = (DevToolsInstance)devToolsFuture.get();
            commandLine.addParameter("--devtools-server-address=http://" + instance.host + ":" + instance.port);
        }
        catch (Exception e) {
            LOG.info((Throwable)e);
        }
        commandLine.addParameter(target);
        return commandLine;
    }

    public void writeTo(Element element) {
        ElementIO.addOption(element, "target", this.target);
        ElementIO.addOption(element, "bazelArgs", this.bazelArgs);
        ElementIO.addOption(element, "additionalArgs", this.additionalArgs);
        ElementIO.addOption(element, "enableReleaseMode", Boolean.toString(this.enableReleaseMode));
    }

    public static BazelFields readFrom(Element element) {
        Map<String, String> options = ElementIO.readOptions(element);
        String bazelOrDartTarget = options.get("target") != null ? options.get("target") : options.get("bazelTarget");
        String bazelArgs = options.get("bazelArgs");
        String additionalArgs = options.get("additionalArgs");
        String enableReleaseMode = options.get("enableReleaseMode");
        try {
            return new BazelFields(bazelOrDartTarget, bazelArgs, additionalArgs, Boolean.parseBoolean(enableReleaseMode));
        }
        catch (IllegalArgumentException e) {
            throw new InvalidDataException(e.getMessage());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
        }
        objectArray2[1] = "io/flutter/run/bazel/BazelFields";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getRunScriptFromWorkspace";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getToolsScriptFromWorkspace";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getWorkspace";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "checkRunnable";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getLaunchCommand";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

