/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.run.bazel;

import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.jetbrains.lang.dart.ide.runner.server.ui.DartCommandLineConfigurationEditorForm;
import io.flutter.run.bazel.BazelFields;
import io.flutter.run.bazel.BazelRunConfig;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlutterBazelConfigurationEditorForm
extends SettingsEditor<BazelRunConfig> {
    private JPanel myMainPanel;
    private JTextField myBazelArgs;
    private JTextField myAdditionalArgs;
    private JCheckBox myEnableReleaseModeCheckBox;
    private TextFieldWithBrowseButton myTarget;

    public FlutterBazelConfigurationEditorForm(Project project) {
        this.$$$setupUI$$$();
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFileDescriptor();
        DartCommandLineConfigurationEditorForm.initDartFileTextWithBrowse((Project)project, (TextFieldWithBrowseButton)this.myTarget);
    }

    protected void resetEditorFrom(@NotNull BazelRunConfig configuration) {
        if (configuration == null) {
            FlutterBazelConfigurationEditorForm.$$$reportNull$$$0(0);
        }
        BazelFields fields = configuration.getFields();
        this.myTarget.setText(FileUtil.toSystemDependentName((String)StringUtil.notNullize((String)fields.getTarget())));
        this.myEnableReleaseModeCheckBox.setSelected(fields.getEnableReleaseMode());
        this.myBazelArgs.setText(StringUtil.notNullize((String)fields.getBazelArgs()));
        this.myAdditionalArgs.setText(StringUtil.notNullize((String)fields.getAdditionalArgs()));
    }

    protected void applyEditorTo(@NotNull BazelRunConfig configuration) throws ConfigurationException {
        String target;
        if (configuration == null) {
            FlutterBazelConfigurationEditorForm.$$$reportNull$$$0(1);
        }
        BazelFields fields = new BazelFields(StringUtil.nullize((String)((target = this.myTarget.getText().trim()).endsWith("dart") ? FileUtil.toSystemIndependentName((String)target) : target), (boolean)true), this.getTextValue(this.myBazelArgs), this.getTextValue(this.myAdditionalArgs), this.myEnableReleaseModeCheckBox.isSelected());
        configuration.setFields(fields);
    }

    @NotNull
    protected JComponent createEditor() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            FlutterBazelConfigurationEditorForm.$$$reportNull$$$0(2);
        }
        return jPanel;
    }

    @Nullable
    private String getTextValue(@NotNull JTextField textField) {
        if (textField == null) {
            FlutterBazelConfigurationEditorForm.$$$reportNull$$$0(3);
        }
        return StringUtil.nullize((String)textField.getText().trim(), (boolean)true);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JTextField jTextField;
        JCheckBox jCheckBox;
        JTextField jTextField2;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(9, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(8, 0, 1, 2, 0, 2, 1, 6, null, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setText("Additional args:");
        jLabel.setDisplayedMnemonic('A');
        jLabel.setDisplayedMnemonicIndex(11);
        jPanel.add((Component)jLabel, new GridConstraints(6, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        ((Component)jLabel2).setEnabled(false);
        jLabel2.setText("Additional arguments to pass to the Flutter runner (e.g. --enable-software-rendering).");
        jPanel.add((Component)jLabel2, new GridConstraints(7, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myAdditionalArgs = jTextField2 = new JTextField();
        jPanel.add((Component)jTextField2, new GridConstraints(6, 2, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myEnableReleaseModeCheckBox = jCheckBox = new JCheckBox();
        ((Component)jCheckBox).setEnabled(true);
        jCheckBox.setSelected(false);
        jCheckBox.setText("Enable release mode, --define flutter_build_mode=release");
        jPanel.add((Component)jCheckBox, new GridConstraints(2, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Release mode:");
        jLabel3.setDisplayedMnemonic('R');
        jLabel3.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel3, new GridConstraints(2, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        JLabel jLabel4 = new JLabel();
        ((Component)jLabel4).setEnabled(false);
        jLabel4.setText("Release mode does not support debugging, and a physical device will be required when launching.");
        jPanel.add((Component)jLabel4, new GridConstraints(3, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel5 = new JLabel();
        jLabel5.setText("Bazel args");
        jPanel.add((Component)jLabel5, new GridConstraints(4, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        JLabel jLabel6 = new JLabel();
        ((Component)jLabel6).setEnabled(false);
        jLabel6.setText("Additional arguments to pass to the Bazel runtime (e.g. --define=release_channel=beta3)");
        jPanel.add((Component)jLabel6, new GridConstraints(5, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myBazelArgs = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(4, 2, 1, 1, 0, 1, 6, 0, null, null, null));
        JLabel jLabel7 = new JLabel();
        ((Component)jLabel7).setEnabled(false);
        jLabel7.setText("The Bazel target (e.g. //a/b/c:name) or entrypoint for the application (e.g. main.dart)");
        jPanel.add((Component)jLabel7, new GridConstraints(1, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel8 = new JLabel();
        jLabel8.setText("Target or Dart entrypoint:");
        jLabel8.setVerifyInputWhenFocusTarget(false);
        jPanel.add((Component)jLabel8, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myTarget = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        textFieldWithBrowseButton.setFocusable(true);
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 2, 1, 1, 0, 1, 3, 3, null, null, null));
        jLabel.setLabelFor(jTextField2);
        jLabel5.setLabelFor(jTextField2);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/run/bazel/FlutterBazelConfigurationEditorForm";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textField";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/run/bazel/FlutterBazelConfigurationEditorForm";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getTextValue";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

