/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.run.bazel;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.ConfigurationTypeBase;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationSingletonPolicy;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.jetbrains.lang.dart.DartFileType;
import icons.FlutterIcons;
import io.flutter.FlutterBundle;
import io.flutter.run.bazel.BazelRunConfig;
import io.flutter.utils.FlutterModuleUtils;
import org.jetbrains.annotations.NotNull;

public class FlutterBazelRunConfigurationType
extends ConfigurationTypeBase {
    @VisibleForTesting
    final Factory factory = new Factory(this);

    public FlutterBazelRunConfigurationType() {
        super("FlutterBazelRunConfigurationType", FlutterBundle.message("runner.flutter.bazel.configuration.name", new Object[0]), FlutterBundle.message("runner.flutter.bazel.configuration.description", new Object[0]), FlutterIcons.BazelRun);
        this.addFactory(this.factory);
    }

    public static boolean doShowBazelRunConfigurationForProject(@NotNull Project project) {
        if (project == null) {
            FlutterBazelRunConfigurationType.$$$reportNull$$$0(0);
        }
        return FileTypeIndex.containsFileOfType((FileType)DartFileType.INSTANCE, (GlobalSearchScope)GlobalSearchScope.projectScope((Project)project)) && FlutterModuleUtils.isFlutterBazelProject(project);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "io/flutter/run/bazel/FlutterBazelRunConfigurationType", "doShowBazelRunConfigurationForProject"));
    }

    @VisibleForTesting
    static class Factory
    extends ConfigurationFactory {
        public Factory(FlutterBazelRunConfigurationType type) {
            super((ConfigurationType)type);
        }

        @NotNull
        public RunConfiguration createTemplateConfiguration(@NotNull Project project) {
            if (project == null) {
                Factory.$$$reportNull$$$0(0);
            }
            return new BazelRunConfig(project, this, FlutterBundle.message("runner.flutter.bazel.configuration.name", new Object[0]));
        }

        @NotNull
        public RunConfiguration createConfiguration(String name, @NotNull RunConfiguration template) {
            if (template == null) {
                Factory.$$$reportNull$$$0(1);
            }
            if (this.isNewlyGeneratedName(name) && template instanceof BazelRunConfig) {
                name = template.getProject().getName();
                RunConfiguration runConfiguration = ((BazelRunConfig)template).copyTemplateToNonTemplate(name);
                if (runConfiguration == null) {
                    Factory.$$$reportNull$$$0(2);
                }
                return runConfiguration;
            }
            RunConfiguration runConfiguration = super.createConfiguration(name, template);
            if (runConfiguration == null) {
                Factory.$$$reportNull$$$0(3);
            }
            return runConfiguration;
        }

        private boolean isNewlyGeneratedName(String name) {
            String baseName = ExecutionBundle.message((String)"run.configuration.unnamed.name.prefix", (Object[])new Object[0]);
            return name.equals(baseName) || name.startsWith(baseName + " (");
        }

        public boolean isApplicable(@NotNull Project project) {
            if (project == null) {
                Factory.$$$reportNull$$$0(4);
            }
            return FlutterBazelRunConfigurationType.doShowBazelRunConfigurationForProject(project);
        }

        @NotNull
        public String getId() {
            String string = FlutterBundle.message("runner.flutter.bazel.configuration.name", new Object[0]);
            if (string == null) {
                Factory.$$$reportNull$$$0(5);
            }
            return string;
        }

        @NotNull
        public RunConfigurationSingletonPolicy getSingletonPolicy() {
            RunConfigurationSingletonPolicy runConfigurationSingletonPolicy = RunConfigurationSingletonPolicy.MULTIPLE_INSTANCE_ONLY;
            if (runConfigurationSingletonPolicy == null) {
                Factory.$$$reportNull$$$0(6);
            }
            return runConfigurationSingletonPolicy;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3, 5, 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "template";
                    break;
                }
                case 2: 
                case 3: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "io/flutter/run/bazel/FlutterBazelRunConfigurationType$Factory";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "io/flutter/run/bazel/FlutterBazelRunConfigurationType$Factory";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createConfiguration";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getId";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSingletonPolicy";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "createTemplateConfiguration";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "createConfiguration";
                    break;
                }
                case 2: 
                case 3: 
                case 5: 
                case 6: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "isApplicable";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3, 5, 6 -> new IllegalStateException(string);
            };
        }
    }
}

