/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.run.bazelTest;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.jetbrains.lang.dart.psi.DartFile;
import io.flutter.FlutterUtils;
import io.flutter.bazel.Workspace;
import io.flutter.bazel.WorkspaceCache;
import io.flutter.dart.DartPlugin;
import io.flutter.run.FlutterRunConfigurationProducer;
import io.flutter.run.bazelTest.BazelTestConfig;
import io.flutter.run.bazelTest.BazelTestConfigUtils;
import io.flutter.run.bazelTest.BazelTestFields;
import io.flutter.run.bazelTest.FlutterBazelTestConfigurationType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BazelTestConfigProducer
extends RunConfigurationProducer<BazelTestConfig> {
    private final BazelTestConfigUtils bazelTestConfigUtils;

    protected BazelTestConfigProducer() {
        this(FlutterBazelTestConfigurationType.getInstance().factory);
    }

    protected BazelTestConfigProducer(@NotNull ConfigurationFactory factory) {
        if (factory == null) {
            BazelTestConfigProducer.$$$reportNull$$$0(0);
        }
        super(factory);
        this.bazelTestConfigUtils = BazelTestConfigUtils.getInstance();
    }

    @VisibleForTesting
    BazelTestConfigProducer(BazelTestConfigUtils bazelTestConfigUtils) {
        super((ConfigurationType)FlutterBazelTestConfigurationType.getInstance());
        this.bazelTestConfigUtils = bazelTestConfigUtils;
    }

    private boolean isBazelFlutterContext(@NotNull ConfigurationContext context) {
        PsiElement location;
        if (context == null) {
            BazelTestConfigProducer.$$$reportNull$$$0(1);
        }
        return (location = context.getPsiLocation()) != null && this.getWorkspace(context.getProject()) != null;
    }

    @VisibleForTesting
    @Nullable
    protected Workspace getWorkspace(@NotNull Project project) {
        if (project == null) {
            BazelTestConfigProducer.$$$reportNull$$$0(2);
        }
        return WorkspaceCache.getInstance(project).get();
    }

    protected boolean setupConfigurationFromContext(@NotNull BazelTestConfig config, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElement) {
        if (config == null) {
            BazelTestConfigProducer.$$$reportNull$$$0(3);
        }
        if (context == null) {
            BazelTestConfigProducer.$$$reportNull$$$0(4);
        }
        if (sourceElement == null) {
            BazelTestConfigProducer.$$$reportNull$$$0(5);
        }
        if (!this.isBazelFlutterContext(context)) {
            return false;
        }
        PsiElement elt = context.getPsiLocation();
        DartFile file = FlutterUtils.getDartFile(elt);
        if (file == null) {
            return false;
        }
        String testName = this.bazelTestConfigUtils.findTestName(elt);
        if (testName != null) {
            return this.setupForSingleTest(config, context, file, testName);
        }
        return this.setupForDartFile(config, context, file);
    }

    private boolean setupForSingleTest(@NotNull BazelTestConfig config, @NotNull ConfigurationContext context, @NotNull DartFile file, @NotNull String testName) {
        VirtualFile testFile;
        if (config == null) {
            BazelTestConfigProducer.$$$reportNull$$$0(6);
        }
        if (context == null) {
            BazelTestConfigProducer.$$$reportNull$$$0(7);
        }
        if (file == null) {
            BazelTestConfigProducer.$$$reportNull$$$0(8);
        }
        if (testName == null) {
            BazelTestConfigProducer.$$$reportNull$$$0(9);
        }
        if ((testFile = this.verifyFlutterTestFile(config, context, file)) == null) {
            return false;
        }
        config.setFields(BazelTestFields.forTestName(testName, testFile.getPath(), config.getFields().getAdditionalArgs()));
        config.setGeneratedName();
        config.setName("Run '" + testName + "' in '" + file.getName() + "'");
        return true;
    }

    private boolean setupForDartFile(@NotNull BazelTestConfig config, @NotNull ConfigurationContext context, @NotNull DartFile file) {
        VirtualFile testFile;
        if (config == null) {
            BazelTestConfigProducer.$$$reportNull$$$0(10);
        }
        if (context == null) {
            BazelTestConfigProducer.$$$reportNull$$$0(11);
        }
        if (file == null) {
            BazelTestConfigProducer.$$$reportNull$$$0(12);
        }
        if ((testFile = this.verifyFlutterTestFile(config, context, file)) == null) {
            return false;
        }
        config.setFields(BazelTestFields.forFile(testFile.getPath(), config.getFields().getAdditionalArgs()));
        config.setName("Run '" + file.getName() + "'");
        return true;
    }

    @Nullable
    @VisibleForTesting
    VirtualFile verifyFlutterTestFile(@NotNull BazelTestConfig config, @NotNull ConfigurationContext context, @NotNull DartFile file) {
        VirtualFile candidate;
        if (config == null) {
            BazelTestConfigProducer.$$$reportNull$$$0(13);
        }
        if (context == null) {
            BazelTestConfigProducer.$$$reportNull$$$0(14);
        }
        if (file == null) {
            BazelTestConfigProducer.$$$reportNull$$$0(15);
        }
        if ((candidate = FlutterRunConfigurationProducer.getFlutterEntryFile(context, false, false)) == null) {
            return null;
        }
        return file.getVirtualFile().getPath().contains("/test/") ? candidate : null;
    }

    public boolean isConfigurationFromContext(@NotNull BazelTestConfig config, @NotNull ConfigurationContext context) {
        if (config == null) {
            BazelTestConfigProducer.$$$reportNull$$$0(16);
        }
        if (context == null) {
            BazelTestConfigProducer.$$$reportNull$$$0(17);
        }
        if (!StringUtil.equals((CharSequence)this.getId(config), (CharSequence)this.getConfigurationFactory().getId())) {
            return false;
        }
        VirtualFile file = config.getFields().getFile();
        if (file == null) {
            return false;
        }
        PsiElement target = context.getPsiLocation();
        if (target instanceof PsiDirectory) {
            return ((PsiDirectory)target).getVirtualFile().equals(file);
        }
        if (!FlutterRunConfigurationProducer.hasDartFile(context, file.getPath())) {
            return false;
        }
        String testName = this.bazelTestConfigUtils.findTestName(context.getPsiLocation());
        if (config.getFields().getTestName() != null) {
            return testName != null && testName.equals(config.getFields().getTestName());
        }
        return testName == null;
    }

    public boolean shouldReplace(@NotNull ConfigurationFromContext self, @NotNull ConfigurationFromContext other) {
        if (self == null) {
            BazelTestConfigProducer.$$$reportNull$$$0(18);
        }
        if (other == null) {
            BazelTestConfigProducer.$$$reportNull$$$0(19);
        }
        return DartPlugin.isDartTestConfiguration(other.getConfigurationType());
    }

    @NotNull
    private String getId(BazelTestConfig config) {
        return config.getFields().isWatchConfig() ? "Watch" : "No Watch";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 11: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 6: 
            case 10: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceElement";
                break;
            }
            case 8: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testName";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "self";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
        }
        objectArray2[1] = "io/flutter/run/bazelTest/BazelTestConfigProducer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isBazelFlutterContext";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getWorkspace";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "setupConfigurationFromContext";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "setupForSingleTest";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "setupForDartFile";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "verifyFlutterTestFile";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "isConfigurationFromContext";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldReplace";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

