/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.run.bazelTest;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.CommandLineTokenizer;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.lang.dart.sdk.DartConfigurable;
import com.jetbrains.lang.dart.sdk.DartSdk;
import io.flutter.FlutterBundle;
import io.flutter.bazel.Workspace;
import io.flutter.bazel.WorkspaceCache;
import io.flutter.dart.DartPlugin;
import io.flutter.run.MainFile;
import io.flutter.run.common.RunMode;
import io.flutter.sdk.FlutterSettingsConfigurable;
import io.flutter.utils.ElementIO;
import io.flutter.utils.MostlySilentColoredProcessHandler;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BazelTestFields {
    @Nullable
    private final String testName;
    @Nullable
    private final String entryFile;
    @Nullable
    private final String bazelTarget;
    @Nullable
    private final String additionalArgs;

    BazelTestFields(@Nullable String testName, @Nullable String entryFile, @Nullable String bazelTarget, @Nullable String additionalArgs) {
        if (testName != null && entryFile == null) {
            throw new IllegalArgumentException("testName must be specified with an entryFile");
        }
        this.testName = testName;
        this.entryFile = entryFile;
        this.bazelTarget = bazelTarget;
        this.additionalArgs = additionalArgs;
    }

    BazelTestFields(@NotNull BazelTestFields template) {
        if (template == null) {
            BazelTestFields.$$$reportNull$$$0(0);
        }
        this(template.testName, template.entryFile, template.bazelTarget, template.additionalArgs);
    }

    private String getTestScriptFromWorkspace(@NotNull Project project) {
        if (project == null) {
            BazelTestFields.$$$reportNull$$$0(1);
        }
        Workspace workspace = this.getWorkspace(project);
        assert (workspace != null);
        Object testScript = workspace.getTestScript();
        assert (testScript != null);
        testScript = workspace.getRoot().getPath() + "/" + (String)testScript;
        return testScript;
    }

    @NotNull
    public static BazelTestFields forTestName(@NotNull String testName, @NotNull String path, @Nullable String additionalArgs) {
        if (testName == null) {
            BazelTestFields.$$$reportNull$$$0(2);
        }
        if (path == null) {
            BazelTestFields.$$$reportNull$$$0(3);
        }
        return new BazelTestFields(testName, path, null, additionalArgs);
    }

    public static BazelTestFields forFile(@NotNull String path, @Nullable String additionalArgs) {
        if (path == null) {
            BazelTestFields.$$$reportNull$$$0(4);
        }
        return new BazelTestFields(null, path, null, additionalArgs);
    }

    public static BazelTestFields forTarget(@NotNull String target, @Nullable String additionalArgs) {
        if (target == null) {
            BazelTestFields.$$$reportNull$$$0(5);
        }
        return new BazelTestFields(null, null, target, additionalArgs);
    }

    @Nullable
    public String getTestName() {
        return this.testName;
    }

    @Nullable
    public String getEntryFile() {
        return this.entryFile;
    }

    @Nullable
    public VirtualFile getFile() {
        String path = this.getEntryFile();
        if (path == null) {
            return null;
        }
        return LocalFileSystem.getInstance().findFileByPath(path);
    }

    @Nullable
    public String getBazelTarget() {
        return this.bazelTarget;
    }

    @Nullable
    public String getAdditionalArgs() {
        return this.additionalArgs;
    }

    @NotNull
    BazelTestFields copy() {
        return new BazelTestFields(this);
    }

    @NotNull
    BazelTestFields copyTemplateToNonTemplate(@NotNull Project project) {
        if (project == null) {
            BazelTestFields.$$$reportNull$$$0(6);
        }
        return new BazelTestFields(this);
    }

    void checkRunnable(@NotNull Project project) throws RuntimeConfigurationError {
        DartSdk sdk;
        if (project == null) {
            BazelTestFields.$$$reportNull$$$0(7);
        }
        if ((sdk = DartPlugin.getDartSdk(project)) == null) {
            throw new RuntimeConfigurationError(FlutterBundle.message("dart.sdk.is.not.configured", new Object[0]), () -> DartConfigurable.openDartSettings((Project)project));
        }
        this.getScope(project).checkRunnable(this, project);
    }

    @NotNull
    ProcessHandler run(@NotNull Project project, @NotNull RunMode mode) throws ExecutionException {
        if (project == null) {
            BazelTestFields.$$$reportNull$$$0(8);
        }
        if (mode == null) {
            BazelTestFields.$$$reportNull$$$0(9);
        }
        return new MostlySilentColoredProcessHandler(this.getLaunchCommand(project, mode));
    }

    @NotNull
    GeneralCommandLine getLaunchCommand(@NotNull Project project, @NotNull RunMode mode) throws ExecutionException {
        if (project == null) {
            BazelTestFields.$$$reportNull$$$0(10);
        }
        if (mode == null) {
            BazelTestFields.$$$reportNull$$$0(11);
        }
        try {
            this.checkRunnable(project);
        }
        catch (RuntimeConfigurationError e) {
            throw new ExecutionException((Throwable)e);
        }
        Workspace workspace = this.getWorkspace(project);
        String launchingScript = this.getTestScriptFromWorkspace(project);
        assert (launchingScript != null);
        GeneralCommandLine commandLine = new GeneralCommandLine().withWorkDirectory(workspace.getRoot().getPath());
        commandLine.setCharset(StandardCharsets.UTF_8);
        commandLine.setExePath(FileUtil.toSystemDependentName((String)launchingScript));
        String nonNullArgs = StringUtil.notNullize((String)this.additionalArgs);
        CommandLineTokenizer testArgsTokenizer = new CommandLineTokenizer(nonNullArgs);
        while (testArgsTokenizer.hasMoreTokens()) {
            commandLine.addParameter(testArgsTokenizer.nextToken());
        }
        commandLine.addParameter(Flags.noColor);
        if (!nonNullArgs.contains(Flags.noMachine)) {
            commandLine.addParameter(Flags.machine);
        }
        String relativeEntryFilePath = this.entryFile == null ? null : FileUtil.getRelativePath((String)workspace.getRoot().getPath(), (String)this.entryFile, (char)'/');
        switch (this.getScope(project)) {
            case NAME: {
                commandLine.addParameters(new String[]{Flags.name, this.testName});
                commandLine.addParameter(relativeEntryFilePath);
                break;
            }
            case FILE: {
                commandLine.addParameter(relativeEntryFilePath);
                break;
            }
            case TARGET_PATTERN: {
                commandLine.addParameter(this.bazelTarget);
            }
        }
        if (mode == RunMode.DEBUG) {
            commandLine.addParameters(new String[]{Flags.separator, Flags.enableDebugging});
        }
        GeneralCommandLine generalCommandLine = commandLine;
        if (generalCommandLine == null) {
            BazelTestFields.$$$reportNull$$$0(12);
        }
        return generalCommandLine;
    }

    @Nullable
    protected Workspace getWorkspace(@NotNull Project project) {
        if (project == null) {
            BazelTestFields.$$$reportNull$$$0(13);
        }
        return WorkspaceCache.getInstance(project).get();
    }

    protected void verifyMainFile(Project project) throws RuntimeConfigurationError {
        MainFile.Result main = MainFile.verify(this.entryFile, project);
        if (!main.canLaunch()) {
            throw new RuntimeConfigurationError(main.getError());
        }
    }

    public boolean isWatchConfig() {
        return this.getAdditionalArgs() != null && this.getAdditionalArgs().contains(Flags.watch);
    }

    @NotNull
    public Scope getScope(@NotNull Project project) {
        if (project == null) {
            BazelTestFields.$$$reportNull$$$0(14);
        }
        if (this.testName != null && this.entryFile != null) {
            Scope scope = Scope.NAME;
            if (scope == null) {
                BazelTestFields.$$$reportNull$$$0(15);
            }
            return scope;
        }
        if (this.entryFile != null) {
            Scope scope = Scope.FILE;
            if (scope == null) {
                BazelTestFields.$$$reportNull$$$0(16);
            }
            return scope;
        }
        Scope scope = Scope.TARGET_PATTERN;
        if (scope == null) {
            BazelTestFields.$$$reportNull$$$0(17);
        }
        return scope;
    }

    public void writeTo(Element element) {
        ElementIO.addOption(element, "testName", this.testName);
        ElementIO.addOption(element, "entryFile", this.entryFile);
        ElementIO.addOption(element, "bazelTarget", this.bazelTarget);
        ElementIO.addOption(element, "additionalArgs", this.additionalArgs);
    }

    public static BazelTestFields readFrom(Element element) {
        Map<String, String> options = ElementIO.readOptions(element);
        String testName = options.get("testName");
        String entryFile = options.get("entryFile");
        String bazelTarget = options.get("bazelTarget");
        String additionalArgs = options.get("additionalArgs");
        try {
            return new BazelTestFields(testName, entryFile, bazelTarget, additionalArgs);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidDataException(e.getMessage());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 12, 15, 16, 17 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testName";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 12: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/run/bazelTest/BazelTestFields";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/run/bazelTest/BazelTestFields";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getLaunchCommand";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getTestScriptFromWorkspace";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "forTestName";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "forFile";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "forTarget";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "copyTemplateToNonTemplate";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "checkRunnable";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "run";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getLaunchCommand";
                break;
            }
            case 12: 
            case 15: 
            case 16: 
            case 17: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getWorkspace";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getScope";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 12, 15, 16, 17 -> new IllegalStateException(string);
        };
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum Scope {
        NAME("Tests in file, filtered by name"){

            @Override
            public void checkRunnable(@NotNull BazelTestFields fields, @NotNull Project project) throws RuntimeConfigurationError {
                if (fields == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (project == null) {
                    1.$$$reportNull$$$0(1);
                }
                FILE.checkRunnable(fields, project);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "fields";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "project";
                        break;
                    }
                }
                objectArray[1] = "io/flutter/run/bazelTest/BazelTestFields$Scope$1";
                objectArray[2] = "checkRunnable";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
        ,
        FILE("All tests in a file"){

            @Override
            public void checkRunnable(@NotNull BazelTestFields fields, @NotNull Project project) throws RuntimeConfigurationError {
                Workspace workspace;
                if (fields == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (project == null) {
                    2.$$$reportNull$$$0(1);
                }
                if ((workspace = fields.getWorkspace(project)) == null || workspace.getTestScript() == null) {
                    throw new RuntimeConfigurationError(FlutterBundle.message("flutter.run.bazel.newBazelTestRunnerUnavailable", new Object[0]), () -> FlutterSettingsConfigurable.openFlutterSettings(project));
                }
                fields.verifyMainFile(project);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "fields";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "project";
                        break;
                    }
                }
                objectArray[1] = "io/flutter/run/bazelTest/BazelTestFields$Scope$2";
                objectArray[2] = "checkRunnable";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
        ,
        TARGET_PATTERN("All tests in a bazel target or matching a bazel target pattern"){

            @Override
            public void checkRunnable(@NotNull BazelTestFields fields, @NotNull Project project) throws RuntimeConfigurationError {
                if (fields == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (project == null) {
                    3.$$$reportNull$$$0(1);
                }
                if (StringUtil.isEmptyOrSpaces((String)fields.getBazelTarget())) {
                    throw new RuntimeConfigurationError(FlutterBundle.message("flutter.run.bazel.noTargetSet", new Object[0]));
                }
                if (!fields.getBazelTarget().startsWith("//")) {
                    throw new RuntimeConfigurationError(FlutterBundle.message("flutter.run.bazel.startWithSlashSlash", new Object[0]));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "fields";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "project";
                        break;
                    }
                }
                objectArray[1] = "io/flutter/run/bazelTest/BazelTestFields$Scope$3";
                objectArray[2] = "checkRunnable";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };

        private final String displayName;

        private Scope(String displayName) {
            this.displayName = displayName;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public abstract void checkRunnable(@NotNull BazelTestFields var1, @NotNull Project var2) throws RuntimeConfigurationError;
    }

    static final class Flags {
        static String watch = "--watch";
        static String noColor = "--no-color";
        static String name = "--name";
        static String enableDebugging = "--enable-debugging";
        static String separator = "--";
        static String machine = "--machine";
        static String noMachine = "--no-machine";

        private Flags() {
        }
    }
}

