/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.run.bazelTest;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.CommandLineState;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.UrlFilter;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.sm.SMTestRunnerConnectionUtil;
import com.intellij.execution.testframework.ui.BaseTestsOutputConsoleView;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.lang.dart.ide.runner.DartConsoleFilter;
import com.jetbrains.lang.dart.ide.runner.DartRelativePathsConsoleFilter;
import com.jetbrains.lang.dart.util.DartUrlResolver;
import io.flutter.bazel.Workspace;
import io.flutter.bazel.WorkspaceCache;
import io.flutter.run.bazelTest.BazelTestConfig;
import io.flutter.run.bazelTest.BazelTestFields;
import io.flutter.run.common.ConsoleProps;
import io.flutter.run.common.RunMode;
import io.flutter.run.daemon.DaemonConsoleView;
import io.flutter.utils.FlutterModuleUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BazelTestLaunchState
extends CommandLineState {
    @NotNull
    private final BazelTestConfig config;
    @NotNull
    private final BazelTestFields fields;
    @NotNull
    private final VirtualFile testFile;

    protected BazelTestLaunchState(ExecutionEnvironment env, @NotNull BazelTestConfig config, @Nullable VirtualFile testFile) {
        if (config == null) {
            BazelTestLaunchState.$$$reportNull$$$0(0);
        }
        super(env);
        this.config = config;
        this.fields = config.getFields();
        if (testFile == null) {
            Workspace workspace = WorkspaceCache.getInstance(env.getProject()).get();
            assert (workspace != null);
            testFile = workspace.getRoot();
        }
        this.testFile = testFile;
    }

    @NotNull
    VirtualFile getTestFile() {
        VirtualFile virtualFile = this.testFile;
        if (virtualFile == null) {
            BazelTestLaunchState.$$$reportNull$$$0(1);
        }
        return virtualFile;
    }

    @NotNull
    protected ProcessHandler startProcess() throws ExecutionException {
        RunMode mode = RunMode.fromEnv(this.getEnvironment());
        ProcessHandler processHandler = this.fields.run(this.getEnvironment().getProject(), mode);
        if (processHandler == null) {
            BazelTestLaunchState.$$$reportNull$$$0(2);
        }
        return processHandler;
    }

    public static BazelTestLaunchState create(@NotNull ExecutionEnvironment env, @NotNull BazelTestConfig config) throws ExecutionException {
        if (env == null) {
            BazelTestLaunchState.$$$reportNull$$$0(3);
        }
        if (config == null) {
            BazelTestLaunchState.$$$reportNull$$$0(4);
        }
        BazelTestFields fields = config.getFields();
        try {
            fields.checkRunnable(env.getProject());
        }
        catch (RuntimeConfigurationError e) {
            throw new ExecutionException((Throwable)e);
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        VirtualFile virtualFile = fields.getFile();
        BazelTestLaunchState launcher = new BazelTestLaunchState(env, config, virtualFile);
        Workspace workspace = FlutterModuleUtils.getFlutterBazelWorkspace(env.getProject());
        if (workspace != null) {
            DaemonConsoleView.install(launcher, env, workspace.getRoot());
        }
        return launcher;
    }

    @Nullable
    protected ConsoleView createConsole(@NotNull Executor executor) throws ExecutionException {
        if (executor == null) {
            BazelTestLaunchState.$$$reportNull$$$0(5);
        }
        if (this.fields.getAdditionalArgs() != null && this.fields.getAdditionalArgs().contains(BazelTestFields.Flags.noMachine)) {
            return super.createConsole(executor);
        }
        Project project = this.getEnvironment().getProject();
        Workspace workspace = WorkspaceCache.getInstance(project).get();
        if (workspace == null) {
            return super.createConsole(executor);
        }
        DartUrlResolver resolver = DartUrlResolver.getInstance((Project)project, (VirtualFile)workspace.getRoot());
        ConsoleProps props = ConsoleProps.forBazel(this.config, executor, resolver);
        BaseTestsOutputConsoleView console = SMTestRunnerConnectionUtil.createConsole((String)ConsoleProps.bazelFrameworkName, (TestConsoleProperties)props);
        console.addMessageFilter((Filter)new DartConsoleFilter(project, this.testFile));
        String baseDir = workspace.getRoot().getPath();
        console.addMessageFilter((Filter)new DartRelativePathsConsoleFilter(project, baseDir));
        console.addMessageFilter((Filter)new UrlFilter());
        return console;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/run/bazelTest/BazelTestLaunchState";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/run/bazelTest/BazelTestLaunchState";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "startProcess";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createConsole";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

